/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.properties;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.openide.nodes.PropertySupport;

public abstract class DefaultPropertySupport
extends PropertySupport {
    public static final String PROPERTY_VALUE_NULL = "PROPERTY_NULL_VALUE_FOR_FEATURE_DESCRIPTOR";
    public static final String PROPERYT_INPLACE_EDITOR = "inplaceEditor";
    public static final String PROPERTY_CUSTOM_EDITOR_TITLE = "title";
    private PropertyValue propertyValue;
    private PropertyEditor propertyEditor;
    private List<String> propertyNames;
    private DesignPropertyDescriptor designPropertyDescriptor;

    DefaultPropertySupport(DesignPropertyDescriptor designerPropertyDescriptor, Class type) {
        super(designerPropertyDescriptor.getPropertyNames().iterator().next(), type, designerPropertyDescriptor.getPropertyDisplayName(), designerPropertyDescriptor.getPropertyToolTip(), true, true);
        this.designPropertyDescriptor = designerPropertyDescriptor;
        this.propertyEditor = designerPropertyDescriptor.getPropertyEditor();
        this.propertyNames = designerPropertyDescriptor.getPropertyNames();
        this.update();
        if (this.getPropertyEditor() instanceof DesignPropertyEditor && ((DesignPropertyEditor)this.getPropertyEditor()).getInplaceEditor() != null) {
            this.setValue(PROPERYT_INPLACE_EDITOR, ((DesignPropertyEditor)this.getPropertyEditor()).getInplaceEditor());
        }
    }

    public PropertyEditor getPropertyEditor() {
        if (this.propertyEditor != null) {
            return this.propertyEditor;
        }
        return super.getPropertyEditor();
    }

    protected PropertyValue readPropertyValue(final DesignComponent component, final String propertyName) {
        assert (component != null);
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DefaultPropertySupport.this.propertyValue = component.readProperty(propertyName);
            }
        });
        return this.propertyValue;
    }

    public boolean canWrite() {
        if (this.propertyEditor instanceof DesignPropertyEditor) {
            return ((DesignPropertyEditor)this.propertyEditor).canWrite();
        }
        return super.canWrite();
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        if (this.propertyEditor instanceof DesignPropertyEditor && this.propertyNames != null && !this.propertyNames.isEmpty()) {
            final DesignPropertyEditor dpe = (DesignPropertyEditor)this.propertyEditor;
            if (dpe.isResetToDefaultAutomatically()) {
                this.setValue(dpe.getDefaultValue());
            } else {
                this.designPropertyDescriptor.getComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        dpe.customEditorResetToDefaultButtonPressed();
                    }
                });
            }
        } else {
            super.restoreDefaultValue();
        }
    }

    public boolean isDefaultValue() {
        if (this.propertyEditor instanceof DesignPropertyEditor) {
            return ((DesignPropertyEditor)this.propertyEditor).isDefaultValue();
        }
        return super.isDefaultValue();
    }

    public boolean supportsDefaultValue() {
        if (this.propertyEditor instanceof DesignPropertyEditor) {
            return ((DesignPropertyEditor)this.propertyEditor).supportsDefaultValue();
        }
        return super.supportsDefaultValue();
    }

    protected DesignPropertyDescriptor getDesignPropertyDescriptor() {
        return this.designPropertyDescriptor;
    }

    protected abstract void update();
}

