/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

class JavaDBAdapter
extends RailsDatabaseConfiguration {
    JavaDBAdapter() {
    }

    @Override
    public String railsGenerationParam() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "javadb";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editConfig(RailsProject project) {
        FileObject fo = project.getProjectDirectory().getFileObject("config/database.yml");
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (fo != null) {
            BaseDocument bdoc = null;
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    if (doc instanceof BaseDocument) {
                        bdoc = (BaseDocument)doc;
                        bdoc.atomicLock();
                    }
                    doc.remove(0, doc.getLength());
                    String insert = "# JavaDB Setup\n#\n# You may need to copy derby.jar into\n#  TODO: location " + platform.getLibDir() + "\n" + "# With Java SE 6 and later this is not necessary.\n" + "development:\n" + "  adapter: derby\n" + "  database: db/development.db\n" + "\n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + "  adapter: derby\n" + "  database: db/test.db\n" + "\n" + "production:\n" + "  adapter: derby\n" + "  database: db/production.db\n";
                    doc.insertString(0, insert, null);
                    SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            finally {
                if (bdoc != null) {
                    bdoc.atomicUnlock();
                }
            }
        }
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return new JdbcInfo(){

            @Override
            public String getDriverClass() {
                return "org.apache.derby.jdbc.ClientDriver";
            }

            @Override
            public String getURL(String host, String database) {
                return "jdbc:derby://" + host + ":1527/" + database;
            }
        };
    }

    @Override
    public String getDatabaseName(String projectName) {
        return "db/development.db";
    }

    @Override
    public String getTestDatabaseName(String developmentDbName) {
        return "db/test.db";
    }

    @Override
    public String getProductionDatabaseName(String developmentDbName) {
        return "db/production.db";
    }
}

