/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class RailsProjectUtil {
    private RailsProjectUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String asText(File toRead) {
        BufferedReader fr = null;
        try {
            String line;
            fr = new BufferedReader(new FileReader(toRead));
            StringBuilder sb = new StringBuilder();
            while ((line = fr.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return "";
    }

    public static String getVersionString(File versionFile) {
        try {
            String s;
            Pattern VERSION_ELEMENT = Pattern.compile("\\s*[A-Z]+\\s*=\\s*(\\d+)\\s*");
            BufferedReader br = new BufferedReader(new FileReader(versionFile));
            int major = 0;
            int minor = 0;
            int tiny = 0;
            for (int line = 0; line < 10 && (s = br.readLine()) != null; ++line) {
                Matcher m;
                if (s.indexOf("MAJOR") != -1) {
                    m = VERSION_ELEMENT.matcher(s);
                    if (!m.matches()) continue;
                    major = Integer.parseInt(m.group(1));
                    continue;
                }
                if (s.indexOf("MINOR") != -1) {
                    m = VERSION_ELEMENT.matcher(s);
                    if (!m.matches()) continue;
                    minor = Integer.parseInt(m.group(1));
                    continue;
                }
                if (s.indexOf("TINY") == -1 || !(m = VERSION_ELEMENT.matcher(s)).matches()) continue;
                tiny = Integer.parseInt(m.group(1));
            }
            br.close();
            return major + "." + minor + "." + tiny;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    public static RailsVersion getRailsVersion(Project project) {
        String specifiedVersion;
        FileObject environment;
        File versionFile;
        String version;
        FileObject versionFo;
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)project);
        String railsVersion = gemManager.getLatestVersion("rails");
        FileObject railsPlugin = project.getProjectDirectory().getFileObject("vendor/rails/railties");
        if (railsPlugin != null && (versionFo = railsPlugin.getFileObject("lib/rails/version.rb")) != null && (version = RailsProjectUtil.getVersionString(versionFile = FileUtil.toFile((FileObject)versionFo))) != null) {
            railsVersion = version;
        }
        if ((environment = project.getProjectDirectory().getFileObject("config/environment.rb")) != null && environment.isValid() && (specifiedVersion = RailsProjectUtil.getSpecifiedRailsVersion(environment)) != null) {
            railsVersion = specifiedVersion;
        }
        if (railsVersion == null) {
            return new RailsVersion(0);
        }
        return RailsProjectUtil.versionFor(railsVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpecifiedRailsVersion(FileObject environment) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(environment.getInputStream()));
            Pattern VERSION_PATTERN = Pattern.compile("\\s*RAILS_GEM_VERSION\\s*=\\s*['\"](\\d+(?:\\.\\d+)*(\\.beta\\d*)?)['\"].*");
            for (int line = 0; line < 20; ++line) {
                Matcher m;
                String s = br.readLine();
                if (s == null) {
                    break;
                }
                if (s.indexOf("RAILS_GEM_VERSION") == -1 || !(m = VERSION_PATTERN.matcher(s)).matches()) continue;
                String string = m.group(1);
                return string;
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static Object getEvaluatedProperty(Project p, String value) {
        if (value == null) {
            return null;
        }
        RailsProject j2seprj = (RailsProject)((Object)p.getLookup().lookup(RailsProject.class));
        if (j2seprj != null) {
            return j2seprj.evaluator().evaluate(value);
        }
        return null;
    }

    public static void getAllScripts(String prefix, FileObject sourcesRoot, List<String> result) {
        FileObject[] children = sourcesRoot.getChildren();
        if (!"".equals(prefix)) {
            prefix = prefix + "/";
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isData() && children[i].getMIMEType().equals("text/x-ruby")) {
                result.add(prefix + children[i].getNameExt());
            }
            if (!children[i].isFolder()) continue;
            RailsProjectUtil.getAllScripts(prefix + children[i].getNameExt(), children[i], result);
        }
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = root.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        } else if (!root.exists()) {
            url = new URL(url.toExternalForm() + "/");
        }
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public static RailsVersion versionFor(String version) {
        try {
            if (!version.contains(".")) {
                return new RailsVersion(Integer.parseInt(version));
            }
            String[] splitted = version.split("\\.");
            if (splitted.length == 2) {
                return new RailsVersion(Integer.parseInt(splitted[0]), Integer.parseInt(splitted[1]));
            }
            if (splitted.length == 3) {
                return new RailsVersion(Integer.parseInt(splitted[0]), Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]));
            }
            if (splitted.length == 4) {
                return new RailsVersion(Integer.parseInt(splitted[0]), Integer.parseInt(splitted[1]), Integer.parseInt(splitted[2]), splitted[3]);
            }
        }
        catch (NumberFormatException ne) {
            return new RailsVersion(0);
        }
        return new RailsVersion(0);
    }

    public static final class RailsVersion
    implements Comparable<RailsVersion> {
        private final int major;
        private final int minor;
        private final int revision;
        private final String suffix;

        public RailsVersion(int major) {
            this(major, 0);
        }

        public RailsVersion(int major, int minor) {
            this(major, minor, 0);
        }

        public RailsVersion(int major, int minor, int revision) {
            this(major, minor, revision, "");
        }

        public RailsVersion(int major, int minor, int revision, String suffix) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.suffix = suffix;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getRevision() {
            return this.revision;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String asString() {
            String result = this.getMajor() + "." + this.getMinor() + "." + this.getRevision();
            if (this.getSuffix().length() > 0) {
                result = result + "." + this.getSuffix();
            }
            return result;
        }

        public boolean isRails3OrHigher() {
            return this.compareTo(new RailsVersion(3)) >= 0;
        }

        public boolean isRails3Obeta4OrHigher() {
            return this.compareTo(new RailsVersion(3, 0, 0, "beta4")) >= 0;
        }

        @Override
        public int compareTo(RailsVersion o) {
            if (this.major > o.major) {
                return 1;
            }
            if (this.major == o.major) {
                if (this.minor > o.minor) {
                    return 1;
                }
                if (this.minor == o.minor) {
                    if (this.revision > o.revision) {
                        return 1;
                    }
                    if (this.revision == o.revision) {
                        if (this.suffix == null || this.suffix.isEmpty()) {
                            return o.suffix == null || o.suffix.isEmpty() ? 0 : 1;
                        }
                        return o.suffix == null || o.suffix.isEmpty() ? -1 : this.suffix.compareTo(o.suffix);
                    }
                }
            }
            return -1;
        }
    }
}

