/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.text.JTextComponent;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.railsprojects.RailsFileLocator;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerManager;
import org.netbeans.modules.ruby.rubyproject.AutoTestSupport;
import org.netbeans.modules.ruby.rubyproject.GotoTest;
import org.netbeans.modules.ruby.rubyproject.Migrations;
import org.netbeans.modules.ruby.rubyproject.RSpecSupport;
import org.netbeans.modules.ruby.rubyproject.RubyBaseActionProvider;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyFileLocator;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.SharedRubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.rake.RakeRunner;
import org.netbeans.modules.ruby.rubyproject.rake.RakeSupport;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RailsActionProvider
extends RubyBaseActionProvider {
    private static final Logger LOGGER = Logger.getLogger(RailsActionProvider.class.getName());
    public static final String COMMAND_RAILS_CONSOLE = "rails-console";
    private static final String[] supportedActions = new String[]{"autotest", "autospec", "rdoc", "rails-console", "run", "run.single", "debug", "debug.single", "test", "rspec", "test.single", "debug.test.single", "delete", "copy", "move", "rename"};
    private static final String[] MIME_TYPES = new String[]{"text/x-ruby", "application/x-httpd-eruby"};
    final RailsProject project;

    public RailsActionProvider(RailsProject project, UpdateHelper updateHelper) {
        super((RubyBaseProject)project, updateHelper);
        this.project = project;
    }

    protected FileObject[] getSourceRoots() {
        return this.project.getSourceRoots().getRoots();
    }

    protected FileObject[] getTestSourceRoots() {
        return this.project.getTestSourceRoots().getRoots();
    }

    protected String[] getMimeTypes() {
        return MIME_TYPES;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    private boolean isMigrationFile(FileObject file) {
        if (file.getParent() == null || !file.getParent().getName().equals("migrate")) {
            return false;
        }
        if (file.getParent().getParent() == null || !file.getParent().getParent().getName().equals("db")) {
            return false;
        }
        if (!file.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        return Migrations.getMigrationVersion((String)file.getName()) != null;
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
        assert (platform != null) : "Action '" + command + "' should be disabled when platform is invalid";
        boolean debugCommand = "debug".equals(command);
        boolean debugSingleCommand = "debug.single".equals(command);
        if ("run".equals(command) || debugCommand) {
            LifecycleManager.getDefault().saveAll();
            this.runServer("", debugCommand);
            return;
        }
        if ("test".equals(command)) {
            boolean testTaskExist;
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.TEST_UNIT);
            boolean bl = testTaskExist = RakeSupport.getRakeTask((Project)this.project, (String)"test") != null;
            if (testTaskExist) {
                File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                RakeRunner runner = new RakeRunner((RubyBaseProject)this.project);
                runner.setPWD(pwd);
                runner.setFileLocator((RubyFileLocator)new RailsFileLocator(context, (Project)this.project));
                runner.showWarnings(true);
                runner.setDebug("debug.single".equals(command));
                runner.run(new String[]{"test"});
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("test.single".equals(command) || "debug.test.single".equals(command)) {
            if (!platform.isValid(true)) {
                return;
            }
            FileObject file = this.getCurrentFile(context);
            if (file == null) {
                return;
            }
            RailsActionProvider.saveFile((FileObject)file);
            DeclarationFinder.DeclarationLocation location = new GotoTest().findTest(file, -1);
            if (location != DeclarationFinder.DeclarationLocation.NONE) {
                file = location.getFileObject();
                RailsActionProvider.saveFile((FileObject)file);
            } else if (RubyUtils.isRhtmlFile((FileObject)file)) {
                return;
            }
            boolean isDebug = "debug.test.single".equals(command);
            RSpecSupport rspec = new RSpecSupport((Project)this.project);
            if (rspec.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)file)) {
                TestRunner rspecRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
                if (rspecRunner != null) {
                    rspecRunner.runTest(file, isDebug);
                } else {
                    rspec.runRSpec(null, file, file.getName(), (LineConvertors.FileLocator)new RailsFileLocator(context, (Project)this.project), true, isDebug, new String[0]);
                }
                return;
            }
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.TEST_UNIT);
            if (testRunner != null) {
                testRunner.getInstance().runTest(file, isDebug);
            } else {
                this.runRubyScript(file, FileUtil.toFile((FileObject)file).getAbsolutePath(), file.getNameExt(), context, isDebug, new LineConvertor[]{new TestNotifierLineConvertor(true, true)});
            }
            return;
        }
        if ("run.single".equals(command) || debugSingleCommand) {
            if (!platform.isValid(true)) {
                return;
            }
            FileObject file = this.getCurrentFile(context);
            if (file == null) {
                return;
            }
            if (RakeSupport.isRakeFile((FileObject)file)) {
                LifecycleManager.getDefault().saveAll();
                RakeRunner runner = new RakeRunner((RubyBaseProject)this.project);
                runner.setRakeFile(file);
                runner.setFileLocator((RubyFileLocator)new RailsFileLocator(context, (Project)this.project));
                runner.showWarnings(true);
                runner.setDebug("debug.single".equals(command));
                runner.run(new String[0]);
                return;
            }
            RSpecSupport rspec = new RSpecSupport((Project)this.project);
            if (rspec.isRSpecInstalled() && RSpecSupport.isSpecFile((FileObject)file)) {
                TestRunner rspecRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
                boolean debug = "debug.single".equals(command);
                if (rspecRunner != null) {
                    RailsActionProvider.saveFile((FileObject)file);
                    rspecRunner.runTest(file, debug);
                } else {
                    LifecycleManager.getDefault().saveAll();
                    rspec.runRSpec(null, file, file.getName(), (LineConvertors.FileLocator)new RailsFileLocator(context, (Project)this.project), true, debugSingleCommand, new String[0]);
                }
                return;
            }
            RailsActionProvider.saveFile((FileObject)file);
            if (this.isMigrationFile(file)) {
                String name = file.getName();
                Long version = Migrations.getMigrationVersion((String)name);
                RakeRunner runner = new RakeRunner((RubyBaseProject)this.project);
                runner.setPWD(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
                runner.setFileLocator((RubyFileLocator)new RailsFileLocator(context, (Project)this.project));
                runner.showWarnings(true);
                runner.setParameters(new String[]{"VERSION=" + version});
                runner.run(new String[]{"db:migrate"});
                return;
            }
            String path = "";
            String fileName = file.getName();
            String CONTROLLER_SUFFIX = "_controller";
            String HELPER_SUFFIX = "_helper";
            if (file.getExt().equals("rhtml") || file.getExt().equals("erb")) {
                if (fileName.endsWith(".html")) {
                    fileName = fileName.substring(0, fileName.length() - ".html".length());
                }
                if (!fileName.startsWith("_")) {
                    path = fileName;
                }
                FileObject projDir = this.project.getProjectDirectory();
                for (FileObject curr = file.getParent(); curr != null && curr != projDir && (!curr.getName().equals("views") || curr.getParent() != null && !curr.getParent().getName().equals("app")); curr = curr.getParent()) {
                    path = curr.getNameExt() + "/" + path;
                }
            } else if (fileName.endsWith("_controller")) {
                String methodName;
                int offset;
                FileObject fo;
                FileObject app;
                path = fileName.substring(0, fileName.length() - "_controller".length());
                FileObject projDir = this.project.getProjectDirectory();
                for (app = file.getParent(); app != null && app != projDir; app = app.getParent()) {
                    if (app.getName().equals("controllers") && (app.getParent() == null || app.getParent().getName().equals("app"))) {
                        app = app.getParent();
                        break;
                    }
                    path = app.getNameExt() + "/" + path;
                }
                JTextComponent pane = GsfUtilities.getOpenPane();
                if (app != null && pane != null && pane.getCaret() != null && (fo = GsfUtilities.findFileObject((JTextComponent)pane)) != null && (offset = pane.getCaret().getDot()) >= 0 && (methodName = AstUtilities.getMethodName((FileObject)file, (int)offset)) != null) {
                    path = path + "/" + methodName;
                }
            } else if (fileName.endsWith("_helper")) {
                path = fileName.substring(0, fileName.length() - "_helper".length());
                FileObject projDir = this.project.getProjectDirectory();
                for (FileObject curr = file.getParent(); curr != null && curr != projDir && (!curr.getName().equals("helpers") || curr.getParent() != null && !curr.getParent().getName().equals("app")); curr = curr.getParent()) {
                    path = curr.getNameExt() + "/" + path;
                }
            } else if (fileName.endsWith("_test")) {
                TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.TEST_UNIT);
                if (testRunner != null) {
                    testRunner.getInstance().runTest(file, "debug.single".equals(command));
                } else {
                    this.runRubyScript(file, FileUtil.toFile((FileObject)file).getAbsolutePath(), file.getNameExt(), context, debugSingleCommand, new LineConvertor[]{new TestNotifierLineConvertor(true, true)});
                }
                return;
            }
            if (path.length() == 0) {
                this.runRubyScript(file, FileUtil.toFile((FileObject)file).getAbsolutePath(), file.getNameExt(), context, debugSingleCommand, new LineConvertor[0]);
                return;
            }
            this.runServer(path, debugCommand || debugSingleCommand);
            return;
        }
        if ("rspec".equals(command)) {
            boolean rspecTaskExists = RakeSupport.getRakeTask((Project)this.project, (String)"spec") != null;
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
            if (rspecTaskExists) {
                File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                RakeRunner runner = new RakeRunner((RubyBaseProject)this.project);
                runner.setPWD(pwd);
                runner.setFileLocator(new RubyFileLocator(context, (Project)this.project));
                runner.showWarnings(true);
                runner.run(new String[]{"spec"});
            } else if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("rspec-all".equals(command)) {
            TestRunner testRunner = Util.getTestRunner((TestRunner.TestType)TestRunner.TestType.RSPEC);
            if (testRunner != null) {
                testRunner.getInstance().runAllTests((Project)this.project, false);
            }
            return;
        }
        if ("autotest".equals(command)) {
            if (AutoTestSupport.isInstalled((Project)this.project, (TestRunner.TestType)TestRunner.TestType.AUTOTEST)) {
                AutoTestSupport support = new AutoTestSupport(context, (Project)this.project, this.getSourceEncoding());
                support.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                support.start(TestRunner.TestType.AUTOTEST);
            }
            return;
        }
        if ("autospec".equals(command)) {
            if (AutoTestSupport.isInstalled((Project)this.project, (TestRunner.TestType)TestRunner.TestType.AUTOSPEC)) {
                AutoTestSupport support = new AutoTestSupport(context, (Project)this.project, this.getSourceEncoding());
                support.setClassPath(this.project.evaluator().getProperty("javac.classpath"));
                support.start(TestRunner.TestType.AUTOSPEC);
            }
            return;
        }
        if (COMMAND_RAILS_CONSOLE.equals(command)) {
            this.openRailsConsole(context);
            return;
        }
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
    }

    private void openRailsConsole(Lookup context) {
        String railsEnv;
        String displayName = NbBundle.getMessage(RailsActionProvider.class, (String)"RailsConsole");
        File pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        String script = null;
        ArrayList<String> additionalArgs = new ArrayList<String>();
        boolean rails3 = RailsProjectUtil.getRailsVersion((Project)this.project).isRails3OrHigher();
        if (rails3) {
            script = "script" + File.separator + "rails";
            additionalArgs.add("console");
        } else {
            script = "script" + File.separator + "console";
        }
        String classPath = this.project.evaluator().getProperty("javac.classpath");
        if (!rails3) {
            if (Utilities.isWindows() && !this.getPlatform().isJRuby()) {
                additionalArgs.add("--irb=irb.bat --noreadline");
            } else {
                additionalArgs.add("--irb=irb --noreadline");
            }
        }
        if ((railsEnv = this.project.evaluator().getProperty("rails.env")) != null && !"".equals(railsEnv.trim())) {
            additionalArgs.add(railsEnv);
        }
        RubyExecutionDescriptor descriptor = new RubyExecutionDescriptor(this.getPlatform(), displayName, pwd, script).showSuspended(false).showProgress(false).classPath(classPath).allowInput().additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()])).fileLocator((LineConvertors.FileLocator)new RailsFileLocator(context, (Project)this.project));
        descriptor.addStandardRecognizers();
        RubyProcessCreator rpc = new RubyProcessCreator(descriptor, this.getSourceEncoding());
        ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)descriptor.toExecutionDescriptor(), (String)displayName).run();
        RailsActionProvider.getOutputWindow().requestActive();
    }

    private static TopComponent getOutputWindow() {
        String outputWindowId = "output";
        TopComponent outputWindow = WindowManager.getDefault().findTopComponent("output");
        assert (outputWindow != null) : "Could not find the output window using id output";
        return outputWindow;
    }

    public RubyExecutionDescriptor getScriptDescriptor(File pwd, FileObject fileObject, String target, String displayName, Lookup context, boolean debug, LineConvertor ... extraConvertors) {
        RubyCoverageProvider coverageProvider;
        String rubyOptions = SharedRubyProjectProperties.getRubyOptions((RubyBaseProject)this.project);
        String includePath = RubyProjectUtil.getLoadPath((Project)this.project);
        rubyOptions = rubyOptions != null ? includePath + " " + rubyOptions : includePath;
        FileObject[] srcPath = this.project.getSourceRoots().getRoots();
        FileObject[] testPath = this.project.getTestSourceRoots().getRoots();
        if (!new File(target).exists() && srcPath != null && srcPath.length > 0) {
            FileObject fo;
            boolean found = false;
            for (FileObject root : srcPath) {
                fo = root.getFileObject(target);
                if (fo == null) continue;
                target = FileUtil.toFile((FileObject)fo).getAbsolutePath();
                found = true;
                break;
            }
            if (!found && testPath != null) {
                for (FileObject root : testPath) {
                    fo = root.getFileObject(target);
                    if (fo == null) continue;
                    target = FileUtil.toFile((FileObject)fo).getAbsolutePath();
                    break;
                }
            }
        }
        if (pwd == null) {
            pwd = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        String classPath = this.project.evaluator().getProperty("javac.classpath");
        String jvmArgs = this.project.evaluator().getProperty("jvm.args");
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(this.getPlatform(), displayName, pwd, target);
        desc.debug(debug);
        desc.showSuspended(true);
        desc.allowInput();
        desc.initialArgs(rubyOptions);
        desc.jvmArguments(jvmArgs);
        desc.classPath(classPath);
        desc.additionalArgs(this.getApplicationArguments());
        desc.fileLocator((LineConvertors.FileLocator)new RailsFileLocator(context, (Project)this.project));
        desc.addStandardRecognizers();
        desc.addOutConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)desc.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        desc.addErrConvertor(LineConvertors.filePattern((LineConvertors.FileLocator)desc.getFileLocator(), (Pattern)RubyLineConvertorFactory.RUBY_TEST_OUTPUT, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2));
        if (extraConvertors != null) {
            for (LineConvertor extra : extraConvertors) {
                desc.addOutConvertor(extra);
            }
        }
        if ((coverageProvider = RubyCoverageProvider.get((Project)this.project)) != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        return desc;
    }

    public boolean isActionEnabled(String command, Lookup context) {
        return this.getPlatform() != null;
    }

    private void runServer(String path, boolean debug) {
        if (!debug) {
            this.runServer(path, false, false);
        } else {
            boolean serverDebug;
            boolean clientDebug;
            if (!WebClientToolsSessionStarterService.isAvailable()) {
                clientDebug = false;
                serverDebug = true;
            } else {
                boolean keepDebugging = WebClientToolsProjectUtils.showDebugDialog((Project)this.project);
                if (!keepDebugging) {
                    return;
                }
                serverDebug = WebClientToolsProjectUtils.getServerDebugProperty((Project)this.project);
                clientDebug = WebClientToolsProjectUtils.getClientDebugProperty((Project)this.project);
            }
            assert (serverDebug || clientDebug);
            this.runServer(path, serverDebug, clientDebug);
        }
    }

    private void runServer(String path, boolean serverDebug, boolean clientDebug) {
        TopComponent outputWindow = RailsActionProvider.getOutputWindow();
        if (!outputWindow.isOpened()) {
            outputWindow.open();
        }
        outputWindow.requestActive();
        outputWindow.toFront();
        RailsServerManager server = (RailsServerManager)this.project.getLookup().lookup(RailsServerManager.class);
        if (server != null) {
            String url;
            server.setDebug(serverDebug);
            server.setClientDebug(clientDebug);
            if ((path == null || "".equals(path)) && (url = this.project.evaluator().getProperty("rails.url")) != null) {
                path = url;
            }
            server.showUrl(path);
        }
    }
}

