-- File: TimeCount.vhd
-- Generated by MyHDL 0.7dev
-- Date: Thu Sep 30 16:27:59 2010


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;
use std.textio.all;

use work.pck_myhdl_07dev.all;

entity TimeCount is
    port (
        tens: inout unsigned(3 downto 0);
        ones: inout unsigned(3 downto 0);
        tenths: inout unsigned(3 downto 0);
        startstop: in std_logic;
        reset: in std_logic;
        clock: in std_logic
    );
end entity TimeCount;
-- 3 digit time counter in seconds and tenths of a second.
-- 
-- tens: most significant digit of the seconds
-- ones: least significant digit of the seconds
-- tenths: tenths of a second
-- startstop: input that starts or stops the counter on posedge
-- reset: reset input
-- clock: 10Hz clock input

architecture MyHDL of TimeCount is


begin




TIMECOUNT_LOGIC: process (clock, reset) is
    variable seen: std_logic;
    variable counting: std_logic;
begin
    if to_boolean(reset) then
        tens <= "0000";
        ones <= "0000";
        tenths <= "0000";
        seen := '0';
        counting := '0';
    elsif rising_edge(clock) then
        if (to_boolean(startstop) and (not to_boolean(seen))) then
            seen := '1';
            counting := to_std_logic((not to_boolean(counting)));
        elsif (not to_boolean(startstop)) then
            seen := '0';
        end if;
        if to_boolean(counting) then
            if (tenths = 9) then
                tenths <= "0000";
                if (ones = 9) then
                    ones <= "0000";
                    if (tens = 5) then
                        tens <= "0000";
                    else
                        tens <= (tens + 1);
                    end if;
                else
                    ones <= (ones + 1);
                end if;
            else
                tenths <= (tenths + 1);
            end if;
        end if;
    end if;
end process TIMECOUNT_LOGIC;

end architecture MyHDL;
