/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.Shape;
import com.sun.star.wizards.document.TimeStampControl;

public class FormControlArranger {
    public static final String LABELCONTROL = "LabelControl";
    protected DatabaseControl[] DBControlList = null;
    private XNameContainer xFormName;
    private XMultiServiceFactory xMSF;
    private Control[] LabelControlList = null;
    private XStatusIndicator xProgressBar;
    private FieldColumn[] FieldColumns;
    private int icurArrangement;
    private boolean bIsFirstRun;
    private boolean bIsVeryFirstRun;
    private boolean bControlsareCreated;
    private int cXOffset;
    private int cYOffset;
    private static final int cVertDistance = 200;
    private static final int cHoriDistance = 300;
    private static final int cLabelGap = 100;
    private static final double CMAXREDUCTION = 0.7;
    private FormHandler oFormHandler;
    private int iReduceWidth;
    private int m_currentLabelPosX;
    private int m_currentLabelPosY;
    private int m_currentControlPosX;
    private int m_currentControlPosY;
    private int m_LabelHeight;
    private int m_LabelWidth;
    private int m_dbControlHeight;
    private int m_dbControlWidth;
    private int m_MaxLabelWidth;
    private int nFormWidth;
    private int nFormHeight;
    private int m_currentMaxRowHeight;
    private int nSecMaxRowY;
    private int m_maxPostionX;
    private int a;
    private int StartA;
    private int m_controlMaxPosY = 0;
    private Short NBorderType = new Short(1);

    public FormControlArranger(FormHandler formHandler, XNameContainer xNameContainer, CommandMetaData commandMetaData, XStatusIndicator xStatusIndicator, Point point, Size size) {
        this.FieldColumns = commandMetaData.FieldColumns;
        this.xMSF = commandMetaData.xMSF;
        this.xFormName = xNameContainer;
        this.xProgressBar = xStatusIndicator;
        this.LabelControlList = new Control[this.FieldColumns.length];
        this.DBControlList = new DatabaseControl[this.FieldColumns.length];
        this.oFormHandler = formHandler;
        this.cXOffset = point.X;
        this.cYOffset = point.Y;
        this.setFormSize(size);
    }

    private int getLabelDiffHeight(int n) {
        DatabaseControl databaseControl = this.DBControlList[n];
        if (databaseControl != null && databaseControl.getControlType() == 2) {
            return this.getCheckBoxDiffHeight(n);
        }
        return this.oFormHandler.getBasicLabelDiffHeight();
    }

    public void setBorderType(short s) {
        this.NBorderType = new Short(s);
    }

    public Control[] getLabelControlList() {
        return this.LabelControlList;
    }

    private int getCheckBoxDiffHeight(int n) {
        if (n < this.DBControlList.length && this.DBControlList[n].getControlType() == 2) {
            return (this.oFormHandler.getControlReferenceHeight() - this.DBControlList[n].getControlHeight()) / 2;
        }
        return 0;
    }

    private boolean isReducable(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = this.FieldColumns[n].getFieldType();
        switch (n4) {
            case -7: 
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                bl = false;
                break;
            }
            case 12: {
                try {
                    short s = AnyConverter.toShort((Object)this.DBControlList[n].xPropertySet.getPropertyValue("MaxTextLen"));
                    if (s != 0 && s <= 20) break;
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
                break;
            }
            case -5: {
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl && (double)n2 > 0.63 * (double)n3) {
            bl = false;
        }
        return bl;
    }

    private int getControlGroupWidth() {
        if (this.m_dbControlWidth > this.m_LabelWidth) {
            return this.m_dbControlWidth;
        }
        return this.m_LabelWidth;
    }

    private void checkJustifiedPosition(int n) {
        int n2 = this.nFormWidth + this.cXOffset;
        int n3 = this.m_maxPostionX - n2;
        int n4 = n2 - (this.DBControlList[n].getPosition().X - 300);
        if ((double)n3 < 0.5 * (double)n4) {
            this.adjustLineWidth(this.StartA, n, n3, -1);
            this.m_currentLabelPosY = this.m_currentMaxRowHeight + 200;
            this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
            this.m_currentLabelPosX = this.cXOffset;
            this.m_currentControlPosX = this.cXOffset;
            this.bIsFirstRun = true;
            this.StartA = n + 1;
        } else {
            this.m_currentLabelPosY = this.m_currentControlPosY + this.m_dbControlHeight == this.m_currentMaxRowHeight ? this.nSecMaxRowY : this.m_currentMaxRowHeight;
            this.m_currentLabelPosY += 200;
            this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
            this.m_currentControlPosX = this.cXOffset;
            this.m_currentLabelPosX = this.cXOffset;
            this.LabelControlList[n].setPosition(new Point(this.cXOffset, this.m_currentLabelPosY));
            this.DBControlList[n].setPosition(new Point(this.cXOffset, this.m_currentControlPosY));
            this.bIsFirstRun = true;
            this.checkOuterPoints(this.m_currentControlPosX, this.m_dbControlWidth > this.m_LabelWidth ? this.m_dbControlWidth : this.m_LabelWidth, this.m_currentControlPosY, this.m_dbControlHeight, true);
            this.m_currentControlPosX = this.m_currentLabelPosX = this.m_maxPostionX + 300;
            this.adjustLineWidth(this.StartA, n - 1, n4, 1);
            this.StartA = n;
        }
    }

    private int getCorrWidth(int n, int n2, int n3, int n4) {
        int n5 = n4 > 0 ? n2 - n + 1 : this.iReduceWidth;
        return n3 / n5;
    }

    private void adjustLineWidth(int n, int n2, int n3, int n4) {
        int n5 = this.getCorrWidth(n, n2, n3, n4);
        int n6 = this.cXOffset;
        for (int i = n; i <= n2; ++i) {
            int n7 = 0;
            DatabaseControl databaseControl = this.DBControlList[i];
            Control control = this.LabelControlList[i];
            if (i != n) {
                control.setPosition(new Point(n6, control.getPosition().Y));
                databaseControl.setPosition(new Point(n6, control.getPosition().Y + this.m_LabelHeight));
            }
            Size size = control.getSize();
            Size size2 = databaseControl.getSize();
            n7 = size.Width > size2.Width && n4 > 0 ? size.Width : size2.Width;
            if (this.FieldColumns[i].getFieldType() == 93) {
                TimeStampControl timeStampControl = (TimeStampControl)databaseControl;
                n7 = timeStampControl.getSize().Width;
            }
            if (n4 > 0 || this.isReducable(i, size.Width, size2.Width)) {
                size2.Width = n7 + n4 * n5;
                databaseControl.setSize(size2);
                size2 = databaseControl.getSize();
            }
            n6 = size.Width > size2.Width ? (n6 += size.Width) : (n6 += size2.Width);
            n6 += 300;
        }
        this.iReduceWidth = n4 > 0 ? 1 : 0;
    }

    private void checkOuterPoints(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        if (this.icurArrangement == 4 && bl) {
            if (this.bIsFirstRun) {
                this.nSecMaxRowY = this.m_currentMaxRowHeight = n3 + n4;
            } else {
                n5 = n3 + n4;
                if (n5 >= this.m_currentMaxRowHeight) {
                    this.nSecMaxRowY = this.m_currentMaxRowHeight;
                    this.m_currentMaxRowHeight = n5;
                }
            }
        }
        if (this.bIsFirstRun) {
            this.m_maxPostionX = n + n2;
            this.bIsFirstRun = false;
        } else {
            n5 = n + n2;
            if (n5 > this.m_maxPostionX) {
                this.m_maxPostionX = n5;
            }
        }
    }

    public void positionControls(int n, Point point, Size size, short s, Short s2) {
        try {
            this.NBorderType = s2;
            this.setStartPoint(point);
            this.icurArrangement = n;
            this.initializePosSizes();
            this.initializeControlColumn(-1);
            this.bIsVeryFirstRun = true;
            this.m_currentMaxRowHeight = 0;
            this.nSecMaxRowY = 0;
            this.m_maxPostionX = 0;
            this.xProgressBar.start(PropertyNames.EMPTY_STRING, this.FieldColumns.length);
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                try {
                    this.insertLabel(i, s);
                    this.insertDBControl(i);
                    this.bIsVeryFirstRun = false;
                    this.DBControlList[i].setPropertyValue(LABELCONTROL, this.LabelControlList[i].xPropertySet);
                    this.resetPosSizes(i);
                    this.xProgressBar.setValue(i + 1);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.xProgressBar.end();
            this.bControlsareCreated = true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public boolean areControlsexisting() {
        if (this.DBControlList != null && this.DBControlList.length > 0) {
            return this.DBControlList[0] != null;
        }
        return false;
    }

    private void initializeControlColumn(int n) {
        this.bIsFirstRun = true;
        this.StartA = n + 1;
        this.a = 0;
    }

    private void resetPosSizes(int n) {
        int n2 = this.m_currentControlPosY;
        switch (this.icurArrangement) {
            case 1: {
                n2 = this.m_currentControlPosY = this.m_currentControlPosY + this.m_dbControlHeight + 200 + this.getCheckBoxDiffHeight(n);
                if (this.m_currentControlPosY > this.cYOffset + this.nFormHeight || n == this.FieldColumns.length - 1) {
                    this.repositionColumnarLeftControls(n);
                    this.m_currentLabelPosX = this.m_maxPostionX + 600;
                    this.m_currentControlPosX = this.m_currentLabelPosX + 100 + this.m_MaxLabelWidth;
                    n2 = this.m_currentControlPosY = this.cYOffset;
                    this.initializeControlColumn(n);
                } else {
                    ++this.a;
                }
                this.m_currentLabelPosY = this.m_currentControlPosY + this.getLabelDiffHeight(n);
                if (n2 + this.m_dbControlHeight <= this.m_controlMaxPosY) break;
                this.m_controlMaxPosY = n2 + this.m_dbControlHeight;
                break;
            }
            case 2: {
                this.m_currentLabelPosY = this.m_currentControlPosY + this.m_dbControlHeight + 200 + this.getCheckBoxDiffHeight(n);
                if (this.m_currentLabelPosY > this.cYOffset + this.nFormHeight || n == this.FieldColumns.length - 1) {
                    this.m_currentLabelPosX = this.m_currentControlPosX = this.m_maxPostionX + 300;
                    n2 = this.m_currentControlPosY;
                    this.m_currentControlPosY = this.cYOffset + this.m_LabelHeight + 200;
                    this.m_currentLabelPosY = this.cYOffset;
                    this.initializeControlColumn(n);
                } else {
                    ++this.a;
                }
                if (n2 + this.m_dbControlHeight + 200 <= this.m_controlMaxPosY) break;
                this.m_controlMaxPosY = n2 + this.m_dbControlHeight + 200;
                break;
            }
            case 4: {
                if (this.isReducable(this.a, this.m_LabelWidth, this.m_dbControlWidth)) {
                    ++this.iReduceWidth;
                }
                if (this.m_maxPostionX > this.cXOffset + this.nFormWidth) {
                    this.checkJustifiedPosition(this.a);
                    n2 = this.m_currentControlPosY;
                } else {
                    this.m_currentLabelPosX = this.m_maxPostionX + 300;
                }
                if (this.a == this.FieldColumns.length - 1) {
                    this.checkJustifiedPosition(this.a);
                    n2 = this.m_currentControlPosY;
                }
                this.m_currentControlPosX = this.m_currentLabelPosX;
                ++this.a;
                if (n2 + this.m_dbControlHeight <= this.m_controlMaxPosY) break;
                this.m_controlMaxPosY = n2 + this.m_dbControlHeight;
            }
        }
    }

    private void repositionColumnarLeftControls(int n) {
        this.bIsFirstRun = true;
        for (int i = this.StartA; i <= n; ++i) {
            if (i == this.StartA) {
                this.m_currentLabelPosX = this.LabelControlList[i].getPosition().X;
                this.m_currentControlPosX = this.m_currentLabelPosX + this.m_MaxLabelWidth + 300;
            }
            this.LabelControlList[i].setSize(new Size(this.m_MaxLabelWidth, this.m_LabelHeight));
            this.resetDBShape(this.DBControlList[i], this.m_currentControlPosX);
            this.checkOuterPoints(this.m_currentControlPosX, this.m_dbControlWidth, this.m_currentControlPosY, this.m_dbControlHeight, true);
        }
    }

    private void resetDBShape(Shape shape, int n) {
        this.m_dbControlWidth = shape.getSize().Width;
        this.m_dbControlHeight = shape.getSize().Height;
        shape.setPosition(new Point(n, shape.getPosition().Y));
    }

    private void initializePosSizes() {
        this.m_controlMaxPosY = 0;
        this.m_currentLabelPosX = this.cXOffset;
        this.m_LabelWidth = 2000;
        this.m_dbControlWidth = 2000;
        this.m_dbControlHeight = this.oFormHandler.getControlReferenceHeight();
        this.m_LabelHeight = this.oFormHandler.getLabelHeight();
        this.iReduceWidth = 0;
        if (this.icurArrangement == 1) {
            this.m_currentLabelPosY = this.cYOffset + this.getLabelDiffHeight(0);
            this.m_currentControlPosX = this.cXOffset + 3050;
            this.m_currentControlPosY = this.cYOffset;
        } else {
            this.m_currentControlPosX = this.cXOffset;
            this.m_currentLabelPosY = this.cYOffset;
        }
    }

    private void insertLabel(int n, int n2) {
        try {
            Object object;
            Point point = new Point(this.m_currentLabelPosX, this.m_currentLabelPosY);
            Size size = new Size(this.m_LabelWidth, this.m_LabelHeight);
            if (this.bControlsareCreated) {
                this.LabelControlList[n].setPosition(point);
                if (this.icurArrangement != 1) {
                    size.Width = this.m_LabelWidth = this.LabelControlList[n].getPreferredWidth(this.FieldColumns[n].getFieldTitle());
                    this.LabelControlList[n].setSize(size);
                } else {
                    this.m_LabelWidth = this.LabelControlList[n].getSize().Width;
                }
            } else {
                object = this.FieldColumns[n].getFieldName();
                this.LabelControlList[n] = new Control(this.oFormHandler, this.xFormName, 0, (String)object, point, size);
                if (this.bIsVeryFirstRun && this.icurArrangement == 2) {
                    this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
                }
                String string = this.FieldColumns[n].getFieldTitle();
                size.Width = this.m_LabelWidth = this.LabelControlList[n].getPreferredWidth(string);
                this.LabelControlList[n].setSize(size);
            }
            object = this.LabelControlList[n];
            if (this.icurArrangement == 1) {
                if (this.bIsFirstRun) {
                    this.m_MaxLabelWidth = this.m_LabelWidth;
                    this.bIsFirstRun = false;
                } else if (this.m_LabelWidth > this.m_MaxLabelWidth) {
                    this.m_MaxLabelWidth = this.m_LabelWidth;
                }
            }
            this.checkOuterPoints(this.m_currentLabelPosX, this.m_LabelWidth, this.m_currentLabelPosY, this.m_LabelHeight, false);
            if (this.icurArrangement == 2 || this.icurArrangement == 4) {
                this.m_currentControlPosX = this.m_currentLabelPosX;
                this.m_currentControlPosY = this.m_currentLabelPosY + this.m_LabelHeight;
                ((Control)object).xPropertySet.setPropertyValue(PropertyNames.PROPERTY_ALIGN, (Object)new Short(0));
            } else {
                ((Control)object).xPropertySet.setPropertyValue(PropertyNames.PROPERTY_ALIGN, (Object)new Short((short)n2));
            }
            if (!this.bControlsareCreated) {
                ((Shape)object).setSize(new Size(this.m_LabelWidth, this.m_LabelHeight));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private void insertDBControl(int n) {
        try {
            String string = this.FieldColumns[n].getFieldName();
            int n2 = this.FieldColumns[n].getFieldType();
            Point point = new Point(this.m_currentControlPosX, this.m_currentControlPosY);
            if (this.bControlsareCreated) {
                this.DBControlList[n].setPosition(point);
            } else if (n2 == 93) {
                this.DBControlList[n] = new TimeStampControl(new Resource(this.xMSF, "FormWizard", "dbw"), this.oFormHandler, this.xFormName, string, point);
            } else {
                this.DBControlList[n] = new DatabaseControl(this.oFormHandler, this.xFormName, string, n2, point);
                if (this.DBControlList[n].getControlType() == 2) {
                    this.DBControlList[n].setPropertyValue(PropertyNames.PROPERTY_LABEL, PropertyNames.EMPTY_STRING);
                }
            }
            DatabaseControl databaseControl = this.DBControlList[n];
            this.m_dbControlHeight = databaseControl.getControlHeight();
            this.m_dbControlWidth = databaseControl.getControlWidth();
            if (n2 != 93) {
                databaseControl.setSize(new Size(this.m_dbControlWidth, this.m_dbControlHeight));
            }
            if (databaseControl.getControlType() == 2) {
                this.m_currentControlPosY += (this.oFormHandler.getControlReferenceHeight() - this.m_dbControlHeight) / 2;
                point = new Point(this.m_currentControlPosX, this.m_currentControlPosY);
                databaseControl.setPosition(point);
            }
            if (n2 == -1) {
                Helper.setUnoPropertyValue(this.LabelControlList[n], PropertyNames.PROPERTY_MULTILINE, Boolean.TRUE);
            }
            this.checkOuterPoints(this.m_currentControlPosX, this.m_dbControlWidth, this.m_currentControlPosY, this.m_dbControlHeight, true);
            databaseControl.setPropertyValue(PropertyNames.PROPERTY_BORDER, this.NBorderType);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private int assignFieldLength(int n) {
        if (n >= 65535) {
            return -1;
        }
        return n;
    }

    public int getFormHeight() {
        return this.m_controlMaxPosY - this.cYOffset;
    }

    public int getEntryPointY() {
        if (this.icurArrangement == 2) {
            Control control = this.LabelControlList[0];
            return control.getPosition().Y;
        }
        DatabaseControl databaseControl = this.DBControlList[0];
        return databaseControl.getPosition().Y;
    }

    public void setStartPoint(Point point) {
        this.cXOffset = point.X;
        this.cYOffset = point.Y;
    }

    public void adjustYPositions(int n) {
        for (int i = 0; i < this.DBControlList.length; ++i) {
            Point point = this.DBControlList[i].getPosition();
            this.DBControlList[i].setPosition(new Point(point.X, point.Y - n));
            point = this.LabelControlList[i].getPosition();
            this.LabelControlList[i].setPosition(new Point(point.X, point.Y - n));
        }
        this.m_controlMaxPosY = -n;
        this.cYOffset = -n;
    }

    public void setFormSize(Size size) {
        this.nFormHeight = size.Height;
        this.nFormWidth = size.Width;
    }
}

