/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.beans;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.JavaWindowPeerFake;
import com.sun.star.beans.OfficeConnection;
import com.sun.star.beans.OfficeWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class LocalOfficeWindow
extends Canvas
implements OfficeWindow,
XEventListener {
    private transient OfficeConnection mConnection;
    private transient XWindowPeer mParentProxy;
    private transient XWindowPeer mWindow;
    private boolean bPeer = false;

    LocalOfficeWindow(OfficeConnection officeConnection) {
        this.mConnection = officeConnection;
        this.mConnection.addEventListener(this);
    }

    public Component getAWTComponent() {
        return this;
    }

    public XWindowPeer getUNOWindowPeer() {
        if (this.mWindow == null) {
            this.createUNOWindowPeer();
        }
        return this.mWindow;
    }

    public void disposing(EventObject eventObject) {
        this.mWindow = null;
        this.mConnection = null;
    }

    private XToolkit queryAWTToolkit() throws Exception {
        XComponentContext xComponentContext = this.mConnection.getComponentContext();
        if (xComponentContext != null) {
            XMultiComponentFactory xMultiComponentFactory = this.mConnection.getComponentContext().getServiceManager();
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMultiComponentFactory);
            Object object = xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
            return (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)object);
        }
        return null;
    }

    private void aquireSystemWindow() {
        if (!this.bPeer) {
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)new Long(this.getNativeWindow()));
            this.bPeer = true;
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            xWindow.setVisible(true);
        }
    }

    private void releaseSystemWindow() {
        if (this.bPeer) {
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            xWindow.setVisible(false);
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)new Long(0L));
            this.bPeer = false;
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.aquireSystemWindow();
        } else {
            this.releaseSystemWindow();
        }
    }

    private XWindowPeer createUNOWindowPeer() {
        try {
            JavaWindowPeerFake javaWindowPeerFake;
            int n = this.getNativeWindowSystemType();
            if (this.isShowing()) {
                javaWindowPeerFake = new JavaWindowPeerFake(this.getNativeWindow(), n);
                this.bPeer = true;
            } else {
                javaWindowPeerFake = null;
                this.bPeer = false;
            }
            Rectangle rectangle = new Rectangle(0, 0, 20, 20);
            WindowDescriptor windowDescriptor = new WindowDescriptor();
            windowDescriptor.Type = WindowClass.TOP;
            windowDescriptor.Parent = javaWindowPeerFake;
            windowDescriptor.Bounds = rectangle;
            windowDescriptor.WindowServiceName = "workwindow";
            windowDescriptor.WindowAttributes = n == 1 ? 1 : 0;
            this.mWindow = this.queryAWTToolkit().createWindow(windowDescriptor);
            this.addComponentListener(new ComponentEventHandler());
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            xWindow.setVisible(this.bPeer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mWindow;
    }

    private native long getNativeWindow();

    private native int getNativeWindowSystemType();

    class CallWatchThread
    extends Thread {
        Thread aWatchedThread = Thread.currentThread();
        long nTimeout;

        CallWatchThread(long l) {
            this.nTimeout = l;
            this.start();
        }

        void cancel() throws InterruptedException {
            Thread thread = this.aWatchedThread;
            this.aWatchedThread = null;
            this.stop();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }

        public void run() {
            while (this.aWatchedThread != null) {
                try {
                    CallWatchThread.sleep(this.nTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.aWatchedThread == null) continue;
                this.aWatchedThread.interrupt();
            }
        }
    }

    class ComponentEventHandler
    extends ComponentAdapter {
        ComponentEventHandler() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            CallWatchThread callWatchThread = new CallWatchThread(500L);
            LocalOfficeWindow.this.setVisible(false);
            try {
                callWatchThread.cancel();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
            LocalOfficeWindow.this.aquireSystemWindow();
        }
    }
}

