/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.Property;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XRow;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.GlobalTransferCommandArgument;
import com.sun.star.ucb.OpenCommandArgument2;
import com.sun.star.ucb.TransferCommandOperation;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.ucb.XContentAccess;
import com.sun.star.ucb.XContentIdentifier;
import com.sun.star.ucb.XContentIdentifierFactory;
import com.sun.star.ucb.XContentProvider;
import com.sun.star.ucb.XDynamicResultSet;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.PropertyNames;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCB {
    private Object ucb;
    private FileAccess fa;

    public UCB(XMultiServiceFactory xMultiServiceFactory) throws Exception {
        this.ucb = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.ucb.UniversalContentBroker", new Object[0]);
        this.fa = new FileAccess(xMultiServiceFactory);
    }

    public void deleteDirContent(String string) throws Exception {
        if (!this.fa.exists(string, true)) {
            return;
        }
        List<String> list = this.listFiles(string, null);
        for (int i = 0; i < list.size(); ++i) {
            this.delete(FileAccess.connectURLs(string, list.get(i)));
        }
    }

    public void delete(String string) throws Exception {
        this.executeCommand(this.getContent(string), "delete", Boolean.TRUE);
    }

    public void copy(String string, String string2) throws Exception {
        this.copy(string, string2, (Verifier)null);
    }

    public void copy(String string, String string2, Verifier verifier) throws Exception {
        List<String> list = this.listFiles(string, verifier);
        for (int i = 0; i < list.size(); ++i) {
            this.copy(string, list.get(i), string2);
        }
    }

    public void copy(String string, String string2, String string3, String string4) throws Exception {
        if (!this.fa.exists(string3, true)) {
            this.fa.fileAccess.createFolder(string3);
        }
        this.executeCommand(this.ucb, "globalTransfer", this.copyArg(string, string2, string3, string4));
    }

    public void copy(String string, String string2, String string3) throws Exception {
        this.copy(string, string2, string3, PropertyNames.EMPTY_STRING);
    }

    public GlobalTransferCommandArgument copyArg(String string, String string2, String string3, String string4) {
        GlobalTransferCommandArgument globalTransferCommandArgument = new GlobalTransferCommandArgument();
        globalTransferCommandArgument.Operation = TransferCommandOperation.COPY;
        globalTransferCommandArgument.SourceURL = this.fa.getURL(string, string2);
        globalTransferCommandArgument.TargetURL = string3;
        globalTransferCommandArgument.NewTitle = string4;
        globalTransferCommandArgument.NameClash = 1;
        return globalTransferCommandArgument;
    }

    public Object executeCommand(Object object, String string, Object object2) throws CommandAbortedException, com.sun.star.uno.Exception {
        XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)object);
        Command command = new Command();
        command.Name = string;
        command.Handle = -1;
        command.Argument = object2;
        return xCommandProcessor.execute(command, 0, null);
    }

    public List<String> listFiles(String string, Verifier verifier) throws Exception {
        Object object = this.getContent(string);
        OpenCommandArgument2 openCommandArgument2 = new OpenCommandArgument2();
        openCommandArgument2.Mode = 0;
        openCommandArgument2.Priority = 32768;
        openCommandArgument2.Properties = new Property[]{new Property()};
        openCommandArgument2.Properties[0].Name = PropertyNames.PROPERTY_TITLE;
        openCommandArgument2.Properties[0].Handle = -1;
        XDynamicResultSet xDynamicResultSet = (XDynamicResultSet)UnoRuntime.queryInterface(XDynamicResultSet.class, (Object)this.executeCommand(object, "open", openCommandArgument2));
        XResultSet xResultSet = xDynamicResultSet.getStaticResultSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (xResultSet.first()) {
            XContentAccess xContentAccess = (XContentAccess)UnoRuntime.queryInterface(XContentAccess.class, (Object)xResultSet);
            XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)xResultSet);
            do {
                String string2 = xContentAccess.queryContentIdentifierString();
                String string3 = xRow.getString(1);
                if (string3.length() == 0 && xRow.wasNull()) continue;
                arrayList.add(string3);
            } while (xResultSet.next());
        }
        if (verifier != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (verifier.verify(arrayList.get(i))) continue;
                arrayList.remove(i--);
            }
        }
        return arrayList;
    }

    public Object getContentProperty(Object object, String string, Class<?> clazz) throws Exception {
        Property[] propertyArray = new Property[]{new Property()};
        propertyArray[0].Name = string;
        propertyArray[0].Handle = -1;
        Object object2 = this.executeCommand(object, "getPropertyValues", propertyArray);
        XRow xRow = (XRow)UnoRuntime.queryInterface(XRow.class, (Object)object2);
        if (clazz.equals(String.class)) {
            return xRow.getString(1);
        }
        if (clazz.equals(Boolean.class)) {
            return xRow.getBoolean(1) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz.equals(Integer.class)) {
            return new Integer(xRow.getInt(1));
        }
        if (clazz.equals(Short.class)) {
            return new Short(xRow.getShort(1));
        }
        return null;
    }

    public Object getContent(String string) throws Exception {
        XContentIdentifier xContentIdentifier = ((XContentIdentifierFactory)UnoRuntime.queryInterface(XContentIdentifierFactory.class, (Object)this.ucb)).createContentIdentifier(string);
        return ((XContentProvider)UnoRuntime.queryInterface(XContentProvider.class, (Object)this.ucb)).queryContent(xContentIdentifier);
    }

    public static interface Verifier {
        public boolean verify(Object var1);
    }
}

