/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.OpenSSLReal;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class PKeyRSA
extends org.jruby.ext.openssl.PKey {
    private static final long serialVersionUID = 3675324750727019454L;
    private static ObjectAllocator PKEYRSA_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKeyRSA(runtime, klass);
        }
    };
    private volatile transient RSAPrivateCrtKey privKey;
    private volatile transient RSAPublicKey pubKey;
    private volatile transient BigInteger rsa_e;
    private volatile transient BigInteger rsa_n;
    private volatile transient BigInteger rsa_d;
    private volatile transient BigInteger rsa_p;
    private volatile transient BigInteger rsa_q;
    private volatile transient BigInteger rsa_dmp1;
    private volatile transient BigInteger rsa_dmq1;
    private volatile transient BigInteger rsa_iqmp;

    public static void createPKeyRSA(Ruby runtime, RubyModule mPKey) {
        RubyClass cRSA = mPKey.defineClassUnder("RSA", mPKey.getClass("PKey"), PKEYRSA_ALLOCATOR);
        RubyClass pkeyError = mPKey.getClass("PKeyError");
        mPKey.defineClassUnder("RSAError", pkeyError, pkeyError.getAllocator());
        cRSA.defineAnnotatedMethods(PKeyRSA.class);
        cRSA.setConstant("PKCS1_PADDING", (IRubyObject)runtime.newFixnum(1));
        cRSA.setConstant("SSLV23_PADDING", (IRubyObject)runtime.newFixnum(2));
        cRSA.setConstant("NO_PADDING", (IRubyObject)runtime.newFixnum(3));
        cRSA.setConstant("PKCS1_OAEP_PADDING", (IRubyObject)runtime.newFixnum(4));
    }

    public static RaiseException newRSAError(Ruby runtime, String message) {
        return Utils.newError(runtime, "OpenSSL::PKey::RSAError", message);
    }

    public PKeyRSA(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public PKeyRSA(Ruby runtime, RubyClass type, RSAPrivateCrtKey privKey, RSAPublicKey pubKey) {
        super(runtime, type);
        this.privKey = privKey;
        this.pubKey = pubKey;
    }

    public PKeyRSA(Ruby runtime, RubyClass type, RSAPublicKey pubKey) {
        this(runtime, type, null, pubKey);
    }

    @Override
    PublicKey getPublicKey() {
        return this.pubKey;
    }

    @Override
    PrivateKey getPrivateKey() {
        return this.privKey;
    }

    @Override
    String getAlgorithm() {
        return "RSA";
    }

    @JRubyMethod(name={"generate"}, meta=true, rest=true)
    public static IRubyObject generate(IRubyObject recv, IRubyObject[] args) {
        BigInteger exp = RSAKeyGenParameterSpec.F4;
        if (Arity.checkArgumentCount((Ruby)recv.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2) {
            exp = args[1] instanceof RubyFixnum ? BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)args[1])) : ((RubyBignum)args[1]).getValue();
        }
        int keysize = RubyNumeric.fix2int((IRubyObject)args[0]);
        PKeyRSA rsa = new PKeyRSA(recv.getRuntime(), (RubyClass)recv);
        PKeyRSA.rsaGenerate(rsa, keysize, exp);
        return rsa;
    }

    private static void rsaGenerate(PKeyRSA rsa, int keysize, BigInteger exp) throws RaiseException {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            if (gen.getProvider().getName().equals("IBMJCEFIPS")) {
                gen.initialize(keysize);
            } else {
                gen.initialize(new RSAKeyGenParameterSpec(keysize, exp), new SecureRandom());
            }
            KeyPair pair = gen.generateKeyPair();
            rsa.privKey = (RSAPrivateCrtKey)pair.getPrivate();
            rsa.pubKey = (RSAPublicKey)pair.getPublic();
        }
        catch (Exception e) {
            throw PKeyRSA.newRSAError(rsa.getRuntime(), e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JRubyMethod(rest=true)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        IRubyObject pass = null;
        char[] passwd = null;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2) == 0) {
            this.privKey = null;
            this.pubKey = null;
            return this;
        }
        IRubyObject arg = args[0];
        if (args.length > 1) {
            pass = args[1];
        }
        if (arg instanceof RubyFixnum) {
            int keysize = RubyNumeric.fix2int((IRubyObject)arg);
            BigInteger exp = RSAKeyGenParameterSpec.F4;
            if (null != pass && !pass.isNil()) {
                exp = BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)pass));
            }
            PKeyRSA.rsaGenerate(this, keysize, exp);
            return this;
        }
        if (pass != null && !pass.isNil()) {
            passwd = pass.toString().toCharArray();
        }
        arg = OpenSSLImpl.to_der_if_possible(arg);
        RubyString str = arg.convertToString();
        Serializable val = null;
        KeyFactory fact = null;
        try {
            fact = KeyFactory.getInstance("RSA");
        }
        catch (Exception e) {
            throw this.getRuntime().newRuntimeError("unsupported key algorithm (RSA)");
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readPrivateKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readRSAPublicKey(new StringReader(str.toString()), passwd);
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PEMInputOutput.readRSAPubKey(new StringReader(str.toString()));
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PKey.readRSAPrivateKey(str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = PKey.readRSAPublicKey(str.getBytes());
            }
            catch (NoClassDefFoundError e) {
                val = null;
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = fact.generatePrivate(new PKCS8EncodedKeySpec(str.getBytes()));
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            try {
                val = fact.generatePublic(new X509EncodedKeySpec(str.getBytes()));
            }
            catch (Exception e) {
                val = null;
            }
        }
        if (null == val) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
        }
        if (val instanceof KeyPair) {
            PrivateKey privateKey = ((KeyPair)val).getPrivate();
            PublicKey publicKey = ((KeyPair)val).getPublic();
            if (!(privateKey instanceof RSAPrivateCrtKey)) throw PKeyRSA.newRSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
            this.privKey = (RSAPrivateCrtKey)privateKey;
            this.pubKey = (RSAPublicKey)publicKey;
            return this;
        } else if (val instanceof RSAPrivateCrtKey) {
            this.privKey = (RSAPrivateCrtKey)val;
            try {
                this.pubKey = (RSAPublicKey)fact.generatePublic(new RSAPublicKeySpec(this.privKey.getModulus(), this.privKey.getPublicExponent()));
                return this;
            }
            catch (Exception e) {
                throw PKeyRSA.newRSAError(this.getRuntime(), "Something rotten with private key");
            }
        } else {
            if (!(val instanceof RSAPublicKey)) throw PKeyRSA.newRSAError(this.getRuntime(), "Neither PUB key nor PRIV key:");
            this.pubKey = (RSAPublicKey)val;
            this.privKey = null;
        }
        return this;
    }

    @JRubyMethod(name={"public?"})
    public IRubyObject public_p() {
        return this.pubKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"private?"})
    public IRubyObject private_p() {
        return this.privKey != null ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_der() {
        try {
            byte[] bytes = PKey.toDerRSAKey(this.pubKey, this.privKey);
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])bytes);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject public_key() {
        PKeyRSA val = new PKeyRSA(this.getRuntime(), this.getMetaClass().getRealClass());
        val.privKey = null;
        val.pubKey = this.pubKey;
        return val;
    }

    @JRubyMethod
    public IRubyObject params() {
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        RubyHash hash = RubyHash.newHash((Ruby)this.getRuntime());
        if (this.privKey != null) {
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("iqmp"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getCrtCoefficient()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("n"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getModulus()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("d"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getPrivateExponent()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("p"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getPrimeP()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("e"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getPublicExponent()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("q"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getPrimeQ()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("dmq1"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getPrimeExponentQ()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("dmp1"), (IRubyObject)BN.newBN(this.getRuntime(), this.privKey.getPrimeExponentP()));
        } else {
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("iqmp"), (IRubyObject)BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("n"), (IRubyObject)BN.newBN(this.getRuntime(), this.pubKey.getModulus()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("d"), (IRubyObject)BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("p"), (IRubyObject)BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("e"), (IRubyObject)BN.newBN(this.getRuntime(), this.pubKey.getPublicExponent()));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("q"), (IRubyObject)BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("dmq1"), (IRubyObject)BN.newBN(this.getRuntime(), BigInteger.ZERO));
            hash.op_aset(ctx, (IRubyObject)this.getRuntime().newString("dmp1"), (IRubyObject)BN.newBN(this.getRuntime(), BigInteger.ZERO));
        }
        return hash;
    }

    @JRubyMethod
    public IRubyObject to_text() {
        StringBuilder result = new StringBuilder();
        if (this.privKey != null) {
            int len = this.privKey.getModulus().bitLength();
            result.append("Private-Key: (").append(len).append(" bit)").append("\n");
            result.append("modulus:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getModulus());
            result.append("publicExponent: ").append(this.privKey.getPublicExponent()).append(" (0x").append(this.privKey.getPublicExponent().toString(16)).append(")\n");
            result.append("privateExponent:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrivateExponent());
            result.append("prime1:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeP());
            result.append("prime2:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeQ());
            result.append("exponent1:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeExponentP());
            result.append("exponent2:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getPrimeExponentQ());
            result.append("coefficient:");
            PKeyRSA.addSplittedAndFormatted(result, this.privKey.getCrtCoefficient());
        } else {
            int len = this.pubKey.getModulus().bitLength();
            result.append("Modulus (").append(len).append(" bit):");
            PKeyRSA.addSplittedAndFormatted(result, this.pubKey.getModulus());
            result.append("Exponent: ").append(this.pubKey.getPublicExponent()).append(" (0x").append(this.pubKey.getPublicExponent().toString(16)).append(")\n");
        }
        return this.getRuntime().newString(result.toString());
    }

    @JRubyMethod(name={"export", "to_pem", "to_s"}, rest=true)
    public IRubyObject export(IRubyObject[] args) {
        StringWriter w = new StringWriter();
        Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)2);
        CipherSpec ciph = null;
        char[] passwd = null;
        if (args.length > 0 && !args[0].isNil()) {
            Cipher c = (Cipher)args[0];
            ciph = new CipherSpec(c.getCipher(), c.getName(), c.getKeyLen() * 8);
            if (args.length > 1 && !args[1].isNil()) {
                passwd = args[1].toString().toCharArray();
            }
        }
        try {
            if (this.privKey != null) {
                PEMInputOutput.writeRSAPrivateKey(w, this.privKey, ciph, passwd);
            } else {
                PEMInputOutput.writeRSAPublicKey(w, this.pubKey);
            }
            w.close();
            return this.getRuntime().newString(w.toString());
        }
        catch (NoClassDefFoundError ncdfe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), OpenSSLReal.bcExceptionMessage(ncdfe));
        }
        catch (IOException ioe) {
            throw PKeyRSA.newRSAError(this.getRuntime(), ioe.getMessage());
        }
    }

    private String getPadding(int padding) {
        if (padding < 1 || padding > 4) {
            throw PKeyRSA.newRSAError(this.getRuntime(), null);
        }
        String p = "/ECB/PKCS1Padding";
        if (padding == 3) {
            p = "/ECB/NoPadding";
        } else if (padding == 4) {
            p = "/ECB/OAEPWithMD5AndMGF1Padding";
        } else if (padding == 2) {
            p = "/ECB/ISO9796-1Padding";
        }
        return p;
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_encrypt(IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        String p = this.getPadding(padding);
        RubyString buffer = args[0].convertToString();
        if (this.privKey == null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "private key needed.");
        }
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p);
            engine.init(1, this.privKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject private_decrypt(IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        String p = this.getPadding(padding);
        RubyString buffer = args[0].convertToString();
        if (this.privKey == null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "private key needed.");
        }
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p);
            engine.init(2, this.privKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_encrypt(IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        String p = this.getPadding(padding);
        RubyString buffer = args[0].convertToString();
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p);
            engine.init(1, this.pubKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(rest=true)
    public IRubyObject public_decrypt(IRubyObject[] args) {
        int padding = 1;
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)1, (int)2) == 2 && !args[1].isNil()) {
            padding = RubyNumeric.fix2int((IRubyObject)args[1]);
        }
        String p = this.getPadding(padding);
        RubyString buffer = args[0].convertToString();
        try {
            javax.crypto.Cipher engine = javax.crypto.Cipher.getInstance("RSA" + p);
            engine.init(2, this.pubKey);
            byte[] outp = engine.doFinal(buffer.getBytes());
            return RubyString.newString((Ruby)this.getRuntime(), (byte[])outp);
        }
        catch (GeneralSecurityException gse) {
            throw PKeyRSA.newRSAError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod(name={"d="})
    public synchronized IRubyObject set_d(IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_d = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams();
        return value;
    }

    @JRubyMethod(name={"p="})
    public synchronized IRubyObject set_p(IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_p = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams();
        return value;
    }

    @JRubyMethod(name={"q="})
    public synchronized IRubyObject set_q(IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_q = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams();
        return value;
    }

    @JRubyMethod(name={"dmp1="})
    public synchronized IRubyObject set_dmp1(IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_dmp1 = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams();
        return value;
    }

    @JRubyMethod(name={"dmq1="})
    public synchronized IRubyObject set_dmq1(IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_dmq1 = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams();
        return value;
    }

    @JRubyMethod(name={"iqmp="})
    public synchronized IRubyObject set_iqmp(IRubyObject value) {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        this.rsa_iqmp = BN.getBigInteger(value);
        this.generatePrivateKeyIfParams();
        return value;
    }

    @JRubyMethod(name={"iqmp"})
    public synchronized IRubyObject get_iqmp() {
        BigInteger iqmp = null;
        iqmp = this.privKey != null ? this.privKey.getCrtCoefficient() : this.rsa_iqmp;
        if (iqmp != null) {
            return BN.newBN(this.getRuntime(), iqmp);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmp1"})
    public synchronized IRubyObject get_dmp1() {
        BigInteger dmp1 = null;
        dmp1 = this.privKey != null ? this.privKey.getPrimeExponentP() : this.rsa_dmp1;
        if (dmp1 != null) {
            return BN.newBN(this.getRuntime(), dmp1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"dmq1"})
    public synchronized IRubyObject get_dmq1() {
        BigInteger dmq1 = null;
        dmq1 = this.privKey != null ? this.privKey.getPrimeExponentQ() : this.rsa_dmq1;
        if (dmq1 != null) {
            return BN.newBN(this.getRuntime(), dmq1);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"d"})
    public synchronized IRubyObject get_d() {
        BigInteger d = null;
        d = this.privKey != null ? this.privKey.getPrivateExponent() : this.rsa_d;
        if (d != null) {
            return BN.newBN(this.getRuntime(), d);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"p"})
    public synchronized IRubyObject get_p() {
        BigInteger p = null;
        p = this.privKey != null ? this.privKey.getPrimeP() : this.rsa_p;
        if (p != null) {
            return BN.newBN(this.getRuntime(), p);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"q"})
    public synchronized IRubyObject get_q() {
        BigInteger q = null;
        q = this.privKey != null ? this.privKey.getPrimeQ() : this.rsa_q;
        if (q != null) {
            return BN.newBN(this.getRuntime(), q);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e"})
    public synchronized IRubyObject get_e() {
        RSAPublicKey key = this.pubKey;
        BigInteger e = key != null ? key.getPublicExponent() : (this.privKey != null ? this.privKey.getPublicExponent() : this.rsa_e);
        if (e != null) {
            return BN.newBN(this.getRuntime(), e);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"e="})
    public synchronized IRubyObject set_e(IRubyObject value) {
        this.rsa_e = BN.getBigInteger(value);
        if (this.privKey == null) {
            this.generatePrivateKeyIfParams();
        }
        if (this.pubKey == null) {
            this.generatePublicKeyIfParams();
        }
        return value;
    }

    @JRubyMethod(name={"n"})
    public synchronized IRubyObject get_n() {
        RSAPublicKey key = this.pubKey;
        BigInteger n = key != null ? key.getModulus() : (this.privKey != null ? this.privKey.getModulus() : this.rsa_n);
        if (n != null) {
            return BN.newBN(this.getRuntime(), n);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"n="})
    public synchronized IRubyObject set_n(IRubyObject value) {
        this.rsa_n = BN.getBigInteger(value);
        if (this.privKey == null) {
            this.generatePrivateKeyIfParams();
        }
        if (this.pubKey == null) {
            this.generatePublicKeyIfParams();
        }
        return value;
    }

    private void generatePublicKeyIfParams() {
        BigInteger n;
        if (this.pubKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        BigInteger e = this.rsa_e;
        if (e != null && (n = this.rsa_n) != null) {
            KeyFactory fact;
            try {
                fact = KeyFactory.getInstance("RSA");
            }
            catch (Exception ex) {
                throw this.getRuntime().newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.pubKey = (RSAPublicKey)fact.generatePublic(new RSAPublicKeySpec(n, e));
            }
            catch (InvalidKeySpecException ex) {
                throw PKeyRSA.newRSAError(this.getRuntime(), "invalid parameters");
            }
            this.rsa_e = null;
            this.rsa_n = null;
        }
    }

    private void generatePrivateKeyIfParams() {
        if (this.privKey != null) {
            throw PKeyRSA.newRSAError(this.getRuntime(), "illegal modification");
        }
        if (this.rsa_e != null && this.rsa_n != null && this.rsa_p != null && this.rsa_q != null && this.rsa_d != null && this.rsa_dmp1 != null && this.rsa_dmq1 != null && this.rsa_iqmp != null) {
            KeyFactory fact;
            try {
                fact = KeyFactory.getInstance("RSA");
            }
            catch (Exception ex) {
                throw this.getRuntime().newLoadError("unsupported key algorithm (RSA)");
            }
            try {
                this.privKey = (RSAPrivateCrtKey)fact.generatePrivate(new RSAPrivateCrtKeySpec(this.rsa_n, this.rsa_e, this.rsa_d, this.rsa_p, this.rsa_q, this.rsa_dmp1, this.rsa_dmq1, this.rsa_iqmp));
            }
            catch (InvalidKeySpecException ex) {
                throw PKeyRSA.newRSAError(this.getRuntime(), "invalid parameters");
            }
            this.rsa_n = null;
            this.rsa_e = null;
            this.rsa_d = null;
            this.rsa_p = null;
            this.rsa_q = null;
            this.rsa_dmp1 = null;
            this.rsa_dmq1 = null;
            this.rsa_iqmp = null;
        }
    }
}

