/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class HMAC
extends RubyObject {
    private static final long serialVersionUID = 7602535792884680307L;
    private static ObjectAllocator HMAC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new HMAC(runtime, klass);
        }
    };
    private Mac mac;
    private byte[] key;
    private StringBuffer data = new StringBuffer();

    public static void createHMAC(Ruby runtime, RubyModule ossl) {
        RubyClass cHMAC = ossl.defineClassUnder("HMAC", runtime.getObject(), HMAC_ALLOCATOR);
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        ossl.defineClassUnder("HMACError", openSSLError, openSSLError.getAllocator());
        cHMAC.defineAnnotatedMethods(HMAC.class);
    }

    static Mac getMac(String algoName) throws NoSuchAlgorithmException {
        try {
            return Mac.getInstance("HMAC" + algoName.replaceAll("-", ""));
        }
        catch (NoSuchAlgorithmException nsae) {
            return Mac.getInstance("HMAC-" + algoName.replaceAll("-", ""));
        }
    }

    @JRubyMethod(name={"digest"}, meta=true)
    public static IRubyObject s_digest(IRubyObject recv, IRubyObject digest, IRubyObject kay, IRubyObject data) {
        String algoName = HMAC.getDigestAlgorithmName(digest);
        try {
            Mac mac = HMAC.getMac(algoName);
            byte[] key = kay.convertToString().getBytes();
            SecretKeySpec keysp = new SecretKeySpec(key, mac.getAlgorithm());
            mac.init(keysp);
            return RubyString.newString((Ruby)recv.getRuntime(), (byte[])mac.doFinal(data.convertToString().getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw recv.getRuntime().newNotImplementedError(e.getMessage());
        }
    }

    @JRubyMethod(name={"hexdigest"}, meta=true)
    public static IRubyObject s_hexdigest(IRubyObject recv, IRubyObject digest, IRubyObject kay, IRubyObject data) {
        String algoName = HMAC.getDigestAlgorithmName(digest);
        try {
            Mac mac = HMAC.getMac(algoName);
            byte[] key = kay.convertToString().getBytes();
            SecretKeySpec keysp = new SecretKeySpec(key, mac.getAlgorithm());
            mac.init(keysp);
            return RubyString.newString((Ruby)recv.getRuntime(), (byte[])ByteList.plain((CharSequence)Utils.toHex(mac.doFinal(data.convertToString().getBytes()))));
        }
        catch (Exception e) {
            throw recv.getRuntime().newNotImplementedError(e.getMessage());
        }
    }

    public HMAC(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod
    public IRubyObject initialize(IRubyObject kay, IRubyObject digest) {
        String algoName = HMAC.getDigestAlgorithmName(digest);
        try {
            this.mac = HMAC.getMac(algoName);
            this.key = kay.convertToString().getBytes();
            SecretKeySpec keysp = new SecretKeySpec(this.key, this.mac.getAlgorithm());
            this.mac.init(keysp);
        }
        catch (Exception e) {
            throw this.getRuntime().newNotImplementedError(e.getMessage());
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(IRubyObject obj) {
        if (this == obj) {
            return this;
        }
        this.checkFrozen();
        String name = ((HMAC)obj).mac.getAlgorithm();
        try {
            this.mac = Mac.getInstance(name);
            this.key = ((HMAC)obj).key;
            SecretKeySpec keysp = new SecretKeySpec(this.key, name);
            this.mac.init(keysp);
        }
        catch (Exception e) {
            throw this.getRuntime().newNotImplementedError("Unsupported MAC algorithm (" + name + ")");
        }
        this.data = new StringBuffer(((HMAC)obj).data.toString());
        return this;
    }

    @JRubyMethod(name={"update", "<<"})
    public IRubyObject update(IRubyObject obj) {
        this.data.append(obj);
        return this;
    }

    @JRubyMethod
    public IRubyObject digest() {
        this.mac.reset();
        return RubyString.newString((Ruby)this.getRuntime(), (byte[])this.getSignatureBytes());
    }

    @JRubyMethod
    public IRubyObject reset() {
        this.data.setLength(0);
        return this;
    }

    @JRubyMethod(name={"hexdigest", "inspect", "to_s"})
    public IRubyObject hexdigest() {
        return RubyString.newString((Ruby)this.getRuntime(), (byte[])ByteList.plain((CharSequence)Utils.toHex(this.getSignatureBytes())));
    }

    String getAlgorithm() {
        return this.mac.getAlgorithm();
    }

    private byte[] getSignatureBytes() {
        this.mac.reset();
        return this.mac.doFinal(this.data.toString().getBytes());
    }

    private static String getDigestAlgorithmName(IRubyObject digest) {
        String algoName = null;
        algoName = digest instanceof Digest ? ((Digest)digest).getShortAlgorithm() : digest.asString().toString();
        return algoName;
    }
}

