/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOUtil;
import sun.nio.ch.KqueueArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

class KqueueSelectorImpl
extends SelectorImpl {
    protected int fd0;
    protected int fd1;
    KqueueArrayWrapper kqueueWrapper;
    private int totalChannels;
    private HashMap fdToKey;
    private boolean closed = false;
    private Object interruptLock = new Object();
    private boolean interruptTriggered = false;
    private BitSet updatedSet;

    KqueueSelectorImpl(SelectorProvider selectorProvider) {
        super(selectorProvider);
        int[] nArray = new int[2];
        IOUtil.initPipe(nArray, false);
        this.fd0 = nArray[0];
        this.fd1 = nArray[1];
        this.kqueueWrapper = new KqueueArrayWrapper();
        this.totalChannels = 1;
        this.kqueueWrapper.initInterrupt(this.fd0, this.fd1);
        this.updatedSet = new BitSet();
        this.fdToKey = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        Object object;
        if (this.closed) {
            throw new ClosedSelectorException();
        }
        this.processDeregisterQueue();
        try {
            this.begin();
            this.kqueueWrapper.poll(l);
            object = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.end();
            throw throwable;
        }
        this.end();
        this.processDeregisterQueue();
        int n = this.updateSelectedKeys();
        if (this.kqueueWrapper.interrupted()) {
            object = this.interruptLock;
            synchronized (object) {
                this.kqueueWrapper.clearInterrupted();
                IOUtil.drain(this.fd0);
                this.interruptTriggered = false;
            }
        }
        return n;
    }

    private int updateSelectedKeys() {
        SelectionKeyImpl selectionKeyImpl;
        int n;
        int n2;
        int n3 = this.kqueueWrapper.updated;
        int n4 = 0;
        this.updatedSet.clear();
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.kqueueWrapper.getDescriptor(n2);
            selectionKeyImpl = (SelectionKeyImpl)this.fdToKey.get(new Integer(n));
            if (selectionKeyImpl == null) continue;
            selectionKeyImpl.nioReadyOps(0);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.kqueueWrapper.getDescriptor(n2);
            selectionKeyImpl = (SelectionKeyImpl)this.fdToKey.get(new Integer(n));
            if (selectionKeyImpl == null) continue;
            int n5 = this.kqueueWrapper.getReventOps(n2);
            if (this.selectedKeys.contains(selectionKeyImpl)) {
                if (!selectionKeyImpl.channel.translateAndUpdateReadyOps(n5, selectionKeyImpl) || this.updatedSet.get(n)) continue;
                this.updatedSet.set(n);
                ++n4;
                continue;
            }
            selectionKeyImpl.channel.translateAndUpdateReadyOps(n5, selectionKeyImpl);
            if ((selectionKeyImpl.nioReadyOps() & selectionKeyImpl.nioInterestOps()) == 0) continue;
            this.selectedKeys.add(selectionKeyImpl);
            if (this.updatedSet.get(n)) continue;
            this.updatedSet.set(n);
            ++n4;
        }
        return n4;
    }

    protected void implClose() throws IOException {
        if (!this.closed) {
            this.closed = true;
            FileDispatcher.closeIntFD(this.fd0);
            FileDispatcher.closeIntFD(this.fd1);
            if (this.kqueueWrapper != null) {
                this.kqueueWrapper.release(this.fd0);
                this.kqueueWrapper.closeKqueueFD();
                this.kqueueWrapper = null;
                this.selectedKeys = null;
                Iterator iterator = this.keys.iterator();
                while (iterator.hasNext()) {
                    SelectionKeyImpl selectionKeyImpl = (SelectionKeyImpl)iterator.next();
                    this.deregister(selectionKeyImpl);
                    SelectableChannel selectableChannel = selectionKeyImpl.channel();
                    if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
                        ((SelChImpl)((Object)selectableChannel)).kill();
                    }
                    iterator.remove();
                }
                this.totalChannels = 0;
            }
            this.fd0 = -1;
            this.fd1 = -1;
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        int n = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.fdToKey.put(new Integer(n), selectionKeyImpl);
        ++this.totalChannels;
        this.keys.add(selectionKeyImpl);
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        int n = selectionKeyImpl.getIndex();
        assert (n >= 0);
        int n2 = selectionKeyImpl.channel.getFDVal();
        this.fdToKey.remove(new Integer(n2));
        this.kqueueWrapper.release(n2);
        --this.totalChannels;
        selectionKeyImpl.setIndex(-1);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        SelectableChannel selectableChannel = selectionKeyImpl.channel();
        if (!selectableChannel.isOpen() && !selectableChannel.isRegistered()) {
            ((SelChImpl)((Object)selectableChannel)).kill();
        }
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        int n2 = IOUtil.fdVal(selectionKeyImpl.channel.getFD());
        this.kqueueWrapper.setInterest(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.kqueueWrapper.interrupt();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        Util.load();
    }
}

