/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.tools.template_engine.SearchExpressionCondition;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class Condition
implements TemplateEntry {
    private final List<TemplateEntry> entries = new ArrayList<TemplateEntry>();

    public List<TemplateEntry> getEntries() {
        return this.entries;
    }

    @Override
    public void appendText(StringBuilder stringBuilder, TemplateEngineDataProvider templateEngineDataProvider) {
        for (TemplateEntry templateEntry : this.entries) {
            if (!templateEntry.isValid(templateEngineDataProvider)) continue;
            templateEntry.appendText(stringBuilder, templateEngineDataProvider);
            return;
        }
        TemplateEntry templateEntry = this.entries.get(this.entries.size() - 1);
        templateEntry.appendText(stringBuilder, templateEngineDataProvider);
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider templateEngineDataProvider) {
        for (TemplateEntry templateEntry : this.entries) {
            if (!templateEntry.isValid(templateEngineDataProvider)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("?{");
        for (TemplateEntry templateEntry : this.entries) {
            if (templateEntry instanceof SearchExpressionCondition) {
                stringBuilder.append(templateEntry.toString());
            } else {
                stringBuilder.append("'");
                stringBuilder.append(templateEntry.toString());
                stringBuilder.append("'");
            }
            stringBuilder.append("|");
        }
        return stringBuilder.toString();
    }
}

