/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.openstreetmap.josm.tools.Predicate;

public class SubclassFilteredCollection<S, T extends S>
extends AbstractCollection<T> {
    private final Collection<? extends S> collection;
    private final Predicate<? super S> predicate;
    int size = -1;

    public SubclassFilteredCollection(Collection<? extends S> collection, Predicate<? super S> predicate) {
        this.collection = collection;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new FilterIterator(this.collection.iterator());
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                ++this.size;
                iterator.next();
            }
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    private class FilterIterator
    implements Iterator<T> {
        private final Iterator<? extends S> iterator;
        private S current;

        public FilterIterator(Iterator<? extends S> iterator) {
            this.iterator = iterator;
        }

        private void findNext() {
            if (this.current == null) {
                while (this.iterator.hasNext()) {
                    this.current = this.iterator.next();
                    if (!SubclassFilteredCollection.this.predicate.evaluate(this.current)) continue;
                    return;
                }
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.current != null;
        }

        @Override
        public T next() {
            this.findNext();
            Object s = this.current;
            this.current = null;
            Object s2 = s;
            return s2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

