/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class InputMapUtils {
    private InputMapUtils() {
    }

    public static void unassignCtrlShiftUpDown(JComponent jComponent, int n) {
        InputMap inputMap = SwingUtilities.getUIInputMap(jComponent, n);
        inputMap.remove(KeyStroke.getKeyStroke(38, 3));
        inputMap.remove(KeyStroke.getKeyStroke(40, 3));
        inputMap.remove(KeyStroke.getKeyStroke(38, 9));
        inputMap.remove(KeyStroke.getKeyStroke(40, 9));
        SwingUtilities.replaceUIInputMap(jComponent, 1, inputMap);
    }

    public static void enableEnter(JButton jButton) {
        jButton.setFocusable(true);
        jButton.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        jButton.getActionMap().put("enter", jButton.getAction());
    }

    public static void addEnterAction(JComponent jComponent, Action action) {
        jComponent.getActionMap().put("enter", action);
        jComponent.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
    }

    public static void addSpacebarAction(JComponent jComponent, Action action) {
        jComponent.getActionMap().put("spacebar", action);
        jComponent.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "spacebar");
    }
}

