/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.DateParser;

public final class ExifReader {
    private ExifReader() {
    }

    public static Date readTime(File file) throws ParseException {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            String string = null;
            block3: for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    if (tag.getTagType() == 36867) {
                        string = tag.getDescription();
                        break block3;
                    }
                    if (tag.getTagType() != 306 && tag.getTagType() != 36868) continue;
                    string = tag.getDescription();
                }
            }
            if (string != null) {
                string = string.replace('/', ':');
                return DateParser.parse(string);
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Integer readOrientation(File file) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            ExifIFD0Directory exifIFD0Directory = metadata.getDirectory(ExifIFD0Directory.class);
            return exifIFD0Directory.getInt(274);
        }
        catch (JpegProcessingException jpegProcessingException) {
            jpegProcessingException.printStackTrace();
        }
        catch (MetadataException metadataException) {
            metadataException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static LatLon readLatLon(File file) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            GpsDirectory gpsDirectory = metadata.getDirectory(GpsDirectory.class);
            return ExifReader.readLatLon(gpsDirectory);
        }
        catch (JpegProcessingException jpegProcessingException) {
            jpegProcessingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (MetadataException metadataException) {
            metadataException.printStackTrace();
        }
        return null;
    }

    public static LatLon readLatLon(GpsDirectory gpsDirectory) throws MetadataException {
        if (gpsDirectory != null) {
            double d = ExifReader.readAxis(gpsDirectory, 2, 1, 'S');
            double d2 = ExifReader.readAxis(gpsDirectory, 4, 3, 'W');
            return new LatLon(d, d2);
        }
        return null;
    }

    public static Double readDirection(File file) {
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            GpsDirectory gpsDirectory = metadata.getDirectory(GpsDirectory.class);
            return ExifReader.readDirection(gpsDirectory);
        }
        catch (JpegProcessingException jpegProcessingException) {
            jpegProcessingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static Double readDirection(GpsDirectory gpsDirectory) {
        Rational rational;
        if (gpsDirectory != null && (rational = gpsDirectory.getRational(17)) != null) {
            return rational.doubleValue();
        }
        return null;
    }

    private static double readAxis(GpsDirectory gpsDirectory, int n, int n2, char c) throws MetadataException {
        double d;
        Rational[] rationalArray = gpsDirectory.getRationalArray(n);
        if (rationalArray != null) {
            double d2 = rationalArray[0].doubleValue();
            double d3 = rationalArray[1].doubleValue();
            double d4 = rationalArray[2].doubleValue();
            if (Double.isNaN(d2) && Double.isNaN(d3) && Double.isNaN(d4)) {
                throw new IllegalArgumentException();
            }
            double d5 = Double.isNaN(d2) ? 0.0 : (d = d2 + (Double.isNaN(d3) ? 0.0 : d3 / 60.0) + (Double.isNaN(d4) ? 0.0 : d4 / 3600.0));
            if (gpsDirectory.getString(n2).charAt(0) == c) {
                d = -d;
            }
        } else {
            d = gpsDirectory.getDouble(n);
        }
        return d;
    }
}

