/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public abstract class RequestHandler {
    public static final String globalConfirmationKey = "remotecontrol.always-confirm";
    public static final boolean globalConfirmationDefault = false;
    public static final String loadInNewLayerKey = "remotecontrol.new-layer";
    public static final boolean loadInNewLayerDefault = false;
    protected Map<String, String> args;
    protected String request;
    protected String content = "OK\r\n";
    protected String contentType = "text/plain";
    protected String myCommand;
    protected String sender;

    public final void handle() throws RequestHandlerForbiddenException, RequestHandlerBadRequestException, RequestHandlerErrorException {
        this.checkMandatoryParams();
        this.validateRequest();
        this.checkPermission();
        this.handleRequest();
    }

    protected abstract void validateRequest() throws RequestHandlerBadRequestException;

    protected abstract void handleRequest() throws RequestHandlerErrorException, RequestHandlerBadRequestException;

    public abstract String getPermissionMessage();

    public abstract PermissionPrefWithDefault getPermissionPref();

    public abstract String[] getMandatoryParams();

    public String[] getOptionalParams() {
        return null;
    }

    public String[] getUsageExamples() {
        return null;
    }

    public String[] getUsageExamples(String string) {
        return this.getUsageExamples();
    }

    public final void checkPermission() throws RequestHandlerForbiddenException {
        PermissionPrefWithDefault permissionPrefWithDefault = this.getPermissionPref();
        if (permissionPrefWithDefault != null && permissionPrefWithDefault.pref != null && !Main.pref.getBoolean(permissionPrefWithDefault.pref, permissionPrefWithDefault.defaultVal)) {
            String string = MessageFormat.format("RemoteControl: ''{0}'' forbidden by preferences", this.myCommand);
            Main.info(string);
            throw new RequestHandlerForbiddenException(string);
        }
        if (Main.pref.getBoolean(globalConfirmationKey, false)) {
            Integer n = (int)Math.max(200.0, (double)Main.parent.getWidth() * 0.6);
            String string = "<html><div>" + this.getPermissionMessage() + "<br/>" + I18n.tr("Do you want to allow this?", new Object[0]) + "</div></html>";
            JLabel jLabel = new JLabel(string);
            if (jLabel.getPreferredSize().width > n) {
                jLabel.setText(string.replaceFirst("<div>", "<div style=\"width:" + n + "px;\">"));
            }
            if (JOptionPane.showConfirmDialog(Main.parent, jLabel, I18n.tr("Confirm Remote Control action", new Object[0]), 0) != 0) {
                String string2 = MessageFormat.format("RemoteControl: ''{0}'' forbidden by user''s choice", this.myCommand);
                throw new RequestHandlerForbiddenException(string2);
            }
        }
    }

    public void setUrl(String string) {
        this.request = string;
        this.parseArgs();
    }

    protected void parseArgs() {
        try {
            String string = URLDecoder.decode(this.request, "UTF-8");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string.indexOf(63) != -1) {
                String[] stringArray;
                String string2 = string.substring(string.indexOf(63) + 1);
                if (string2.indexOf(35) != -1) {
                    string2 = string2.substring(0, string2.indexOf(35));
                }
                for (String string3 : stringArray = string2.split("&", -1)) {
                    int n = string3.indexOf(61);
                    if (n == -1) continue;
                    hashMap.put(string3.substring(0, n), string3.substring(n + 1));
                }
            }
            this.args = hashMap;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    void checkMandatoryParams() throws RequestHandlerBadRequestException {
        String[] stringArray = this.getMandatoryParams();
        String[] stringArray2 = this.getOptionalParams();
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        if (stringArray != null) {
            for (String string : stringArray) {
                String string2 = this.args.get(string);
                if (string2 != null && string2.length() != 0) continue;
                bl = true;
                Main.warn("'" + this.myCommand + "' remote control request must have '" + string + "' parameter");
                linkedList.add(string);
            }
        }
        HashSet hashSet = new HashSet();
        if (stringArray != null) {
            Collections.addAll(hashSet, stringArray);
        }
        if (stringArray2 != null) {
            Collections.addAll(hashSet, stringArray2);
        }
        for (String string : this.args.keySet()) {
            if (hashSet.contains(string)) continue;
            Main.warn("Unknown remote control parameter {0}, skipping it", string);
        }
        if (bl) {
            throw new RequestHandlerBadRequestException("The following keys are mandatory, but have not been provided: " + Utils.join(", ", linkedList));
        }
    }

    public void setCommand(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        this.myCommand = string;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected boolean isLoadInNewLayer() {
        return this.args.get("new_layer") != null && !this.args.get("new_layer").isEmpty() ? Boolean.parseBoolean(this.args.get("new_layer")) : Main.pref.getBoolean(loadInNewLayerKey, false);
    }

    protected final String decodeParam(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException();
        }
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public static class RequestHandlerForbiddenException
    extends RequestHandlerException {
        private static final long serialVersionUID = 2263904699747115423L;

        public RequestHandlerForbiddenException(String string) {
            super(string);
        }
    }

    public static class RequestHandlerBadRequestException
    extends RequestHandlerException {
        public RequestHandlerBadRequestException(String string) {
            super(string);
        }
    }

    public static class RequestHandlerErrorException
    extends RequestHandlerException {
    }

    public static class RequestHandlerException
    extends Exception {
        public RequestHandlerException(String string) {
            super(string);
        }

        public RequestHandlerException() {
        }
    }
}

