/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangeReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class OsmServerLocationReader
extends OsmServerReader {
    protected final String url;

    public OsmServerLocationReader(String string) {
        this.url = string;
    }

    protected final <T> T doParse(Parser<T> parser, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(I18n.tr("Contacting Server...", 10));
        try {
            T t = parser.parse();
            return t;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            if (this.cancel) {
                T t = null;
                return t;
            }
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
            Utils.close(parser.in);
            parser.in = null;
        }
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new OsmParser(progressMonitor, OsmServerReader.Compression.NONE), progressMonitor);
    }

    @Override
    public DataSet parseOsmBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new OsmParser(progressMonitor, OsmServerReader.Compression.BZIP2), progressMonitor);
    }

    @Override
    public DataSet parseOsmGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new OsmParser(progressMonitor, OsmServerReader.Compression.GZIP), progressMonitor);
    }

    @Override
    public DataSet parseOsmChange(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new OsmChangeParser(progressMonitor, OsmServerReader.Compression.NONE), progressMonitor);
    }

    @Override
    public DataSet parseOsmChangeBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new OsmChangeParser(progressMonitor, OsmServerReader.Compression.BZIP2), progressMonitor);
    }

    @Override
    public DataSet parseOsmChangeGzip(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new OsmChangeParser(progressMonitor, OsmServerReader.Compression.GZIP), progressMonitor);
    }

    @Override
    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new GpxParser(progressMonitor, OsmServerReader.Compression.NONE), progressMonitor);
    }

    @Override
    public GpxData parseRawGpsBzip2(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.doParse(new GpxParser(progressMonitor, OsmServerReader.Compression.BZIP2), progressMonitor);
    }

    protected class GpxParser
    extends Parser<GpxData> {
        protected GpxParser(ProgressMonitor progressMonitor, OsmServerReader.Compression compression) {
            super(progressMonitor, compression);
        }

        @Override
        public GpxData parse() throws OsmTransferException, IllegalDataException, IOException, SAXException {
            this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, this.progressMonitor.createSubTaskMonitor(1, true));
            if (this.in == null) {
                return null;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            GpxReader gpxReader = new GpxReader(this.getUncompressedInputStream());
            OsmServerLocationReader.this.gpxParsedProperly = gpxReader.parse(false);
            GpxData gpxData = gpxReader.getGpxData();
            gpxData.fromServer = DownloadGpsTask.isFromServer(OsmServerLocationReader.this.url);
            return gpxData;
        }
    }

    protected class OsmChangeParser
    extends Parser<DataSet> {
        protected OsmChangeParser(ProgressMonitor progressMonitor, OsmServerReader.Compression compression) {
            super(progressMonitor, compression);
        }

        @Override
        public DataSet parse() throws OsmTransferException, IllegalDataException, IOException {
            this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, this.progressMonitor.createSubTaskMonitor(9, false));
            if (this.in == null) {
                return null;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            return OsmChangeReader.parseDataSet(this.getUncompressedInputStream(), this.progressMonitor.createSubTaskMonitor(1, false));
        }
    }

    protected class OsmParser
    extends Parser<DataSet> {
        protected OsmParser(ProgressMonitor progressMonitor, OsmServerReader.Compression compression) {
            super(progressMonitor, compression);
        }

        @Override
        public DataSet parse() throws OsmTransferException, IllegalDataException, IOException {
            this.in = OsmServerLocationReader.this.getInputStreamRaw(OsmServerLocationReader.this.url, this.progressMonitor.createSubTaskMonitor(9, false));
            if (this.in == null) {
                return null;
            }
            this.progressMonitor.subTask(I18n.tr("Downloading OSM data...", new Object[0]));
            return OsmReader.parseDataSet(this.getUncompressedInputStream(), this.progressMonitor.createSubTaskMonitor(1, false));
        }
    }

    protected abstract class Parser<T> {
        protected final ProgressMonitor progressMonitor;
        protected final OsmServerReader.Compression compression;
        protected InputStream in = null;

        public Parser(ProgressMonitor progressMonitor, OsmServerReader.Compression compression) {
            this.progressMonitor = progressMonitor;
            this.compression = compression;
        }

        protected final InputStream getUncompressedInputStream() throws IOException {
            switch (this.compression) {
                case BZIP2: {
                    return FileImporter.getBZip2InputStream(this.in);
                }
                case GZIP: {
                    return FileImporter.getGZipInputStream(this.in);
                }
            }
            return this.in;
        }

        public abstract T parse() throws OsmTransferException, IllegalDataException, IOException, SAXException;
    }
}

