/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmHistoryReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmServerHistoryReader
extends OsmServerReader {
    private OsmPrimitiveType primitiveType;
    private long id;

    public OsmServerHistoryReader(OsmPrimitiveType osmPrimitiveType, long l) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        if (l < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected. Got ''{1}''.", "id", l));
        }
        this.primitiveType = osmPrimitiveType;
        this.id = l;
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryDataSet parseHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        HistoryDataSet historyDataSet;
        InputStream inputStream;
        block10: {
            HistoryDataSet historyDataSet2;
            block9: {
                HistoryDataSet historyDataSet3;
                inputStream = null;
                progressMonitor.beginTask("");
                progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server...", new Object[0]));
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.primitiveType.getAPIName()).append("/").append(this.id).append("/history");
                inputStream = this.getInputStream(stringBuffer.toString(), progressMonitor.createSubTaskMonitor(1, true));
                if (inputStream == null) {
                    historyDataSet2 = null;
                    progressMonitor.finishTask();
                    break block9;
                }
                progressMonitor.indeterminateSubTask(I18n.tr("Downloading history...", new Object[0]));
                OsmHistoryReader osmHistoryReader = new OsmHistoryReader(inputStream);
                historyDataSet = historyDataSet3 = osmHistoryReader.parse(progressMonitor.createSubTaskMonitor(1, true));
                progressMonitor.finishTask();
                break block10;
            }
            Utils.close(inputStream);
            this.activeConnection = null;
            return historyDataSet2;
        }
        Utils.close(inputStream);
        this.activeConnection = null;
        return historyDataSet;
        catch (Exception exception) {
            if (!this.cancel) throw new OsmTransferException(exception);
            HistoryDataSet historyDataSet4 = null;
            return historyDataSet4;
        }
        finally {
            progressMonitor.finishTask();
            Utils.close(inputStream);
            this.activeConnection = null;
        }
    }
}

