/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractParser;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmChangesetContentParser {
    private InputSource source;
    private final ChangesetDataSet data = new ChangesetDataSet();

    public OsmChangesetContentParser(InputStream inputStream) throws UnsupportedEncodingException {
        CheckParameterUtil.ensureParameterNotNull(inputStream, "source");
        this.source = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
    }

    public OsmChangesetContentParser(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "source");
        this.source = new InputSource(new StringReader(string));
    }

    public ChangesetDataSet parse(ProgressMonitor progressMonitor) throws OsmDataParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing changeset content ...", new Object[0]));
            SAXParserFactory.newInstance().newSAXParser().parse(this.source, (DefaultHandler)new Parser());
        }
        catch (OsmDataParsingException osmDataParsingException) {
            throw osmDataParsingException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OsmDataParsingException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new OsmDataParsingException(sAXException);
        }
        catch (IOException iOException) {
            throw new OsmDataParsingException(iOException);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    public ChangesetDataSet parse() throws OsmDataParsingException {
        return this.parse(null);
    }

    private class Parser
    extends AbstractParser {
        private ChangesetDataSet.ChangesetModificationType currentModificationType;

        private Parser() {
        }

        @Override
        protected void throwException(String string) throws OsmDataParsingException {
            throw new OsmDataParsingException(string).rememberLocation(this.locator);
        }

        protected void throwException(Exception exception) throws OsmDataParsingException {
            throw new OsmDataParsingException(exception).rememberLocation(this.locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!super.doStartElement(string3, attributes) && !string3.equals("osmChange")) {
                if (string3.equals("create")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.CREATED;
                } else if (string3.equals("modify")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.UPDATED;
                } else if (string3.equals("delete")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.DELETED;
                } else {
                    Main.warn(I18n.tr("Unsupported start element ''{0}'' in changeset content at position ({1},{2}). Skipping.", string3, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("node") || string3.equals("way") || string3.equals("relation")) {
                if (this.currentModificationType == null) {
                    this.throwException(I18n.tr("Illegal document structure. Found node, way, or relation outside of ''create'', ''modify'', or ''delete''.", new Object[0]));
                }
                OsmChangesetContentParser.this.data.put(this.currentPrimitive, this.currentModificationType);
            } else if (!string3.equals("osmChange")) {
                if (string3.equals("create")) {
                    this.currentModificationType = null;
                } else if (string3.equals("modify")) {
                    this.currentModificationType = null;
                } else if (string3.equals("delete")) {
                    this.currentModificationType = null;
                } else if (!(string3.equals("tag") || string3.equals("nd") || string3.equals("member"))) {
                    Main.warn(I18n.tr("Unsupported end element ''{0}'' in changeset content at position ({1},{2}). Skipping.", string3, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                }
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }
    }
}

