/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GeoJSONWriter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class GeoJSONExporter
extends FileExporter {
    public static final ExtensionFileFilter FILE_FILTER = new ExtensionFileFilter("json,geojson", "json", I18n.tr("GeoJSON Files", new Object[0]) + " (*.json *.geojson)");

    public GeoJSONExporter() {
        super(FILE_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            String string = new GeoJSONWriter((OsmDataLayer)layer).write();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            try {
                bufferedWriter.write(string);
            }
            finally {
                Utils.close(bufferedWriter);
            }
        } else {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' not supported", layer.getClass().toString()));
        }
    }
}

