/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public class DisableShortcutsOnFocusGainedTextField
extends JosmTextField
implements FocusListener {
    private final List<Pair<Action, Shortcut>> unregisteredActionShortcuts = new ArrayList<Pair<Action, Shortcut>>();
    private final Set<JosmAction> disabledMenuActions = new HashSet<JosmAction>();

    public DisableShortcutsOnFocusGainedTextField() {
        this.init();
    }

    public DisableShortcutsOnFocusGainedTextField(String string) {
        super(string);
        this.init();
    }

    public DisableShortcutsOnFocusGainedTextField(int n) {
        super(n);
        this.init();
    }

    public DisableShortcutsOnFocusGainedTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    public DisableShortcutsOnFocusGainedTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    protected void init() {
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.disableMenuActions();
        this.unregisterActionShortcuts();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.restoreActionShortcuts();
        this.restoreMenuActions();
    }

    protected void disableMenuActions() {
        this.disabledMenuActions.clear();
        for (int i = 0; i < Main.main.menu.getMenuCount(); ++i) {
            JMenu jMenu = Main.main.menu.getMenu(i);
            if (jMenu == null) continue;
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                KeyStroke keyStroke;
                Shortcut shortcut;
                Action action;
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null || !((action = jMenuItem.getAction()) instanceof JosmAction) || !action.isEnabled() || (shortcut = ((JosmAction)action).getShortcut()) == null || !this.hasToBeDisabled(keyStroke = shortcut.getKeyStroke())) continue;
                action.setEnabled(false);
                this.disabledMenuActions.add((JosmAction)action);
            }
        }
    }

    protected void unregisterActionShortcuts() {
        this.unregisteredActionShortcuts.clear();
        for (Shortcut shortcut : Shortcut.listAll()) {
            Action action;
            KeyStroke keyStroke = shortcut.getKeyStroke();
            if (!this.hasToBeDisabled(keyStroke) || (action = Main.getRegisteredActionShortcut(shortcut)) == null) continue;
            Main.unregisterActionShortcut(action, shortcut);
            this.unregisteredActionShortcuts.add(new Pair<Action, Shortcut>(action, shortcut));
        }
    }

    protected boolean hasToBeDisabled(KeyStroke keyStroke) {
        return keyStroke != null && keyStroke.getModifiers() == 0 && !new KeyEvent(this, 401, 0L, keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar()).isActionKey();
    }

    protected void restoreMenuActions() {
        for (JosmAction josmAction : this.disabledMenuActions) {
            josmAction.setEnabled(true);
        }
        this.disabledMenuActions.clear();
    }

    protected void restoreActionShortcuts() {
        for (Pair<Action, Shortcut> pair : this.unregisteredActionShortcuts) {
            Main.registerActionShortcut((Action)pair.a, (Shortcut)pair.b);
        }
        this.unregisteredActionShortcuts.clear();
    }
}

