/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public final class TaggingPresetReader {
    private static File zipIcons = null;

    private TaggingPresetReader() {
    }

    public static List<String> getPresetSources() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (SourceEntry sourceEntry : new TaggingPresetPreference.PresetPrefHelper().get()) {
            linkedList.add(sourceEntry.url);
        }
        return linkedList;
    }

    public static List<TaggingPreset> readAll(Reader reader, boolean bl) throws SAXException {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.mapOnStart("item", TaggingPreset.class);
        xmlObjectParser.mapOnStart("separator", TaggingPresetSeparator.class);
        xmlObjectParser.mapBoth("group", TaggingPresetMenu.class);
        xmlObjectParser.map("text", TaggingPresetItems.Text.class);
        xmlObjectParser.map("link", TaggingPresetItems.Link.class);
        xmlObjectParser.mapOnStart("optional", TaggingPresetItems.Optional.class);
        xmlObjectParser.mapOnStart("roles", TaggingPresetItems.Roles.class);
        xmlObjectParser.map("role", TaggingPresetItems.Role.class);
        xmlObjectParser.map("checkgroup", TaggingPresetItems.CheckGroup.class);
        xmlObjectParser.map("check", TaggingPresetItems.Check.class);
        xmlObjectParser.map("combo", TaggingPresetItems.Combo.class);
        xmlObjectParser.map("multiselect", TaggingPresetItems.MultiSelect.class);
        xmlObjectParser.map("label", TaggingPresetItems.Label.class);
        xmlObjectParser.map("space", TaggingPresetItems.Space.class);
        xmlObjectParser.map("key", TaggingPresetItems.Key.class);
        xmlObjectParser.map("list_entry", TaggingPresetItems.PresetListEntry.class);
        xmlObjectParser.map("item_separator", TaggingPresetItems.ItemSeparator.class);
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        TaggingPreset taggingPreset = null;
        TaggingPresetItems.Roles roles = null;
        LinkedList<TaggingPresetItems.Check> linkedList2 = new LinkedList<TaggingPresetItems.Check>();
        LinkedList<TaggingPresetItems.PresetListEntry> linkedList3 = new LinkedList<TaggingPresetItems.PresetListEntry>();
        if (bl) {
            xmlObjectParser.startWithValidation(reader, "http://josm.openstreetmap.de/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            xmlObjectParser.start(reader);
        }
        while (xmlObjectParser.hasNext()) {
            TaggingPreset taggingPreset2;
            Object object = xmlObjectParser.next();
            if (!(object instanceof TaggingPresetItem) && !linkedList2.isEmpty()) {
                linkedList.getLast().data.addAll(linkedList2);
                linkedList2.clear();
            }
            if (object instanceof TaggingPresetMenu) {
                taggingPreset2 = (TaggingPresetMenu)object;
                if (taggingPreset2 == taggingPreset) {
                    taggingPreset = ((TaggingPresetMenu)taggingPreset2).group;
                } else {
                    ((TaggingPresetMenu)taggingPreset2).group = taggingPreset;
                    ((TaggingPresetMenu)taggingPreset2).setDisplayName();
                    taggingPreset = taggingPreset2;
                    linkedList.add(taggingPreset2);
                }
                roles = null;
                continue;
            }
            if (object instanceof TaggingPresetSeparator) {
                taggingPreset2 = (TaggingPresetSeparator)object;
                ((TaggingPresetSeparator)taggingPreset2).group = taggingPreset;
                linkedList.add(taggingPreset2);
                roles = null;
                continue;
            }
            if (object instanceof TaggingPreset) {
                taggingPreset2 = (TaggingPreset)object;
                taggingPreset2.group = taggingPreset;
                taggingPreset2.setDisplayName();
                linkedList.add(taggingPreset2);
                roles = null;
                continue;
            }
            if (!linkedList.isEmpty()) {
                if (object instanceof TaggingPresetItems.Roles) {
                    linkedList.getLast().data.add((TaggingPresetItem)object);
                    if (linkedList.getLast().roles != null) {
                        throw new SAXException(I18n.tr("Roles cannot appear more than once", new Object[0]));
                    }
                    linkedList.getLast().roles = (TaggingPresetItems.Roles)object;
                    roles = (TaggingPresetItems.Roles)object;
                    continue;
                }
                if (object instanceof TaggingPresetItems.Role) {
                    if (roles == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent", new Object[0]));
                    }
                    roles.roles.add((TaggingPresetItems.Role)object);
                    continue;
                }
                if (object instanceof TaggingPresetItems.Check) {
                    linkedList2.add((TaggingPresetItems.Check)object);
                    continue;
                }
                if (object instanceof TaggingPresetItems.PresetListEntry) {
                    linkedList3.add((TaggingPresetItems.PresetListEntry)object);
                    continue;
                }
                if (object instanceof TaggingPresetItems.CheckGroup) {
                    linkedList.getLast().data.add((TaggingPresetItem)object);
                    ((TaggingPresetItems.CheckGroup)object).checks.addAll(linkedList2);
                    linkedList2.clear();
                    continue;
                }
                if (!linkedList2.isEmpty()) {
                    linkedList.getLast().data.addAll(linkedList2);
                    linkedList2.clear();
                }
                linkedList.getLast().data.add((TaggingPresetItem)object);
                if (object instanceof TaggingPresetItems.ComboMultiSelect) {
                    ((TaggingPresetItems.ComboMultiSelect)object).addListEntries(linkedList3);
                } else if (object instanceof TaggingPresetItems.Key && ((TaggingPresetItems.Key)object).value == null) {
                    ((TaggingPresetItems.Key)object).value = "";
                }
                linkedList3 = new LinkedList();
                roles = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent", new Object[0]));
        }
        if (!linkedList.isEmpty() && !linkedList2.isEmpty()) {
            linkedList.getLast().data.addAll(linkedList2);
            linkedList2.clear();
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<TaggingPreset> readAll(String string, boolean bl) throws SAXException, IOException {
        List<TaggingPreset> list;
        MirroredInputStream mirroredInputStream = new MirroredInputStream(string);
        try {
            InputStreamReader inputStreamReader;
            InputStream inputStream = mirroredInputStream.findZipEntryInputStream("xml", "preset");
            if (inputStream != null) {
                zipIcons = mirroredInputStream.getFile();
            }
            try {
                inputStreamReader = new InputStreamReader(inputStream == null ? mirroredInputStream : inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream == null ? mirroredInputStream : inputStream);
            }
            try {
                list = TaggingPresetReader.readAll(new BufferedReader(inputStreamReader), bl);
            }
            finally {
                Utils.close(inputStreamReader);
            }
        }
        finally {
            Utils.close(mirroredInputStream);
        }
        return list;
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl) {
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        for (String string : collection) {
            try {
                linkedList.addAll(TaggingPresetReader.readAll(string, bl));
            }
            catch (IOException iOException) {
                Main.error(iOException);
                Main.error(string);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", string), I18n.tr("Error", new Object[0]), 0);
            }
            catch (SAXException sAXException) {
                Main.error(sAXException);
                Main.error(string);
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("Error parsing {0}: ", string) + "<br><br><table width=600>" + sAXException.getMessage() + "</table></html>", I18n.tr("Error", new Object[0]), 0);
            }
        }
        return linkedList;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean bl) {
        return TaggingPresetReader.readAll(TaggingPresetReader.getPresetSources(), bl);
    }

    public static File getZipIcons() {
        return zipIcons;
    }
}

