/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.TaggingPresetItems;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetReader;
import org.openstreetmap.josm.gui.tagging.TaggingPresetType;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.TemplateParser;
import org.xml.sax.SAXException;

public class TaggingPreset
extends AbstractAction
implements MapView.LayerChangeListener {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public TaggingPresetMenu group = null;
    public String name;
    public String name_context;
    public String locale_name;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    public EnumSet<TaggingPresetType> types;
    public List<TaggingPresetItem> data = new LinkedList<TaggingPresetItem>();
    public TaggingPresetItems.Roles roles;
    public TemplateEntry nameTemplate;
    public SearchCompiler.Match nameTemplateFilter;
    private boolean originalSelectionEmpty = false;

    public TaggingPreset() {
        MapView.addLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
        this.putValue(OPTIONAL_TOOLTIP_TEXT, this.group != null ? I18n.tr("Use preset ''{0}'' of group ''{1}''", this.getLocaleName(), this.group.getName()) : I18n.tr("Use preset ''{0}''", this.getLocaleName()));
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, TaggingPresetItems.fixPresetString(this.name)) : I18n.tr(TaggingPresetItems.fixPresetString(this.name), new Object[0]);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + "/" + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + "/" + this.name : this.name;
    }

    public final ImageIcon getIcon() {
        Object object = this.getValue("SmallIcon");
        if (object instanceof ImageIcon) {
            return (ImageIcon)object;
        }
        return null;
    }

    public void setIcon(final String string) {
        ImageProvider imageProvider = new ImageProvider(string);
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        imageProvider.setDirs(collection);
        imageProvider.setId("presets");
        imageProvider.setArchive(TaggingPresetReader.getZipIcons());
        imageProvider.setOptional(true);
        imageProvider.setMaxWidth(16).setMaxHeight(16);
        imageProvider.getInBackground(new ImageProvider.ImageCallback(){

            @Override
            public void finished(final ImageIcon imageIcon) {
                if (imageIcon != null) {
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            TaggingPreset.this.putValue("SmallIcon", imageIcon);
                        }
                    });
                } else {
                    Main.warn("Could not get presets icon " + string);
                }
            }
        });
    }

    public void setType(String string) throws SAXException {
        this.types = TaggingPresetItems.getType(string);
    }

    public void setName_template(String string) throws SAXException {
        try {
            this.nameTemplate = new TemplateParser(string).parse();
        }
        catch (ParseError parseError) {
            Main.error("Error while parsing " + string + ": " + parseError.getMessage());
            throw new SAXException(parseError);
        }
    }

    public void setName_template_filter(String string) throws SAXException {
        try {
            this.nameTemplateFilter = SearchCompiler.compile(string, false, false);
        }
        catch (SearchCompiler.ParseError parseError) {
            Main.error("Error while parsing" + string + ": " + parseError.getMessage());
            throw new SAXException(parseError);
        }
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> collection) {
        JPanel jPanel;
        if (this.data == null) {
            return null;
        }
        PresetPanel presetPanel = new PresetPanel();
        LinkedList<TaggingPresetItem> linkedList = new LinkedList<TaggingPresetItem>();
        if (this.types != null) {
            jPanel = new JPanel();
            for (TaggingPresetType object : this.types) {
                JLabel jLabel = new JLabel(ImageProvider.get(object.getIconName()));
                jLabel.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(object.getName(), new Object[0])));
                jPanel.add(jLabel);
            }
            presetPanel.add((Component)jPanel, GBC.eol());
        }
        jPanel = new JPanel(new GridBagLayout());
        for (TaggingPresetItem taggingPresetItem : this.data) {
            if (taggingPresetItem instanceof TaggingPresetItems.Link) {
                linkedList.add(taggingPresetItem);
                continue;
            }
            if (!taggingPresetItem.addToPanel(jPanel, collection)) continue;
            presetPanel.hasElements = true;
        }
        presetPanel.add((Component)jPanel, GBC.eol().fill());
        if (collection.isEmpty() && !this.supportsRelation()) {
            GuiHelper.setEnabledRec(jPanel, false);
        }
        for (TaggingPresetItem taggingPresetItem : linkedList) {
            taggingPresetItem.addToPanel(presetPanel, collection);
        }
        return presetPanel;
    }

    public boolean isShowable() {
        for (TaggingPresetItem taggingPresetItem : this.data) {
            if (taggingPresetItem instanceof TaggingPresetItems.Optional || taggingPresetItem instanceof TaggingPresetItems.Space || taggingPresetItem instanceof TaggingPresetItems.Key) continue;
            return true;
        }
        return false;
    }

    public String suggestRoleForOsmPrimitive(OsmPrimitive osmPrimitive) {
        if (this.roles != null && osmPrimitive != null) {
            for (TaggingPresetItems.Role role : this.roles.roles) {
                if (role.memberExpression == null || !role.memberExpression.match(osmPrimitive) || role.types != null && !role.types.isEmpty() && !role.types.contains((Object)TaggingPresetType.forPrimitive(osmPrimitive))) continue;
                return role.key;
            }
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.main == null) {
            return;
        }
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> collection = this.createSelection(Main.main.getCurrentDataSet().getSelected());
        int n = this.showDialog(collection, this.supportsRelation());
        if (!collection.isEmpty() && n == 1) {
            Command command = TaggingPreset.createCommand(collection, this.getChangedTags());
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        } else if (n == 2) {
            final Relation relation = new Relation();
            final HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            for (Tag object : this.getChangedTags()) {
                relation.put(object.getKey(), object.getValue());
            }
            for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
                String string = this.suggestRoleForOsmPrimitive(osmPrimitive);
                RelationMember relationMember = new RelationMember(string == null ? "" : string, osmPrimitive);
                relation.addMember(relationMember);
                hashSet.add(relationMember);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RelationEditor.getEditor(Main.main.getEditLayer(), relation, hashSet).setVisible(true);
                }
            });
        }
        Main.main.getCurrentDataSet().setSelected(Main.main.getCurrentDataSet().getSelected());
    }

    public int showDialog(Collection<OsmPrimitive> collection, final boolean bl) {
        PresetPanel presetPanel = this.createPanel(collection);
        if (presetPanel == null) {
            return 3;
        }
        int n = 1;
        if (presetPanel.getComponentCount() != 0 && (collection.isEmpty() || presetPanel.hasElements)) {
            String string = I18n.trn("Change {0} object", "Change {0} objects", collection.size(), collection.size());
            if (collection.isEmpty()) {
                string = this.originalSelectionEmpty ? I18n.tr("Nothing selected!", new Object[0]) : I18n.tr("Selection unsuitable!", new Object[0]);
            }
            class PresetDialog
            extends ExtendedDialog {
                public PresetDialog(Component component, String string, ImageIcon imageIcon, boolean bl3) {
                    String[] stringArray;
                    if (bl2) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = I18n.tr("Apply Preset", new Object[0]);
                        stringArray2[1] = I18n.tr("New relation", new Object[0]);
                        stringArray = stringArray2;
                        stringArray2[2] = I18n.tr("Cancel", new Object[0]);
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = I18n.tr("Apply Preset", new Object[0]);
                        stringArray = stringArray3;
                        stringArray3[1] = I18n.tr("Cancel", new Object[0]);
                    }
                    super(Main.parent, string, stringArray, true);
                    if (imageIcon != null) {
                        this.setIconImage(imageIcon.getImage());
                    }
                    this.contentInsets = new Insets(10, 5, 0, 5);
                    if (bl) {
                        this.setButtonIcons(new String[]{"ok.png", "dialogs/addrelation.png", "cancel.png"});
                    } else {
                        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                    }
                    this.setContent(component);
                    this.setDefaultButton(1);
                    this.setupDialog();
                    ((JButton)this.buttons.get(0)).setEnabled(!bl3);
                    ((JButton)this.buttons.get(0)).setToolTipText(string);
                    Dimension dimension = this.getSize();
                    if (dimension.width < 350) {
                        dimension.width = 350;
                        this.setSize(dimension);
                    }
                    this.showDialog();
                }
            }
            n = new PresetDialog(presetPanel, string, (ImageIcon)this.getValue("SmallIcon"), collection.isEmpty()).getValue();
        }
        if (!bl && n == 2) {
            return 3;
        }
        return n;
    }

    public Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> collection) {
        this.originalSelectionEmpty = collection.isEmpty();
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (this.types != null && (osmPrimitive instanceof Relation ? !this.types.contains((Object)TaggingPresetType.RELATION) && (!this.types.contains((Object)TaggingPresetType.CLOSEDWAY) || !((Relation)osmPrimitive).isMultipolygon()) : (osmPrimitive instanceof Node ? !this.types.contains((Object)TaggingPresetType.NODE) : osmPrimitive instanceof Way && !this.types.contains((Object)TaggingPresetType.WAY) && (!this.types.contains((Object)TaggingPresetType.CLOSEDWAY) || !((Way)osmPrimitive).isClosed())))) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (TaggingPresetItem taggingPresetItem : this.data) {
            taggingPresetItem.addCommands(arrayList);
        }
        return arrayList;
    }

    public static Command createCommand(Collection<OsmPrimitive> collection, List<Tag> list) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Tag tag : list) {
            arrayList.add(new ChangePropertyCommand(collection, tag.getKey(), tag.getValue()));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Tags", new Object[0]), arrayList);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)TaggingPresetType.RELATION);
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.main != null && Main.main.getCurrentDataSet() != null);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types) + " " + this.name;
    }

    public boolean typeMatches(Collection<TaggingPresetType> collection) {
        return collection == null || this.types == null || this.types.containsAll(collection);
    }

    public boolean matches(Collection<TaggingPresetType> collection, Map<String, String> map, boolean bl) {
        if (bl && !this.isShowable()) {
            return false;
        }
        if (!this.typeMatches(collection)) {
            return false;
        }
        boolean bl2 = false;
        for (TaggingPresetItem taggingPresetItem : this.data) {
            Boolean bl3 = taggingPresetItem.matches(map);
            if (bl3 != null && !bl3.booleanValue()) {
                return false;
            }
            if (bl3 == null) continue;
            bl2 = true;
        }
        return bl2;
    }

    public static Collection<TaggingPreset> getMatchingPresets(final Collection<TaggingPresetType> collection, final Map<String, String> map, final boolean bl) {
        return Utils.filter(TaggingPresetPreference.taggingPresets, new Predicate<TaggingPreset>(){

            @Override
            public boolean evaluate(TaggingPreset taggingPreset) {
                return taggingPreset.matches(collection, map, bl);
            }
        });
    }

    private static class PresetPanel
    extends JPanel {
        boolean hasElements = false;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }
}

