/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class CommonSettingsPanel
extends JPanel {
    private final JButton btnFadeColor;
    private final JSlider fadeAmount = new JSlider(0, 100);
    private final JosmComboBox sharpen;

    public CommonSettingsPanel() {
        super(new GridBagLayout());
        this.btnFadeColor = new JButton();
        this.btnFadeColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JColorChooser jColorChooser = new JColorChooser(CommonSettingsPanel.this.btnFadeColor.getBackground());
                int n = JOptionPane.showConfirmDialog(CommonSettingsPanel.this, jColorChooser, I18n.tr("Choose a color for {0}", I18n.tr("imagery fade", new Object[0])), 2, -1);
                if (n == 0) {
                    Color color = jColorChooser.getColor();
                    CommonSettingsPanel.this.btnFadeColor.setBackground(color);
                    CommonSettingsPanel.this.btnFadeColor.setText(ColorHelper.color2html(color));
                }
            }
        });
        this.add((Component)new JLabel(I18n.tr("Fade Color: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add((Component)this.btnFadeColor, GBC.eol().fill(2));
        this.add((Component)new JLabel(I18n.tr("Fade amount: ", new Object[0])), GBC.std());
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add((Component)this.fadeAmount, GBC.eol().fill(2));
        this.sharpen = new JosmComboBox(new String[]{I18n.tr("None", new Object[0]), I18n.tr("Soft", new Object[0]), I18n.tr("Strong", new Object[0])});
        this.add(new JLabel(I18n.tr("Sharpen (requires layer re-add): ", new Object[0])));
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add((Component)this.sharpen, GBC.eol().fill(2));
    }

    public void loadSettings() {
        Color color = ImageryLayer.PROP_FADE_COLOR.get();
        this.btnFadeColor.setBackground(color);
        this.btnFadeColor.setText(ColorHelper.color2html(color));
        this.fadeAmount.setValue(ImageryLayer.PROP_FADE_AMOUNT.get());
        this.sharpen.setSelectedIndex(Math.max(0, Math.min(2, ImageryLayer.PROP_SHARPEN_LEVEL.get())));
    }

    public boolean saveSettings() {
        ImageryLayer.PROP_FADE_AMOUNT.put(this.fadeAmount.getValue());
        ImageryLayer.PROP_FADE_COLOR.put(this.btnFadeColor.getBackground());
        ImageryLayer.PROP_SHARPEN_LEVEL.put(this.sharpen.getSelectedIndex());
        return false;
    }
}

