/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.text.View;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class AddTMSLayerPanel
extends AddImageryPanel {
    private final JosmTextField tmsZoom = new JosmTextField();
    private final JosmTextArea tmsUrl = new JosmTextArea(3, 40);
    private final KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            AddTMSLayerPanel.this.tmsUrl.setText(AddTMSLayerPanel.this.buildTMSUrl());
        }
    };

    public AddTMSLayerPanel() {
        this.add((Component)new JLabel(I18n.tr("1. Enter URL", new Object[0])), GBC.eol());
        this.add((Component)new JLabel("<html>" + Utils.joinAsHtmlUnorderedList(Arrays.asList(I18n.tr("{0} is replaced by tile zoom level, also supported:<br>offsets to the zoom level: {1} or {2}<br>reversed zoom level: {3}", "{zoom}", "{zoom+1}", "{zoom-1}", "{19-zoom}"), I18n.tr("{0} is replaced by X-coordinate of the tile", "{x}"), I18n.tr("{0} is replaced by Y-coordinate of the tile", "{y}"), I18n.tr("{0} is replaced by {1} (Yahoo style Y coordinate)", "{!y}", "2<sup>zoom\u20131</sup> \u2013 1 \u2013 Y"), I18n.tr("{0} is replaced by {1} (OSGeo Tile Map Service Specification style Y coordinate)", "{-y}", "2<sup>zoom</sup> \u2013 1 \u2013 Y"), I18n.tr("{0} is replaced by a random selection from the given comma separated list, e.g. {1}", "{switch:...}", "{switch:a,b,c}"))) + "</html>"), GBC.eol().fill());
        this.add((Component)this.rawUrl, GBC.eop().fill());
        this.rawUrl.setLineWrap(true);
        this.rawUrl.addKeyListener(this.keyAdapter);
        this.add((Component)new JLabel(I18n.tr("2. Enter maximum zoom (optional)", new Object[0])), GBC.eol());
        this.tmsZoom.addKeyListener(this.keyAdapter);
        this.add((Component)this.tmsZoom, GBC.eop().fill());
        this.add((Component)new JLabel(I18n.tr("3. Verify generated TMS URL", new Object[0])), GBC.eol());
        this.add((Component)this.tmsUrl, GBC.eop().fill());
        this.tmsUrl.setLineWrap(true);
        this.add((Component)new JLabel(I18n.tr("4. Enter name for this layer", new Object[0])), GBC.eol());
        this.add((Component)this.name, GBC.eop().fill());
        this.registerValidableComponent(this.tmsUrl);
    }

    private String buildTMSUrl() {
        StringBuilder stringBuilder = new StringBuilder("tms");
        String string = AddTMSLayerPanel.sanitize(this.tmsZoom.getText());
        if (!string.isEmpty()) {
            stringBuilder.append("[").append(string).append("]");
        }
        stringBuilder.append(":");
        stringBuilder.append(this.getImageryRawUrl());
        return stringBuilder.toString();
    }

    @Override
    public ImageryInfo getImageryInfo() {
        return new ImageryInfo(this.getImageryName(), this.getTmsUrl());
    }

    public static Dimension getPreferredSize(JLabel jLabel, boolean bl, int n) {
        View view = (View)jLabel.getClientProperty("html");
        view.setSize(bl ? (float)n : 0.0f, bl ? 0.0f : (float)n);
        return new Dimension((int)Math.ceil(view.getPreferredSpan(0)), (int)Math.ceil(view.getPreferredSpan(1)));
    }

    protected final String getTmsUrl() {
        return AddTMSLayerPanel.sanitize(this.tmsUrl.getText());
    }

    @Override
    protected boolean isImageryValid() {
        return !this.getImageryName().isEmpty() && !this.getTmsUrl().isEmpty();
    }
}

