/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.advanced.PrefEntry;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class MapListEditor
extends ExtendedDialog {
    EntryListModel entryModel;
    PrefEntry entry;
    JList entryList;
    JTable table;
    MapTableModel tableModel;
    List<List<String>> dataKeys;
    List<List<String>> dataValues;
    Integer entryIdx;

    public MapListEditor(JComponent jComponent, PrefEntry prefEntry, Preferences.MapListSetting mapListSetting) {
        super(jComponent, I18n.tr("Change list of maps setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.entry = prefEntry;
        List list = (List)mapListSetting.getValue();
        this.dataKeys = new ArrayList<List<String>>();
        this.dataValues = new ArrayList<List<String>>();
        if (list != null) {
            for (Map map : list) {
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                for (Map.Entry entry : map.entrySet()) {
                    arrayList.add(entry.getKey());
                    arrayList2.add(entry.getValue());
                }
                this.dataKeys.add(arrayList);
                this.dataValues.add(arrayList2);
            }
        }
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(jComponent, new Dimension(500, 350)));
        this.setContent(this.build(), false);
    }

    public List<Map<String, String>> getData() {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.dataKeys.size(); ++i) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (int j = 0; j < this.dataKeys.get(i).size(); ++j) {
                linkedHashMap.put(this.dataKeys.get(i).get(j), this.dataValues.get(i).get(j));
            }
            arrayList.add(linkedHashMap);
        }
        return arrayList;
    }

    protected JPanel build() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.std(0, 0).span(2).weight(1.0, 0.0).insets(0, 0, 5, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.entryModel = new EntryListModel();
        this.entryList = new JList(this.entryModel);
        this.entryList.getSelectionModel().addListSelectionListener(new EntryListener());
        JScrollPane jScrollPane = new JScrollPane(this.entryList);
        jPanel2.add((Component)jScrollPane, GBC.eol().fill());
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new NewEntryAction());
        RemoveEntryAction removeEntryAction = new RemoveEntryAction();
        this.entryList.getSelectionModel().addListSelectionListener(removeEntryAction);
        jToolBar.add(removeEntryAction);
        jPanel2.add((Component)jToolBar, GBC.eol());
        jPanel2.setPreferredSize(new Dimension(80, 0));
        jPanel.add((Component)jPanel2, GBC.std(0, 1).fill().weight(0.3, 1.0));
        this.tableModel = new MapTableModel();
        this.table = new JTable(this.tableModel);
        this.table.putClientProperty("terminateEditOnFocusLost", true);
        this.table.getTableHeader().getColumnModel().getColumn(0).setHeaderValue(I18n.tr("Key", new Object[0]));
        this.table.getTableHeader().getColumnModel().getColumn(1).setHeaderValue(I18n.tr("Value", new Object[0]));
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JosmTextField());
        defaultCellEditor.setClickCountToStart(1);
        this.table.setDefaultEditor(this.table.getColumnClass(0), defaultCellEditor);
        JScrollPane jScrollPane2 = new JScrollPane(this.table);
        jScrollPane2.setPreferredSize(new Dimension(140, 0));
        jPanel.add((Component)jScrollPane2, GBC.std(1, 1).insets(5, 0, 0, 0).fill().weight(0.7, 1.0));
        return jPanel;
    }

    class MapTableModel
    extends AbstractTableModel {
        MapTableModel() {
        }

        private List<List<String>> data() {
            if (MapListEditor.this.entryIdx == null) {
                return Collections.emptyList();
            }
            List<List<String>> list = Arrays.asList(MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx), MapListEditor.this.dataValues.get(MapListEditor.this.entryIdx));
            return list;
        }

        private int size() {
            if (MapListEditor.this.entryIdx == null) {
                return 0;
            }
            return MapListEditor.this.dataKeys.get(MapListEditor.this.entryIdx).size();
        }

        @Override
        public int getRowCount() {
            return MapListEditor.this.entryIdx == null ? 0 : this.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? I18n.tr("Key", new Object[0]) : I18n.tr("Value", new Object[0]);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.size() == n ? "" : this.data().get(n2).get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == this.size()) {
                this.data().get(0).add("");
                this.data().get(1).add("");
                this.data().get(n2).set(n, string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                this.data().get(n2).set(n, string);
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    class EntryListener
    implements ListSelectionListener {
        EntryListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TableCellEditor tableCellEditor = MapListEditor.this.table.getCellEditor();
            if (tableCellEditor != null) {
                ((DefaultCellEditor)tableCellEditor).stopCellEditing();
            }
            if (MapListEditor.this.entryList.getSelectedIndices().length != 1) {
                MapListEditor.this.entryIdx = null;
                MapListEditor.this.table.setEnabled(false);
            } else {
                MapListEditor.this.entryIdx = MapListEditor.this.entryList.getSelectedIndices()[0];
                MapListEditor.this.table.setEnabled(true);
            }
            MapListEditor.this.tableModel.fireTableDataChanged();
        }
    }

    class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveEntryAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(MapListEditor.this.entryList.getSelectedIndices().length == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = MapListEditor.this.entryList.getSelectedIndices()[0];
            MapListEditor.this.entryModel.remove(n);
        }
    }

    class NewEntryAction
    extends AbstractAction {
        public NewEntryAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("add entry", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MapListEditor.this.entryModel.add();
        }
    }

    class EntryListModel
    extends AbstractListModel {
        EntryListModel() {
        }

        @Override
        public Object getElementAt(int n) {
            return I18n.tr("Entry {0}", n + 1);
        }

        @Override
        public int getSize() {
            return MapListEditor.this.dataKeys.size();
        }

        public void add() {
            MapListEditor.this.dataKeys.add(new ArrayList());
            MapListEditor.this.dataValues.add(new ArrayList());
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }

        public void remove(int n) {
            MapListEditor.this.dataKeys.remove(n);
            MapListEditor.this.dataValues.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }
}

