/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class MultiCascade
implements StyleKeys {
    private Map<String, Cascade> layers = new HashMap<String, Cascade>();
    public Range range = new Range();

    public Cascade getOrCreateCascade(String string) {
        CheckParameterUtil.ensureParameterNotNull(string);
        Cascade cascade = this.layers.get(string);
        if (cascade == null) {
            if (this.layers.containsKey("*")) {
                cascade = this.layers.get("*").clone();
            } else {
                cascade = new Cascade();
                if (!string.equals("default") && !string.equals("*")) {
                    cascade.put("modifier", true);
                }
            }
            this.layers.put(string, cascade);
        }
        return cascade;
    }

    public Cascade getCascade(String string) {
        Cascade cascade;
        if (string == null) {
            string = "default";
        }
        if ((cascade = this.layers.get(string)) == null) {
            cascade = new Cascade();
            if (!string.equals("default") && !string.equals("*")) {
                cascade.put("modifier", true);
            }
        }
        return cascade;
    }

    public Collection<Map.Entry<String, Cascade>> getLayers() {
        return this.layers.entrySet();
    }

    public boolean hasLayer(String string) {
        return this.layers.containsKey(string);
    }
}

