/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.LinePatternElemStyle;
import org.openstreetmap.josm.gui.mappaint.LineTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.RepeatImageElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public class ElemStyles {
    private List<StyleSource> styleSources = new ArrayList<StyleSource>();
    private boolean drawMultipolygon;
    private int cacheIdx = 1;
    private boolean defaultNodes;
    private boolean defaultLines;
    private int defaultNodesIdx;
    private int defaultLinesIdx;

    public void clearCached() {
        ++this.cacheIdx;
    }

    public List<StyleSource> getStyleSources() {
        return Collections.unmodifiableList(this.styleSources);
    }

    public StyleCache.StyleList get(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        return (StyleCache.StyleList)this.getStyleCacheWithRange((OsmPrimitive)osmPrimitive, (double)d, (NavigatableComponent)navigatableComponent).a;
    }

    public Pair<StyleCache.StyleList, Range> getStyleCacheWithRange(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        Object object2;
        boolean bl;
        Pair<StyleCache.StyleList, Range> pair;
        if (osmPrimitive.mappaintStyle == null || osmPrimitive.mappaintCacheIdx != this.cacheIdx || d <= 0.0) {
            osmPrimitive.mappaintStyle = StyleCache.EMPTY_STYLECACHE;
        } else {
            pair = osmPrimitive.mappaintStyle.getWithRange(d);
            if (pair.a != null) {
                return pair;
            }
        }
        pair = this.getImpl(osmPrimitive, d, navigatableComponent);
        if (osmPrimitive instanceof Node && this.isDefaultNodes()) {
            if (((StyleCache.StyleList)pair.a).isEmpty()) {
                pair.a = TextElement.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osmPrimitive) != null ? NodeElemStyle.DEFAULT_NODE_STYLELIST_TEXT : NodeElemStyle.DEFAULT_NODE_STYLELIST;
            } else {
                bl = false;
                boolean bl2 = false;
                for (ElemStyle elemStyle : (StyleCache.StyleList)pair.a) {
                    if (elemStyle instanceof BoxTextElemStyle) {
                        bl2 = true;
                        continue;
                    }
                    if (elemStyle.isModifier) continue;
                    bl = true;
                }
                if (!bl) {
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)NodeElemStyle.SIMPLE_NODE_ELEMSTYLE);
                    if (!bl2 && TextElement.AUTO_LABEL_COMPOSITION_STRATEGY.compose(osmPrimitive) != null) {
                        pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)BoxTextElemStyle.SIMPLE_NODE_TEXT_ELEMSTYLE);
                    }
                }
            }
        } else if (osmPrimitive instanceof Way && this.isDefaultLines()) {
            bl = false;
            for (Object object2 : (StyleCache.StyleList)pair.a) {
                if (!((ElemStyle)object2).isProperLineStyle()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                AreaElemStyle areaElemStyle = Utils.find((Iterable)pair.a, AreaElemStyle.class);
                object2 = areaElemStyle == null ? LineElemStyle.UNTAGGED_WAY : LineElemStyle.createSimpleLineStyle(areaElemStyle.color, true);
                pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)object2);
            }
        }
        StyleCache styleCache = osmPrimitive.mappaintStyle != null ? osmPrimitive.mappaintStyle : StyleCache.EMPTY_STYLECACHE;
        try {
            osmPrimitive.mappaintStyle = styleCache.put((StyleCache.StyleList)pair.a, (Range)pair.b);
        }
        catch (StyleCache.RangeViolatedError rangeViolatedError) {
            object2 = new AssertionError((Object)("Range violated. object: " + osmPrimitive.getPrimitiveId() + ", current style: " + osmPrimitive.mappaintStyle + ", scale: " + d + ", new stylelist: " + pair.a + ", new range: " + pair.b));
            ((Throwable)object2).initCause(rangeViolatedError);
            throw object2;
        }
        osmPrimitive.mappaintCacheIdx = this.cacheIdx;
        return pair;
    }

    private Pair<StyleCache.StyleList, Range> getImpl(OsmPrimitive osmPrimitive, double d, NavigatableComponent navigatableComponent) {
        if (osmPrimitive instanceof Node) {
            return this.generateStyles(osmPrimitive, d, null, false);
        }
        if (osmPrimitive instanceof Way) {
            Object object;
            Object object2;
            Object object32;
            Multipolygon multipolygon;
            Object object42;
            Pair<StyleCache.StyleList, Range> pair = this.generateStyles(osmPrimitive, d, null, false);
            boolean bl = false;
            Color color = null;
            for (OsmPrimitive object5 : osmPrimitive.getReferrers()) {
                Object object6;
                object42 = (Relation)object5;
                if (!this.drawMultipolygon || !((Relation)object42).isMultipolygon() || !((AbstractPrimitive)object42).isUsable() || !(multipolygon = MultipolygonCache.getInstance().get(navigatableComponent, (Relation)object42)).getOuterWays().contains(osmPrimitive)) continue;
                boolean bl2 = false;
                if (!bl) {
                    object6 = new ArrayList(((StyleCache.StyleList)pair.a).size());
                    for (Object object32 : (StyleCache.StyleList)pair.a) {
                        if (object32 instanceof AreaElemStyle) {
                            color = ((AreaElemStyle)object32).color;
                            continue;
                        }
                        object6.add(object32);
                        if (!((ElemStyle)object32).isProperLineStyle()) continue;
                        bl2 = true;
                    }
                    pair.a = new StyleCache.StyleList((Collection<ElemStyle>)object6);
                    bl = true;
                }
                if (bl2) continue;
                object6 = this.getStyleCacheWithRange((OsmPrimitive)object42, d, navigatableComponent);
                object2 = null;
                object32 = ((StyleCache.StyleList)((Pair)object6).a).iterator();
                while (object32.hasNext()) {
                    object = object32.next();
                    if (!((ElemStyle)object).isProperLineStyle()) continue;
                    object2 = object;
                    break;
                }
                pair.b = Range.cut((Range)pair.b, (Range)((Pair)object6).b);
                if (object2 != null) {
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)object2);
                    break;
                }
                if (color != null || !this.isDefaultLines() || (object32 = Utils.find((Iterable)((Pair)object6).a, AreaElemStyle.class)) == null) continue;
                color = ((AreaElemStyle)object32).color;
            }
            if (bl) {
                if (this.isDefaultLines()) {
                    boolean bl3 = false;
                    for (Object object42 : (StyleCache.StyleList)pair.a) {
                        if (!((ElemStyle)object42).isProperLineStyle()) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3) {
                        pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)LineElemStyle.createSimpleLineStyle(color, true));
                    }
                }
                return pair;
            }
            if (!this.isDefaultLines()) {
                return pair;
            }
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                object42 = (Relation)osmPrimitive2;
                if (!this.drawMultipolygon || !((Relation)object42).isMultipolygon() || !((AbstractPrimitive)object42).isUsable() || !(multipolygon = MultipolygonCache.getInstance().get(navigatableComponent, (Relation)object42)).getInnerWays().contains(osmPrimitive)) continue;
                Iterator<Way> iterator = multipolygon.getOuterWays().iterator();
                pair = this.generateStyles(osmPrimitive, d, iterator.hasNext() ? iterator.next() : null, false);
                boolean bl3 = false;
                for (Object object32 : (StyleCache.StyleList)pair.a) {
                    if (!((ElemStyle)object32).isProperLineStyle() && !(object32 instanceof AreaElemStyle)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3 && !multipolygon.getOuterWays().isEmpty()) {
                    object2 = this.get((OsmPrimitive)object42, d, navigatableComponent);
                    object32 = null;
                    object = ((StyleCache.StyleList)object2).iterator();
                    while (object.hasNext()) {
                        ElemStyle elemStyle = (ElemStyle)object.next();
                        if (!(elemStyle instanceof AreaElemStyle)) continue;
                        object32 = ((AreaElemStyle)elemStyle).color;
                        break;
                    }
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, (ElemStyle)LineElemStyle.createSimpleLineStyle((Color)object32, true));
                }
                return pair;
            }
            return pair;
        }
        if (osmPrimitive instanceof Relation) {
            Pair<StyleCache.StyleList, Range> pair = this.generateStyles(osmPrimitive, d, null, true);
            if (this.drawMultipolygon && ((Relation)osmPrimitive).isMultipolygon() && !Utils.exists((Iterable)pair.a, AreaElemStyle.class)) {
                Multipolygon multipolygon = MultipolygonCache.getInstance().get(navigatableComponent, (Relation)osmPrimitive);
                for (Way way : multipolygon.getOuterWays()) {
                    Pair<StyleCache.StyleList, Range> pair2 = this.generateStyles(way, d, null, false);
                    pair.b = Range.cut((Range)pair.b, (Range)pair2.b);
                    ElemStyle elemStyle = Utils.find((Iterable)pair2.a, AreaElemStyle.class);
                    if (elemStyle == null) continue;
                    pair.a = new StyleCache.StyleList((StyleCache.StyleList)pair.a, elemStyle);
                    break;
                }
            }
            return pair;
        }
        return null;
    }

    public Pair<StyleCache.StyleList, Range> generateStyles(OsmPrimitive osmPrimitive, double d, OsmPrimitive osmPrimitive2, boolean bl) {
        ArrayList<ElemStyle> arrayList = new ArrayList<ElemStyle>();
        MultiCascade multiCascade = new MultiCascade();
        Environment environment = new Environment(osmPrimitive, multiCascade, null, null);
        for (StyleSource object : this.styleSources) {
            if (!object.active) continue;
            object.apply(multiCascade, osmPrimitive, d, osmPrimitive2, bl);
        }
        for (Map.Entry entry : multiCascade.getLayers()) {
            if ("*".equals(entry.getKey())) continue;
            environment.layer = (String)entry.getKey();
            Cascade cascade = (Cascade)entry.getValue();
            if (osmPrimitive instanceof Way) {
                ElemStyles.addIfNotNull(arrayList, AreaElemStyle.create(cascade));
                ElemStyles.addIfNotNull(arrayList, LinePatternElemStyle.create(environment));
                ElemStyles.addIfNotNull(arrayList, RepeatImageElemStyle.create(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createLine(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createLeftCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createRightCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineTextElemStyle.create(environment));
                continue;
            }
            if (osmPrimitive instanceof Node) {
                NodeElemStyle nodeElemStyle = NodeElemStyle.create(environment);
                if (nodeElemStyle != null) {
                    arrayList.add(nodeElemStyle);
                    ElemStyles.addIfNotNull(arrayList, BoxTextElemStyle.create(environment, nodeElemStyle.getBoxProvider()));
                    continue;
                }
                ElemStyles.addIfNotNull(arrayList, BoxTextElemStyle.create(environment, NodeElemStyle.SIMPLE_NODE_ELEMSTYLE.getBoxProvider()));
                continue;
            }
            if (!(osmPrimitive instanceof Relation)) continue;
            if (((Relation)osmPrimitive).isMultipolygon()) {
                ElemStyles.addIfNotNull(arrayList, AreaElemStyle.create(cascade));
                ElemStyles.addIfNotNull(arrayList, LinePatternElemStyle.create(environment));
                ElemStyles.addIfNotNull(arrayList, RepeatImageElemStyle.create(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createLine(environment));
                ElemStyles.addIfNotNull(arrayList, LineElemStyle.createCasing(environment));
                ElemStyles.addIfNotNull(arrayList, LineTextElemStyle.create(environment));
                continue;
            }
            if (!"restriction".equals(osmPrimitive.get("type"))) continue;
            ElemStyles.addIfNotNull(arrayList, NodeElemStyle.create(environment));
        }
        return new Pair<StyleCache.StyleList, Range>(new StyleCache.StyleList(arrayList), multiCascade.range);
    }

    private static <T> void addIfNotNull(List<T> list, T t) {
        if (t != null) {
            list.add(t);
        }
    }

    private boolean isDefaultNodes() {
        if (this.defaultNodesIdx == this.cacheIdx) {
            return this.defaultNodes;
        }
        this.defaultNodes = this.fromCanvas("default-points", true, Boolean.class);
        this.defaultNodesIdx = this.cacheIdx;
        return this.defaultNodes;
    }

    private boolean isDefaultLines() {
        if (this.defaultLinesIdx == this.cacheIdx) {
            return this.defaultLines;
        }
        this.defaultLines = this.fromCanvas("default-lines", true, Boolean.class);
        this.defaultLinesIdx = this.cacheIdx;
        return this.defaultLines;
    }

    private <T> T fromCanvas(String string, T t, Class<T> clazz) {
        MultiCascade multiCascade = new MultiCascade();
        Relation relation = new Relation();
        relation.put("#canvas", "query");
        for (StyleSource styleSource : this.styleSources) {
            if (!styleSource.active) continue;
            styleSource.apply(multiCascade, relation, 1.0, null, false);
        }
        Iterator<StyleSource> iterator = multiCascade.getCascade("default").get(string, t, clazz);
        return (T)iterator;
    }

    public boolean isDrawMultipolygon() {
        return this.drawMultipolygon;
    }

    public void setDrawMultipolygon(boolean bl) {
        this.drawMultipolygon = bl;
    }

    void clear() {
        this.styleSources.clear();
    }

    void add(StyleSource styleSource) {
        this.styleSources.add(styleSource);
    }

    void setStyleSources(Collection<StyleSource> collection) {
        this.styleSources.clear();
        this.styleSources.addAll(collection);
    }

    public static AreaElemStyle getAreaElemStyle(OsmPrimitive osmPrimitive, boolean bl) {
        if (MapPaintStyles.getStyles() == null) {
            return null;
        }
        for (ElemStyle elemStyle : (StyleCache.StyleList)MapPaintStyles.getStyles().generateStyles((OsmPrimitive)osmPrimitive, (double)1.0, null, (boolean)bl).a) {
            if (!(elemStyle instanceof AreaElemStyle)) continue;
            return (AreaElemStyle)elemStyle;
        }
        return null;
    }

    public static boolean hasAreaElemStyle(OsmPrimitive osmPrimitive, boolean bl) {
        return ElemStyles.getAreaElemStyle(osmPrimitive, bl) != null;
    }
}

