/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConvertToDataLayerAction
extends AbstractAction {
    private final GpxLayer layer;

    public ConvertToDataLayerAction(GpxLayer gpxLayer) {
        super(I18n.tr("Convert to data layer", new Object[0]), ImageProvider.get("converttoosm"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/ConvertToDataLayer"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:</html>", new Object[0])), GBC.eol());
        jPanel.add((Component)new UrlLabel("http://www.openstreetmap.org/traces", 2), GBC.eop());
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, jPanel, I18n.tr("Warning", new Object[0]), 2, 2, 0)) {
            return;
        }
        DataSet dataSet = new DataSet();
        for (GpxTrack gpxTrack : this.layer.data.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    Node node = new Node(wayPoint.getCoor());
                    String string = wayPoint.getString("time");
                    if (string != null) {
                        node.setTimestamp(DateUtils.fromString(string));
                    }
                    dataSet.addPrimitive(node);
                    arrayList.add(node);
                }
                Way way = new Way();
                way.setNodes(arrayList);
                dataSet.addPrimitive(way);
            }
        }
        Main.main.addLayer(new OsmDataLayer(dataSet, I18n.tr("Converted from: {0}", this.layer.getName()), this.layer.getAssociatedFile()));
        Main.main.removeLayer(this.layer);
    }
}

