/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class CredentialDialog
extends JDialog {
    private boolean canceled;
    protected CredentialPanel pnlCredentials;
    String saveUsernameAndPasswordCheckboxText;

    public static CredentialDialog getOsmApiCredentialDialog(String string, String string2, String string3, String string4) {
        CredentialDialog credentialDialog = new CredentialDialog(string4);
        if (Utils.equal(OsmApi.getOsmApi().getHost(), string3)) {
            credentialDialog.prepareForOsmApiCredentials(string, string2);
        } else {
            credentialDialog.prepareForOtherHostCredentials(string, string2, string3);
        }
        credentialDialog.pack();
        return credentialDialog;
    }

    public static CredentialDialog getHttpProxyCredentialDialog(String string, String string2, String string3, String string4) {
        CredentialDialog credentialDialog = new CredentialDialog(string4);
        credentialDialog.prepareForProxyCredentials(string, string2);
        credentialDialog.pack();
        return credentialDialog;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            WindowGeometry.centerInWindow(Main.parent, new Dimension(350, 300)).applySafe(this);
        }
        super.setVisible(bl);
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new SideButton(new OKAction()));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/Password"))));
        return jPanel;
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createButtonPanel(), "South");
        this.addWindowListener(new WindowEventHander());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getRootPane().getActionMap().put("escape", new CancelAction());
        this.getRootPane().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public CredentialDialog(String string) {
        this.saveUsernameAndPasswordCheckboxText = string;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        try {
            this.setAlwaysOnTop(true);
        }
        catch (SecurityException securityException) {
            Main.warn(I18n.tr("Failed to put Credential Dialog always on top. Caught security exception.", new Object[0]));
        }
        this.build();
    }

    public void prepareForOsmApiCredentials(String string, String string2) {
        this.setTitle(I18n.tr("Enter credentials for OSM API", new Object[0]));
        this.pnlCredentials = new OsmApiCredentialsPanel(this);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(string, string2);
        this.validate();
    }

    public void prepareForOtherHostCredentials(String string, String string2, String string3) {
        this.setTitle(I18n.tr("Enter credentials for host", new Object[0]));
        this.pnlCredentials = new OtherHostCredentialsPanel(this, string3);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(string, string2);
        this.validate();
    }

    public void prepareForProxyCredentials(String string, String string2) {
        this.setTitle(I18n.tr("Enter credentials for HTTP proxy", new Object[0]));
        this.pnlCredentials = new HttpProxyCredentialsPanel(this);
        this.getContentPane().add((Component)this.pnlCredentials, "Center");
        this.pnlCredentials.init(string, string2);
        this.validate();
    }

    public String getUsername() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getUserName();
    }

    public char[] getPassword() {
        if (this.pnlCredentials == null) {
            return null;
        }
        return this.pnlCredentials.getPassword();
    }

    public boolean isSaveCredentials() {
        if (this.pnlCredentials == null) {
            return false;
        }
        return this.pnlCredentials.isSaveCredentials();
    }

    class WindowEventHander
    extends WindowAdapter {
        WindowEventHander() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (CredentialDialog.this.pnlCredentials != null) {
                CredentialDialog.this.pnlCredentials.startUserInput();
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancel();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Cancel authentication", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        public void cancel() {
            CredentialDialog.this.setCanceled(true);
            CredentialDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("Authenticate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Authenticate with the supplied username and password", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CredentialDialog.this.setCanceled(false);
            CredentialDialog.this.setVisible(false);
        }
    }

    private static class TFKeyListener
    implements KeyListener {
        protected CredentialDialog owner;
        protected JTextField currentTF;
        protected JTextField nextTF;

        public TFKeyListener(CredentialDialog credentialDialog, JTextField jTextField, JTextField jTextField2) {
            this.owner = credentialDialog;
            this.currentTF = jTextField;
            this.nextTF = jTextField2;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                if (this.currentTF.getText().trim().isEmpty()) {
                    this.currentTF.selectAll();
                    return;
                }
                if (this.nextTF.getText().trim().isEmpty()) {
                    this.nextTF.requestFocusInWindow();
                    this.nextTF.selectAll();
                    return;
                }
                OKAction oKAction = this.owner.new OKAction();
                oKAction.actionPerformed(null);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private static class SelectAllOnFocusHandler
    extends FocusAdapter {
        private SelectAllOnFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() instanceof JTextField) {
                JTextField jTextField = (JTextField)focusEvent.getSource();
                jTextField.selectAll();
            }
        }
    }

    private static class HttpProxyCredentialsPanel
    extends CredentialPanel {
        @Override
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name for authenticating at your proxy server", new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password for authenticating at your proxy server", new Object[0]));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the HTTP proxy ''{0}'' failed. Please enter a valid username and a valid password.", Main.pref.get("proxy.http.host") + ":" + Main.pref.get("proxy.http.port")) + "</html>");
            this.lblWarning.setText("<html>" + I18n.tr("Warning: depending on the authentication method the proxy server uses the password may be transferred unencrypted.", new Object[0]) + "</html>");
        }

        public HttpProxyCredentialsPanel(CredentialDialog credentialDialog) {
            super(credentialDialog);
            this.build();
        }
    }

    private static class OtherHostCredentialsPanel
    extends CredentialPanel {
        String host;

        @Override
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name of your account", new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password of your account", new Object[0]));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the host ''{0}'' failed. Please enter a valid username and a valid password.", this.host) + "</html>");
            this.lblWarning.setText(I18n.tr("Warning: The password is transferred unencrypted.", new Object[0]));
        }

        public OtherHostCredentialsPanel(CredentialDialog credentialDialog, String string) {
            super(credentialDialog);
            this.host = string;
            this.build();
        }
    }

    private static class OsmApiCredentialsPanel
    extends CredentialPanel {
        @Override
        protected void build() {
            super.build();
            this.tfUserName.setToolTipText(I18n.tr("Please enter the user name of your OSM account", new Object[0]));
            this.tfPassword.setToolTipText(I18n.tr("Please enter the password of your OSM account", new Object[0]));
            this.lblHeading.setText("<html>" + I18n.tr("Authenticating at the OSM API ''{0}'' failed. Please enter a valid username and a valid password.", OsmApi.getOsmApi().getBaseUrl()) + "</html>");
            this.lblWarning.setText(I18n.tr("Warning: The password is transferred unencrypted.", new Object[0]));
        }

        public OsmApiCredentialsPanel(CredentialDialog credentialDialog) {
            super(credentialDialog);
            this.build();
        }
    }

    protected static class CredentialPanel
    extends JPanel {
        protected JTextField tfUserName;
        protected JosmPasswordField tfPassword;
        protected JCheckBox cbSaveCredentials;
        protected JMultilineLabel lblHeading;
        protected JMultilineLabel lblWarning;
        protected CredentialDialog owner;

        protected void build() {
            this.tfUserName = new JTextField(20);
            this.tfPassword = new JosmPasswordField(20);
            this.tfUserName.addFocusListener(new SelectAllOnFocusHandler());
            this.tfPassword.addFocusListener(new SelectAllOnFocusHandler());
            this.tfUserName.addKeyListener(new TFKeyListener(this.owner, this.tfUserName, this.tfPassword));
            this.tfPassword.addKeyListener(new TFKeyListener(this.owner, this.tfPassword, this.tfUserName));
            this.cbSaveCredentials = new JCheckBox(this.owner.saveUsernameAndPasswordCheckboxText);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            this.lblHeading = new JMultilineLabel("");
            this.add((Component)this.lblHeading, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 10, 10);
            this.add((Component)new JLabel(I18n.tr("Username", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.tfUserName, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Password", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.tfPassword, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.lblWarning = new JMultilineLabel("");
            this.lblWarning.setFont(this.lblWarning.getFont().deriveFont(2));
            this.add((Component)this.lblWarning, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weighty = 0.0;
            this.add((Component)this.cbSaveCredentials, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        public CredentialPanel(CredentialDialog credentialDialog) {
            this.owner = credentialDialog;
        }

        public void init(String string, String string2) {
            string = string == null ? "" : string;
            string2 = string2 == null ? "" : string2;
            this.tfUserName.setText(string);
            this.tfPassword.setText(string2);
            this.cbSaveCredentials.setSelected(!string.isEmpty() && !string2.isEmpty());
        }

        public void startUserInput() {
            this.tfUserName.requestFocusInWindow();
        }

        public String getUserName() {
            return this.tfUserName.getText();
        }

        public char[] getPassword() {
            return this.tfPassword.getPassword();
        }

        public boolean isSaveCredentials() {
            return this.cbSaveCredentials.isSelected();
        }
    }
}

