/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class VersionInfoPanel
extends JPanel
implements Observer {
    private PointInTimeType pointInTimeType;
    private HistoryBrowserModel model;
    private JMultilineLabel lblInfo;
    private UrlLabel lblUser;
    private UrlLabel lblChangeset;
    private JTextArea lblChangesetComment;

    protected void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.lblInfo = new JMultilineLabel("");
        jPanel.add((Component)this.lblInfo, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 2));
        this.lblUser = new UrlLabel("", 2);
        jPanel2.add(new JLabel(I18n.tr("User:", new Object[0])));
        jPanel2.add(this.lblUser);
        jPanel2.add(new JLabel(I18n.tr("Changeset:", new Object[0])));
        this.lblChangeset = new UrlLabel("", 2);
        jPanel2.add(this.lblChangeset);
        this.lblChangesetComment = new JTextArea();
        this.lblChangesetComment.setLineWrap(true);
        this.lblChangesetComment.setEditable(false);
        this.lblChangesetComment.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.lblChangesetComment, gridBagConstraints);
    }

    protected HistoryOsmPrimitive getPrimitive() {
        if (this.model == null || this.pointInTimeType == null) {
            return null;
        }
        return this.model.getPointInTime(this.pointInTimeType);
    }

    protected String getInfoText() {
        String string;
        HistoryOsmPrimitive historyOsmPrimitive = this.getPrimitive();
        if (historyOsmPrimitive == null) {
            return "";
        }
        if (this.model.isLatest(historyOsmPrimitive)) {
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            string = I18n.tr("<html>Version <strong>{0}</strong> currently edited in layer ''{1}''</html>", Long.toString(historyOsmPrimitive.getVersion()), osmDataLayer == null ? I18n.tr("unknown", new Object[0]) : osmDataLayer.getName());
        } else {
            String string2 = "?";
            if (historyOsmPrimitive.getTimestamp() != null) {
                string2 = DateFormat.getDateTimeInstance(3, 3).format(historyOsmPrimitive.getTimestamp());
            }
            string = I18n.tr("<html>Version <strong>{0}</strong> created on <strong>{1}</strong></html>", Long.toString(historyOsmPrimitive.getVersion()), string2);
        }
        return string;
    }

    public VersionInfoPanel() {
        this.pointInTimeType = null;
        this.model = null;
        this.build();
    }

    public VersionInfoPanel(HistoryBrowserModel historyBrowserModel, PointInTimeType pointInTimeType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)pointInTimeType, "pointInTimeType");
        CheckParameterUtil.ensureParameterNotNull(historyBrowserModel, "model");
        this.model = historyBrowserModel;
        this.pointInTimeType = pointInTimeType;
        historyBrowserModel.addObserver(this);
        this.build();
    }

    @Override
    public void update(Observable observable, Object object) {
        this.lblInfo.setText(this.getInfoText());
        if (!this.model.isLatest(this.getPrimitive())) {
            String string = AbstractInfoAction.getBaseBrowseUrl() + "/changeset/" + this.getPrimitive().getChangesetId();
            this.lblChangeset.setUrl(string);
            this.lblChangeset.setDescription(Long.toString(this.getPrimitive().getChangesetId()));
            String string2 = this.getPrimitive().getChangeset() != null ? this.getPrimitive().getChangeset().get("comment") : null;
            this.lblChangesetComment.setText(string2);
            this.lblChangesetComment.setToolTipText(I18n.tr("Changeset comment", new Object[0]));
            try {
                if (this.getPrimitive().getUser() != null && this.getPrimitive().getUser() != User.getAnonymous()) {
                    string = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(this.getPrimitive().getUser().getName(), "UTF-8").replaceAll("\\+", "%20");
                    this.lblUser.setUrl(string);
                } else {
                    this.lblUser.setUrl(null);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                this.lblUser.setUrl(null);
            }
            String string3 = "";
            if (this.getPrimitive().getUser() != null) {
                string3 = this.getPrimitive().getUser().getName();
            }
            this.lblUser.setDescription(string3);
        } else {
            String string = JosmUserIdentityManager.getInstance().getUserName();
            if (string == null) {
                this.lblUser.setDescription(I18n.tr("anonymous", new Object[0]));
                this.lblUser.setUrl(null);
            } else {
                try {
                    String string4 = AbstractInfoAction.getBaseUserUrl() + "/" + URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
                    this.lblUser.setUrl(string4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    this.lblUser.setUrl(null);
                }
                this.lblUser.setDescription(string);
            }
            this.lblChangeset.setDescription(I18n.tr("none", new Object[0]));
            this.lblChangeset.setUrl(null);
        }
    }
}

