/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.RelationMemberTableColumnModel;

public class RelationMemberListViewer
extends HistoryViewerPanel {
    @Override
    protected JTable buildReferenceTable() {
        JTable jTable = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.REFERENCE_POINT_IN_TIME), new RelationMemberTableColumnModel());
        jTable.setName("table.referencememberlisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.getModel().addTableModelListener(new MemberModelChanged(jTable));
        return jTable;
    }

    @Override
    protected JTable buildCurrentTable() {
        JTable jTable = new JTable(this.model.getRelationMemberTableModel(PointInTimeType.CURRENT_POINT_IN_TIME), new RelationMemberTableColumnModel());
        jTable.setName("table.currentmemberlisttable");
        jTable.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(jTable.getSelectionModel());
        jTable.getModel().addTableModelListener(new MemberModelChanged(jTable));
        return jTable;
    }

    public RelationMemberListViewer(HistoryBrowserModel historyBrowserModel) {
        super(historyBrowserModel);
    }

    protected class MemberModelChanged
    implements TableModelListener {
        private final JTable table;

        protected MemberModelChanged(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            Rectangle rectangle = this.table.getCellRect(((DiffTableModel)tableModelEvent.getSource()).getFirstChange(), 0, true);
            this.table.scrollRectToVisible(rectangle);
        }
    }
}

