/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HistoryBrowserDialogManager
implements MapView.LayerChangeListener {
    private static HistoryBrowserDialogManager instance;
    private Map<Long, HistoryBrowserDialog> dialogs;
    private final Predicate<PrimitiveId> unloadedHistoryPredicate = new Predicate<PrimitiveId>(){
        HistoryDataSet hds = HistoryDataSet.getInstance();

        @Override
        public boolean evaluate(PrimitiveId primitiveId) {
            History history = this.hds.getHistory(primitiveId);
            if (history == null) {
                return true;
            }
            return !primitiveId.isNew() && history.getByVersion(primitiveId.getUniqueId()) == null;
        }
    };
    private final Predicate<PrimitiveId> notNewPredicate = new Predicate<PrimitiveId>(){

        @Override
        public boolean evaluate(PrimitiveId primitiveId) {
            return !primitiveId.isNew();
        }
    };

    public static HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    protected HistoryBrowserDialogManager() {
        this.dialogs = new HashMap<Long, HistoryBrowserDialog>();
        MapView.addLayerChangeListener(this);
    }

    public boolean existsDialog(long l) {
        return this.dialogs.containsKey(l);
    }

    public void show(long l, HistoryBrowserDialog historyBrowserDialog) {
        if (this.dialogs.values().contains(historyBrowserDialog)) {
            this.show(l);
        } else {
            this.placeOnScreen(historyBrowserDialog);
            historyBrowserDialog.setVisible(true);
            this.dialogs.put(l, historyBrowserDialog);
        }
    }

    public void show(long l) {
        if (this.dialogs.keySet().contains(l)) {
            this.dialogs.get(l).toFront();
        }
    }

    protected boolean hasDialogWithCloseUpperLeftCorner(Point point) {
        for (HistoryBrowserDialog historyBrowserDialog : this.dialogs.values()) {
            Point point2 = historyBrowserDialog.getLocation();
            if (point.x < point2.x - 5 || point2.x + 5 < point.x || point.y < point2.y - 5 || point2.y + 5 < point.y) continue;
            return true;
        }
        return false;
    }

    public void placeOnScreen(HistoryBrowserDialog historyBrowserDialog) {
        WindowGeometry windowGeometry = WindowGeometry.centerOnScreen(new Dimension(800, 500));
        windowGeometry.applySafe(historyBrowserDialog);
        Point point = historyBrowserDialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(point)) {
            point.x += 20;
            point.y += 20;
        }
        historyBrowserDialog.setLocation(point);
    }

    public void hide(HistoryBrowserDialog historyBrowserDialog) {
        long l = 0L;
        for (long l2 : this.dialogs.keySet()) {
            if (this.dialogs.get(l2) != historyBrowserDialog) continue;
            l = l2;
            break;
        }
        if (l > 0L) {
            this.dialogs.remove(l);
        }
        historyBrowserDialog.setVisible(false);
        historyBrowserDialog.dispose();
    }

    public void hideAll() {
        ArrayList<HistoryBrowserDialog> arrayList = new ArrayList<HistoryBrowserDialog>();
        arrayList.addAll(this.dialogs.values());
        for (HistoryBrowserDialog historyBrowserDialog : arrayList) {
            historyBrowserDialog.unlinkAsListener();
            this.hide(historyBrowserDialog);
        }
    }

    public void show(History history) {
        if (history == null) {
            return;
        }
        if (this.existsDialog(history.getId())) {
            this.show(history.getId());
        } else {
            HistoryBrowserDialog historyBrowserDialog = new HistoryBrowserDialog(history);
            this.show(history.getId(), historyBrowserDialog);
        }
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    @Override
    public void layerAdded(Layer layer) {
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (Main.isDisplayingMapView() && Main.map.mapView.getNumLayers() == 0) {
            this.hideAll();
        }
    }

    public void showHistory(Collection<? extends PrimitiveId> collection) {
        Runnable runnable;
        final Collection<PrimitiveId> collection2 = Utils.filter(collection, this.notNewPredicate);
        if (collection2.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        Collection<PrimitiveId> collection3 = Utils.filter(collection, this.unloadedHistoryPredicate);
        if (!collection3.isEmpty()) {
            runnable = new HistoryLoadTask();
            for (PrimitiveId primitiveId : collection2) {
                ((HistoryLoadTask)runnable).add(primitiveId);
            }
            Main.worker.submit(runnable);
        }
        runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    for (PrimitiveId primitiveId : collection2) {
                        final History history = HistoryDataSet.getInstance().getHistory(primitiveId);
                        if (history == null) continue;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HistoryBrowserDialogManager.this.show(history);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    BugReportExceptionHandler.handleException(exception);
                }
            }
        };
        Main.worker.submit(runnable);
    }
}

