/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import org.openstreetmap.josm.gui.help.HelpBrowser;

public class HelpBrowserHistory
extends Observable {
    private HelpBrowser browser;
    private List<String> history;
    private int historyPos = 0;

    public HelpBrowserHistory(HelpBrowser helpBrowser) {
        this.browser = helpBrowser;
        this.history = new ArrayList<String>();
    }

    public void clear() {
        this.history.clear();
        this.historyPos = 0;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean canGoBack() {
        return this.historyPos > 0;
    }

    public boolean canGoForward() {
        return this.historyPos + 1 < this.history.size();
    }

    public void back() {
        --this.historyPos;
        if (this.historyPos < 0) {
            return;
        }
        String string = this.history.get(this.historyPos);
        this.browser.openUrl(string);
        this.setChanged();
        this.notifyObservers();
    }

    public void forward() {
        ++this.historyPos;
        if (this.historyPos >= this.history.size()) {
            return;
        }
        String string = this.history.get(this.historyPos);
        this.browser.openUrl(string);
        this.setChanged();
        this.notifyObservers();
    }

    public void setCurrentUrl(String string) {
        boolean bl = true;
        if (this.historyPos >= 0 && this.historyPos < this.history.size() && this.history.get(this.historyPos).equals(string)) {
            bl = false;
        } else if (this.historyPos != this.history.size() - 1) {
            this.history = this.historyPos == 0 && this.history.size() > 0 ? new ArrayList<String>(Collections.singletonList(this.history.get(0))) : (this.historyPos < this.history.size() - 1 && this.historyPos > 0 ? new ArrayList<String>(this.history.subList(0, this.historyPos)) : new ArrayList<String>());
        }
        if (bl) {
            this.history.add(string);
            this.historyPos = this.history.size() - 1;
        }
        this.setChanged();
        this.notifyObservers();
    }
}

