/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.BoundingBoxSelectionPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedChangesetQueryPanel
extends JPanel {
    private JCheckBox cbUserRestriction;
    private JCheckBox cbOpenAndCloseRestrictions;
    private JCheckBox cbTimeRestrictions;
    private JCheckBox cbBoundingBoxRestriction;
    private UserRestrictionPanel pnlUserRestriction;
    private OpenAndCloseStateRestrictionPanel pnlOpenAndCloseRestriction;
    private TimeRestrictionPanel pnlTimeRestriction;
    private BBoxRestrictionPanel pnlBoundingBoxRestriction;

    protected JPanel buildQueryPanel() {
        RestrictionGroupStateChangeHandler restrictionGroupStateChangeHandler = new RestrictionGroupStateChangeHandler();
        VerticallyScrollablePanel verticallyScrollablePanel = new VerticallyScrollablePanel();
        verticallyScrollablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        verticallyScrollablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.cbUserRestriction = new JCheckBox();
        verticallyScrollablePanel.add((Component)this.cbUserRestriction, gridBagConstraints);
        this.cbUserRestriction.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select changesets owned by specific users", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlUserRestriction = new UserRestrictionPanel();
        verticallyScrollablePanel.add((Component)this.pnlUserRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.cbOpenAndCloseRestrictions = new JCheckBox();
        verticallyScrollablePanel.add((Component)this.cbOpenAndCloseRestrictions, gridBagConstraints);
        this.cbOpenAndCloseRestrictions.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select changesets depending on whether they are open or closed", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlOpenAndCloseRestriction = new OpenAndCloseStateRestrictionPanel();
        verticallyScrollablePanel.add((Component)this.pnlOpenAndCloseRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.cbTimeRestrictions = new JCheckBox();
        verticallyScrollablePanel.add((Component)this.cbTimeRestrictions, gridBagConstraints);
        this.cbTimeRestrictions.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select changesets based on the date/time they have been created or closed", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlTimeRestriction = new TimeRestrictionPanel();
        verticallyScrollablePanel.add((Component)this.pnlTimeRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.cbBoundingBoxRestriction = new JCheckBox();
        verticallyScrollablePanel.add((Component)this.cbBoundingBoxRestriction, gridBagConstraints);
        this.cbBoundingBoxRestriction.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select only changesets related to a specific bounding box", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.pnlBoundingBoxRestriction = new BBoxRestrictionPanel();
        verticallyScrollablePanel.add((Component)this.pnlBoundingBoxRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        verticallyScrollablePanel.add((Component)new JPanel(), gridBagConstraints);
        return verticallyScrollablePanel;
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.buildQueryPanel());
        this.add((Component)jScrollPane, "Center");
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
    }

    public AdvancedChangesetQueryPanel() {
        this.build();
    }

    public void startUserInput() {
        this.restoreFromSettings();
        this.pnlBoundingBoxRestriction.setVisible(this.cbBoundingBoxRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.setVisible(this.cbOpenAndCloseRestrictions.isSelected());
        this.pnlTimeRestriction.setVisible(this.cbTimeRestrictions.isSelected());
        this.pnlUserRestriction.setVisible(this.cbUserRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.startUserInput();
        this.pnlUserRestriction.startUserInput();
        this.pnlTimeRestriction.startUserInput();
    }

    public void displayMessageIfInvalid() {
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                this.pnlUserRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                this.pnlTimeRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbBoundingBoxRestriction.isSelected() && !this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
            this.pnlBoundingBoxRestriction.displayMessageIfInvalid();
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        ChangesetQuery changesetQuery = new ChangesetQuery();
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlUserRestriction.fillInQuery(changesetQuery);
        }
        if (this.cbOpenAndCloseRestrictions.isSelected()) {
            this.pnlOpenAndCloseRestriction.fillInQuery(changesetQuery);
        }
        if (this.cbBoundingBoxRestriction.isSelected()) {
            if (!this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlBoundingBoxRestriction.fillInQuery(changesetQuery);
        }
        if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlTimeRestriction.fillInQuery(changesetQuery);
        }
        return changesetQuery;
    }

    public void rememberSettings() {
        Main.pref.put("changeset-query.advanced.user-restrictions", this.cbUserRestriction.isSelected());
        Main.pref.put("changeset-query.advanced.open-restrictions", this.cbOpenAndCloseRestrictions.isSelected());
        Main.pref.put("changeset-query.advanced.time-restrictions", this.cbTimeRestrictions.isSelected());
        Main.pref.put("changeset-query.advanced.bbox-restrictions", this.cbBoundingBoxRestriction.isSelected());
        this.pnlUserRestriction.rememberSettings();
        this.pnlOpenAndCloseRestriction.rememberSettings();
        this.pnlTimeRestriction.rememberSettings();
    }

    public void restoreFromSettings() {
        this.cbUserRestriction.setSelected(Main.pref.getBoolean("changeset-query.advanced.user-restrictions", false));
        this.cbOpenAndCloseRestrictions.setSelected(Main.pref.getBoolean("changeset-query.advanced.open-restrictions", false));
        this.cbTimeRestrictions.setSelected(Main.pref.getBoolean("changeset-query.advanced.time-restrictions", false));
        this.cbBoundingBoxRestriction.setSelected(Main.pref.getBoolean("changeset-query.advanced.bbox-restrictions", false));
    }

    private static class TimeValidator
    extends AbstractTextComponentValidator {
        public static TimeValidator decorate(JTextComponent jTextComponent) {
            return new TimeValidator(jTextComponent);
        }

        public TimeValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            if (this.getComponent().getText().trim().length() == 0) {
                return true;
            }
            return this.getDate() != null;
        }

        public String getStandardTooltipTextAsHtml() {
            return "<html>" + this.getStandardTooltipText() + "</html>";
        }

        public String getStandardTooltipText() {
            return I18n.tr("Please enter a valid time in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateFormat.getTimeInstance(3, Locale.getDefault()).format(new Date()), DateFormat.getTimeInstance(2, Locale.getDefault()).format(new Date()), DateFormat.getTimeInstance(1, Locale.getDefault()).format(new Date()), DateFormat.getTimeInstance(0, Locale.getDefault()).format(new Date()));
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                String string = "<html>The current value isn't a valid time.<br>" + this.getStandardTooltipText() + "</html>";
                this.feedbackInvalid(string);
                return;
            }
            String string = "<html>" + this.getStandardTooltipText() + "</html>";
            this.feedbackValid(string);
        }

        public Date getDate() {
            if (this.getComponent().getText().trim().length() == 0) {
                return null;
            }
            for (int n : new int[]{3, 2, 1, 0}) {
                try {
                    return DateFormat.getTimeInstance(n, Locale.getDefault()).parse(this.getComponent().getText());
                }
                catch (ParseException parseException) {
                }
            }
            return null;
        }
    }

    private static class DateValidator
    extends AbstractTextComponentValidator {
        public static DateValidator decorate(JTextComponent jTextComponent) {
            return new DateValidator(jTextComponent);
        }

        public DateValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            return this.getDate() != null;
        }

        public String getStandardTooltipTextAsHtml() {
            return "<html>" + this.getStandardTooltipText() + "</html>";
        }

        public String getStandardTooltipText() {
            return I18n.tr("Please enter a date in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateFormat.getDateInstance(3, Locale.getDefault()).format(new Date()), DateFormat.getDateInstance(2, Locale.getDefault()).format(new Date()), DateFormat.getDateInstance(1, Locale.getDefault()).format(new Date()), DateFormat.getDateInstance(0, Locale.getDefault()).format(new Date()));
        }

        @Override
        public void validate() {
            if (!this.isValid()) {
                String string = "<html>The current value isn't a valid date.<br>" + this.getStandardTooltipText() + "</html>";
                this.feedbackInvalid(string);
                return;
            }
            String string = "<html>" + this.getStandardTooltipText() + "</html>";
            this.feedbackValid(string);
        }

        public Date getDate() {
            for (int n : new int[]{3, 2, 1, 0}) {
                DateFormat dateFormat = DateFormat.getDateInstance(n);
                try {
                    return dateFormat.parse(this.getComponent().getText());
                }
                catch (ParseException parseException) {
                }
            }
            return null;
        }
    }

    private static class UserNameInputValidator
    extends AbstractTextComponentValidator {
        public static UserNameInputValidator decorate(JTextComponent jTextComponent) {
            return new UserNameInputValidator(jTextComponent);
        }

        public UserNameInputValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            return this.getComponent().getText().trim().length() > 0;
        }

        @Override
        public void validate() {
            String string = this.getComponent().getText();
            if (string.trim().length() == 0) {
                this.feedbackInvalid(I18n.tr("<html>The  current value is not a valid user name.<br>Please enter an non-empty user name.</html>", new Object[0]));
                return;
            }
            this.feedbackValid(I18n.tr("Please enter an non-empty user name", new Object[0]));
        }
    }

    private static class UidInputFieldValidator
    extends AbstractTextComponentValidator {
        public static UidInputFieldValidator decorate(JTextComponent jTextComponent) {
            return new UidInputFieldValidator(jTextComponent);
        }

        public UidInputFieldValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            return this.getUid() > 0;
        }

        @Override
        public void validate() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                this.feedbackInvalid("");
                return;
            }
            try {
                int n = Integer.parseInt(string);
                if (n <= 0) {
                    this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
                return;
            }
            this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
        }

        public int getUid() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                return 0;
            }
            try {
                int n = Integer.parseInt(string.trim());
                if (n > 0) {
                    return n;
                }
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
    }

    private static class BBoxRestrictionPanel
    extends BoundingBoxSelectionPanel {
        public BBoxRestrictionPanel() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        }

        public boolean isValidChangesetQuery() {
            return this.getBoundingBox() != null;
        }

        public void fillInQuery(ChangesetQuery changesetQuery) {
            if (!this.isValidChangesetQuery()) {
                throw new IllegalStateException(I18n.tr("Cannot restrict the changeset query to a specific bounding box. The input is invalid.", new Object[0]));
            }
            changesetQuery.inBbox(this.getBoundingBox());
        }

        public void displayMessageIfInvalid() {
            if (this.isValidChangesetQuery()) {
                return;
            }
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid longitude/latitude values to restrict<br>the changeset query to a specific bounding box.</html>", new Object[0]), I18n.tr("Invalid bounding box", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidBoundingBox"));
        }
    }

    private static class TimeRestrictionPanel
    extends JPanel {
        private JRadioButton rbClosedAfter;
        private JRadioButton rbClosedAfterAndCreatedBefore;
        private JosmTextField tfClosedAfterDate1;
        private DateValidator valClosedAfterDate1;
        private JosmTextField tfClosedAfterTime1;
        private TimeValidator valClosedAfterTime1;
        private JosmTextField tfClosedAfterDate2;
        private DateValidator valClosedAfterDate2;
        private JosmTextField tfClosedAfterTime2;
        private TimeValidator valClosedAfterTime2;
        private JosmTextField tfCreatedBeforeDate;
        private DateValidator valCreatedBeforeDate;
        private JosmTextField tfCreatedBeforeTime;
        private TimeValidator valCreatedBeforeTime;

        protected JPanel buildClosedAfterInputPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("Date: ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.7;
            this.tfClosedAfterDate1 = new JosmTextField();
            jPanel.add((Component)this.tfClosedAfterDate1, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate1);
            this.valClosedAfterDate1 = DateValidator.decorate(this.tfClosedAfterDate1);
            this.tfClosedAfterDate1.setToolTipText(this.valClosedAfterDate1.getStandardTooltipTextAsHtml());
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.3;
            this.tfClosedAfterTime1 = new JosmTextField();
            jPanel.add((Component)this.tfClosedAfterTime1, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime1);
            this.valClosedAfterTime1 = TimeValidator.decorate(this.tfClosedAfterTime1);
            this.tfClosedAfterTime1.setToolTipText(this.valClosedAfterTime1.getStandardTooltipTextAsHtml());
            return jPanel;
        }

        protected JPanel buildClosedAfterAndCreatedBeforeInputPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("Closed after - ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.7;
            this.tfClosedAfterDate2 = new JosmTextField();
            jPanel.add((Component)this.tfClosedAfterDate2, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterDate2);
            this.valClosedAfterDate2 = DateValidator.decorate(this.tfClosedAfterDate2);
            this.tfClosedAfterDate2.setToolTipText(this.valClosedAfterDate2.getStandardTooltipTextAsHtml());
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 0.3;
            this.tfClosedAfterTime2 = new JosmTextField();
            jPanel.add((Component)this.tfClosedAfterTime2, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfClosedAfterTime2);
            this.valClosedAfterTime2 = TimeValidator.decorate(this.tfClosedAfterTime2);
            this.tfClosedAfterTime2.setToolTipText(this.valClosedAfterTime2.getStandardTooltipTextAsHtml());
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("Created before - ", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("Date:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.7;
            this.tfCreatedBeforeDate = new JosmTextField();
            jPanel.add((Component)this.tfCreatedBeforeDate, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeDate);
            this.valCreatedBeforeDate = DateValidator.decorate(this.tfCreatedBeforeDate);
            this.tfCreatedBeforeDate.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(I18n.tr("Time:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.weightx = 0.3;
            this.tfCreatedBeforeTime = new JosmTextField();
            jPanel.add((Component)this.tfCreatedBeforeTime, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfCreatedBeforeTime);
            this.valCreatedBeforeTime = TimeValidator.decorate(this.tfCreatedBeforeTime);
            this.tfCreatedBeforeTime.setToolTipText(this.valCreatedBeforeDate.getStandardTooltipTextAsHtml());
            return jPanel;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.rbClosedAfter = new JRadioButton();
            this.add((Component)this.rbClosedAfter, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after the following date/time", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.buildClosedAfterInputPanel(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.rbClosedAfterAndCreatedBefore = new JRadioButton();
            this.add((Component)this.rbClosedAfterAndCreatedBefore, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets closed after and created before a specific date/time", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.buildClosedAfterAndCreatedBeforeInputPanel(), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbClosedAfter);
            buttonGroup.add(this.rbClosedAfterAndCreatedBefore);
            TimeRestrictionChangedHandler timeRestrictionChangedHandler = new TimeRestrictionChangedHandler();
            this.rbClosedAfter.addItemListener(timeRestrictionChangedHandler);
            this.rbClosedAfterAndCreatedBefore.addItemListener(timeRestrictionChangedHandler);
            this.rbClosedAfter.setSelected(true);
        }

        public TimeRestrictionPanel() {
            this.build();
        }

        public boolean isValidChangesetQuery() {
            if (this.rbClosedAfter.isSelected()) {
                return this.valClosedAfterDate1.isValid() && this.valClosedAfterTime1.isValid();
            }
            if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
                return this.valClosedAfterDate2.isValid() && this.valClosedAfterTime2.isValid() && this.valCreatedBeforeDate.isValid() && this.valCreatedBeforeTime.isValid();
            }
            return true;
        }

        public void startUserInput() {
            this.restoreFromSettings();
        }

        public void fillInQuery(ChangesetQuery changesetQuery) throws IllegalStateException {
            if (!this.isValidChangesetQuery()) {
                throw new IllegalStateException(I18n.tr("Cannot build changeset query with time based restrictions. Input is not valid.", new Object[0]));
            }
            if (this.rbClosedAfter.isSelected()) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                Date date = this.valClosedAfterDate1.getDate();
                Date date2 = this.valClosedAfterTime1.getDate();
                gregorianCalendar.setTimeInMillis(date.getTime() + (date2 == null ? 0L : date2.getTime()));
                changesetQuery.closedAfter(gregorianCalendar.getTime());
            } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                Date date = this.valClosedAfterDate2.getDate();
                Date date3 = this.valClosedAfterTime2.getDate();
                gregorianCalendar.setTimeInMillis(date.getTime() + (date3 == null ? 0L : date3.getTime()));
                Date date4 = gregorianCalendar.getTime();
                date = this.valCreatedBeforeDate.getDate();
                date3 = this.valCreatedBeforeTime.getDate();
                gregorianCalendar.setTimeInMillis(date.getTime() + (date3 == null ? 0L : date3.getTime()));
                Date date5 = gregorianCalendar.getTime();
                changesetQuery.closedAfterAndCreatedBefore(date4, date5);
            }
        }

        public void displayMessageIfInvalid() {
            if (this.isValidChangesetQuery()) {
                return;
            }
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>Please enter valid date/time values to restrict<br>the query to a specific time range.</html>", new Object[0]), I18n.tr("Invalid date/time values", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidDateTimeValues"));
        }

        public void rememberSettings() {
            String string = "changeset-query.advanced.time-restrictions";
            if (this.rbClosedAfter.isSelected()) {
                Main.pref.put(string + ".query-type", "closed-after");
            } else if (this.rbClosedAfterAndCreatedBefore.isSelected()) {
                Main.pref.put(string + ".query-type", "closed-after-created-before");
            }
            Main.pref.put(string + ".closed-after.date", this.tfClosedAfterDate1.getText());
            Main.pref.put(string + ".closed-after.time", this.tfClosedAfterTime1.getText());
            Main.pref.put(string + ".closed-created.closed.date", this.tfClosedAfterDate2.getText());
            Main.pref.put(string + ".closed-created.closed.time", this.tfClosedAfterTime2.getText());
            Main.pref.put(string + ".closed-created.created.date", this.tfCreatedBeforeDate.getText());
            Main.pref.put(string + ".closed-created.created.time", this.tfCreatedBeforeTime.getText());
        }

        public void restoreFromSettings() {
            String string = "changeset-query.advanced.open-restrictions";
            String string2 = Main.pref.get(string + ".query-type", "closed-after");
            this.rbClosedAfter.setSelected(string2.equals("closed-after"));
            this.rbClosedAfterAndCreatedBefore.setSelected(string2.equals("closed-after-created-before"));
            if (!this.rbClosedAfter.isSelected() && !this.rbClosedAfterAndCreatedBefore.isSelected()) {
                this.rbClosedAfter.setSelected(true);
            }
            this.tfClosedAfterDate1.setText(Main.pref.get(string + ".closed-after.date", ""));
            this.tfClosedAfterTime1.setText(Main.pref.get(string + ".closed-after.time", ""));
            this.tfClosedAfterDate2.setText(Main.pref.get(string + ".closed-created.closed.date", ""));
            this.tfClosedAfterTime2.setText(Main.pref.get(string + ".closed-created.closed.time", ""));
            this.tfCreatedBeforeDate.setText(Main.pref.get(string + ".closed-created.created.date", ""));
            this.tfCreatedBeforeTime.setText(Main.pref.get(string + ".closed-created.created.time", ""));
            if (!this.valClosedAfterDate1.isValid()) {
                this.tfClosedAfterDate1.setText("");
            }
            if (!this.valClosedAfterTime1.isValid()) {
                this.tfClosedAfterTime1.setText("");
            }
            if (!this.valClosedAfterDate2.isValid()) {
                this.tfClosedAfterDate2.setText("");
            }
            if (!this.valClosedAfterTime2.isValid()) {
                this.tfClosedAfterTime2.setText("");
            }
            if (!this.valCreatedBeforeDate.isValid()) {
                this.tfCreatedBeforeDate.setText("");
            }
            if (!this.valCreatedBeforeTime.isValid()) {
                this.tfCreatedBeforeTime.setText("");
            }
        }

        class TimeRestrictionChangedHandler
        implements ItemListener {
            TimeRestrictionChangedHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TimeRestrictionPanel.this.tfClosedAfterDate1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
                TimeRestrictionPanel.this.tfClosedAfterTime1.setEnabled(TimeRestrictionPanel.this.rbClosedAfter.isSelected());
                TimeRestrictionPanel.this.tfClosedAfterDate2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
                TimeRestrictionPanel.this.tfClosedAfterTime2.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
                TimeRestrictionPanel.this.tfCreatedBeforeDate.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
                TimeRestrictionPanel.this.tfCreatedBeforeTime.setEnabled(TimeRestrictionPanel.this.rbClosedAfterAndCreatedBefore.isSelected());
            }
        }
    }

    private static class UserRestrictionPanel
    extends JPanel {
        private ButtonGroup bgUserRestrictions;
        private JRadioButton rbRestrictToMyself;
        private JRadioButton rbRestrictToUid;
        private JRadioButton rbRestrictToUserName;
        private JosmTextField tfUid;
        private UidInputFieldValidator valUid;
        private JosmTextField tfUserName;
        private UserNameInputValidator valUserName;
        private JMultilineLabel lblRestrictedToMyself;

        protected JPanel buildUidInputPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("User ID:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.tfUid = new JosmTextField(10);
            jPanel.add((Component)this.tfUid, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfUid);
            this.valUid = UidInputFieldValidator.decorate(this.tfUid);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            return jPanel;
        }

        protected JPanel buildUserNameInputPanel() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 3);
            jPanel.add((Component)new JLabel(I18n.tr("User name:", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.tfUserName = new JosmTextField(10);
            jPanel.add((Component)this.tfUserName, gridBagConstraints);
            SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
            this.valUserName = UserNameInputValidator.decorate(this.tfUserName);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            return jPanel;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            UserRestrictionChangedHandler userRestrictionChangedHandler = new UserRestrictionChangedHandler();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.rbRestrictToMyself = new JRadioButton();
            this.add((Component)this.rbRestrictToMyself, gridBagConstraints);
            this.rbRestrictToMyself.addItemListener(userRestrictionChangedHandler);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.lblRestrictedToMyself = new JMultilineLabel(I18n.tr("Only changesets owned by myself", new Object[0]));
            this.add((Component)this.lblRestrictedToMyself, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.rbRestrictToUid = new JRadioButton();
            this.add((Component)this.rbRestrictToUid, gridBagConstraints);
            this.rbRestrictToUid.addItemListener(userRestrictionChangedHandler);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets owned by the user with the following user ID", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.buildUidInputPanel(), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.rbRestrictToUserName = new JRadioButton();
            this.add((Component)this.rbRestrictToUserName, gridBagConstraints);
            this.rbRestrictToUserName.addItemListener(userRestrictionChangedHandler);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Only changesets owned by the user with the following user name", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.buildUserNameInputPanel(), gridBagConstraints);
            this.bgUserRestrictions = new ButtonGroup();
            this.bgUserRestrictions.add(this.rbRestrictToMyself);
            this.bgUserRestrictions.add(this.rbRestrictToUid);
            this.bgUserRestrictions.add(this.rbRestrictToUserName);
        }

        public UserRestrictionPanel() {
            this.build();
        }

        public void startUserInput() {
            if (JosmUserIdentityManager.getInstance().isAnonymous()) {
                this.lblRestrictedToMyself.setText(I18n.tr("Only changesets owned by myself (disabled. JOSM is currently run by an anonymous user)", new Object[0]));
                this.rbRestrictToMyself.setEnabled(false);
                if (this.rbRestrictToMyself.isSelected()) {
                    this.rbRestrictToUid.setSelected(true);
                }
            } else {
                this.lblRestrictedToMyself.setText(I18n.tr("Only changesets owned by myself", new Object[0]));
                this.rbRestrictToMyself.setEnabled(true);
                this.rbRestrictToMyself.setSelected(true);
            }
            this.restoreFromSettings();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fillInQuery(ChangesetQuery changesetQuery) throws IllegalStateException, IllegalArgumentException {
            CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
            if (this.rbRestrictToMyself.isSelected()) {
                JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
                if (josmUserIdentityManager.isPartiallyIdentified()) {
                    changesetQuery.forUser(josmUserIdentityManager.getUserName());
                    return;
                } else {
                    if (!josmUserIdentityManager.isFullyIdentified()) throw new IllegalStateException(I18n.tr("Cannot restrict changeset query to the current user because the current user is anonymous", new Object[0]));
                    changesetQuery.forUser(josmUserIdentityManager.getUserId());
                }
                return;
            } else if (this.rbRestrictToUid.isSelected()) {
                int n = this.valUid.getUid();
                if (n <= 0) throw new IllegalStateException(I18n.tr("Current value ''{0}'' for user ID is not valid", this.tfUid.getText()));
                changesetQuery.forUser(n);
                return;
            } else {
                if (!this.rbRestrictToUserName.isSelected()) return;
                if (!this.valUserName.isValid()) {
                    throw new IllegalStateException(I18n.tr("Cannot restrict the changeset query to the user name ''{0}''", this.tfUserName.getText()));
                }
                changesetQuery.forUser(this.tfUserName.getText());
            }
        }

        public boolean isValidChangesetQuery() {
            if (this.rbRestrictToUid.isSelected()) {
                return this.valUid.isValid();
            }
            if (this.rbRestrictToUserName.isSelected()) {
                return this.valUserName.isValid();
            }
            return true;
        }

        protected void alertInvalidUid() {
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("Please enter a valid user ID", new Object[0]), I18n.tr("Invalid user ID", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidUserId"));
        }

        protected void alertInvalidUserName() {
            HelpAwareOptionPane.showOptionDialog(this, I18n.tr("Please enter a non-empty user name", new Object[0]), I18n.tr("Invalid user name", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidUserName"));
        }

        public void displayMessageIfInvalid() {
            if (this.rbRestrictToUid.isSelected()) {
                if (!this.valUid.isValid()) {
                    this.alertInvalidUid();
                }
            } else if (this.rbRestrictToUserName.isSelected() && !this.valUserName.isValid()) {
                this.alertInvalidUserName();
            }
        }

        public void rememberSettings() {
            String string = "changeset-query.advanced.user-restrictions";
            if (this.rbRestrictToMyself.isSelected()) {
                Main.pref.put(string + ".query-type", "mine");
            } else if (this.rbRestrictToUid.isSelected()) {
                Main.pref.put(string + ".query-type", "uid");
            } else if (this.rbRestrictToUserName.isSelected()) {
                Main.pref.put(string + ".query-type", "username");
            }
            Main.pref.put(string + ".uid", this.tfUid.getText());
            Main.pref.put(string + ".username", this.tfUserName.getText());
        }

        public void restoreFromSettings() {
            String string = "changeset-query.advanced.user-restrictions";
            String string2 = Main.pref.get(string + ".query-type", "mine");
            if (string2.equals("mine")) {
                JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
                if (josmUserIdentityManager.isAnonymous()) {
                    this.rbRestrictToUid.setSelected(true);
                } else {
                    this.rbRestrictToMyself.setSelected(true);
                }
            } else if (string2.equals("uid")) {
                this.rbRestrictToUid.setSelected(true);
            } else if (string2.equals("username")) {
                this.rbRestrictToUserName.setSelected(true);
            }
            this.tfUid.setText(Main.pref.get(string + ".uid", ""));
            if (!this.valUid.isValid()) {
                this.tfUid.setText("");
            }
            this.tfUserName.setText(Main.pref.get(string + ".username", ""));
        }

        class UserRestrictionChangedHandler
        implements ItemListener {
            UserRestrictionChangedHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                UserRestrictionPanel.this.tfUid.setEnabled(UserRestrictionPanel.this.rbRestrictToUid.isSelected());
                UserRestrictionPanel.this.tfUserName.setEnabled(UserRestrictionPanel.this.rbRestrictToUserName.isSelected());
                if (UserRestrictionPanel.this.rbRestrictToUid.isSelected()) {
                    UserRestrictionPanel.this.tfUid.requestFocusInWindow();
                } else if (UserRestrictionPanel.this.rbRestrictToUserName.isSelected()) {
                    UserRestrictionPanel.this.tfUserName.requestFocusInWindow();
                }
            }
        }
    }

    private static class OpenAndCloseStateRestrictionPanel
    extends JPanel {
        private JRadioButton rbOpenOnly;
        private JRadioButton rbClosedOnly;
        private JRadioButton rbBoth;

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            this.rbOpenOnly = new JRadioButton();
            this.add((Component)this.rbOpenOnly, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Query open changesets only", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            this.rbClosedOnly = new JRadioButton();
            this.add((Component)this.rbClosedOnly, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Query closed changesets only", new Object[0])), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            this.rbBoth = new JRadioButton();
            this.add((Component)this.rbBoth, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)new JMultilineLabel(I18n.tr("Query both open and closed changesets", new Object[0])), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbBoth);
            buttonGroup.add(this.rbClosedOnly);
            buttonGroup.add(this.rbOpenOnly);
        }

        public OpenAndCloseStateRestrictionPanel() {
            this.build();
        }

        public void startUserInput() {
            this.restoreFromSettings();
        }

        public void fillInQuery(ChangesetQuery changesetQuery) {
            if (this.rbBoth.isSelected()) {
                changesetQuery.beingClosed(true);
                changesetQuery.beingOpen(true);
            } else if (this.rbOpenOnly.isSelected()) {
                changesetQuery.beingOpen(true);
            } else if (this.rbClosedOnly.isSelected()) {
                changesetQuery.beingClosed(true);
            }
        }

        public void rememberSettings() {
            String string = "changeset-query.advanced.open-restrictions";
            if (this.rbBoth.isSelected()) {
                Main.pref.put(string + ".query-type", "both");
            } else if (this.rbOpenOnly.isSelected()) {
                Main.pref.put(string + ".query-type", "open");
            } else if (this.rbClosedOnly.isSelected()) {
                Main.pref.put(string + ".query-type", "closed");
            }
        }

        public void restoreFromSettings() {
            String string = "changeset-query.advanced.open-restrictions";
            String string2 = Main.pref.get(string + ".query-type", "open");
            this.rbBoth.setSelected(string2.equals("both"));
            this.rbOpenOnly.setSelected(string2.equals("open"));
            this.rbClosedOnly.setSelected(string2.equals("closed"));
        }
    }

    class RestrictionGroupStateChangeHandler
    implements ItemListener {
        RestrictionGroupStateChangeHandler() {
        }

        protected void userRestrictionStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlUserRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlUserRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbUserRestriction.isSelected());
        }

        protected void openCloseRestrictionStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions.isSelected());
        }

        protected void timeRestrictionsStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlTimeRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlTimeRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbTimeRestrictions.isSelected());
        }

        protected void boundingBoxRestrictionChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction.isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbUserRestriction) {
                this.userRestrictionStateChanged();
            } else if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions) {
                this.openCloseRestrictionStateChanged();
            } else if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbTimeRestrictions) {
                this.timeRestrictionsStateChanged();
            } else if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction) {
                this.boundingBoxRestrictionChanged();
            }
            AdvancedChangesetQueryPanel.this.validate();
            AdvancedChangesetQueryPanel.this.repaint();
        }
    }
}

