/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.OsmIdTextField;
import org.openstreetmap.josm.gui.widgets.OsmPrimitiveTypesComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmIdSelectionDialog
extends ExtendedDialog
implements WindowListener {
    protected final JPanel panel = new JPanel();
    protected final OsmPrimitiveTypesComboBox cbType = new OsmPrimitiveTypesComboBox();
    protected final OsmIdTextField tfId = new OsmIdTextField();
    protected final HistoryComboBox cbId = new HistoryComboBox();
    protected final GroupLayout layout = new GroupLayout(this.panel);

    public OsmIdSelectionDialog(Component component, String string, String[] stringArray) {
        super(component, string, stringArray);
    }

    public OsmIdSelectionDialog(Component component, String string, String[] stringArray, boolean bl) {
        super(component, string, stringArray, bl);
    }

    public OsmIdSelectionDialog(Component component, String string, String[] stringArray, boolean bl, boolean bl2) {
        super(component, string, stringArray, bl, bl2);
    }

    protected void init() {
        this.panel.setLayout(this.layout);
        this.layout.setAutoCreateGaps(true);
        this.layout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(I18n.tr("Object type:", new Object[0]));
        this.cbType.addItem(I18n.trc("osm object types", "mixed"));
        this.cbType.setToolTipText(I18n.tr("Choose the OSM object type", new Object[0]));
        JLabel jLabel2 = new JLabel(I18n.tr("Object ID:", new Object[0]));
        this.cbId.setEditor(new BasicComboBoxEditor(){

            @Override
            protected JosmTextField createEditorComponent() {
                return OsmIdSelectionDialog.this.tfId;
            }
        });
        this.cbId.setToolTipText(I18n.tr("Enter the ID of the object that should be downloaded", new Object[0]));
        this.restorePrimitivesHistory(this.cbId);
        this.tfId.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0, false));
        this.tfId.setPreferredSize(new Dimension(400, this.tfId.getPreferredSize().height));
        HtmlPanel htmlPanel = new HtmlPanel(I18n.tr("Object IDs can be separated by comma or space.<br/> Examples: <b><ul><li>1 2 5</li><li>1,2,5</li></ul><br/></b> In mixed mode, specify objects like this: <b>w123, n110, w12, r15</b><br/>", new Object[0]));
        htmlPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.cbType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OsmIdSelectionDialog.this.tfId.setType(OsmIdSelectionDialog.this.cbType.getType());
                OsmIdSelectionDialog.this.tfId.performValidation();
            }
        });
        GroupLayout.SequentialGroup sequentialGroup = this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(jLabel).addComponent(this.cbType, -2, -2, -2)).addGroup(this.layout.createParallelGroup().addComponent(jLabel2).addComponent(this.cbId, -2, -2, -2));
        GroupLayout.ParallelGroup parallelGroup = this.layout.createParallelGroup().addGroup(this.layout.createSequentialGroup().addGroup(this.layout.createParallelGroup().addComponent(jLabel).addComponent(jLabel2)).addGroup(this.layout.createParallelGroup().addComponent(this.cbType).addComponent(this.cbId)));
        for (Component component : this.getComponentsBeforeHelp()) {
            sequentialGroup.addComponent(component);
            parallelGroup.addComponent(component);
        }
        this.layout.setVerticalGroup(sequentialGroup.addComponent(htmlPanel));
        this.layout.setHorizontalGroup(parallelGroup.addComponent(htmlPanel));
    }

    protected Collection<Component> getComponentsBeforeHelp() {
        return Collections.emptySet();
    }

    public int getContinueButtonIndex() {
        return 1;
    }

    protected void restorePrimitivesHistory(HistoryComboBox historyComboBox) {
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".primitivesHistory", new LinkedList<String>()));
        Collections.reverse(linkedList);
        historyComboBox.setPossibleItems(linkedList);
    }

    protected void remindPrimitivesHistory(HistoryComboBox historyComboBox) {
        historyComboBox.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".primitivesHistory", historyComboBox.getHistory());
    }

    public final List<PrimitiveId> getOsmIds() {
        return this.tfId.getIds();
    }

    @Override
    public void setupDialog() {
        this.setContent(this.panel, false);
        this.cbType.setSelectedIndex(Main.pref.getInteger("downloadprimitive.lasttype", 0));
        this.tfId.setType(this.cbType.getType());
        if (Main.pref.getBoolean("downloadprimitive.autopaste", true)) {
            this.tryToPasteFromClipboard(this.tfId, this.cbType);
        }
        this.setDefaultButton(this.getContinueButtonIndex());
        this.addWindowListener(this);
        super.setupDialog();
    }

    protected void tryToPasteFromClipboard(OsmIdTextField osmIdTextField, OsmPrimitiveTypesComboBox osmPrimitiveTypesComboBox) {
        String string = Utils.getClipboardContent();
        if (string != null) {
            String string2;
            String[] stringArray;
            if (string.contains("node")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(0);
            }
            if (string.contains("way")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(1);
            }
            if (string.contains("relation")) {
                osmPrimitiveTypesComboBox.setSelectedIndex(2);
            }
            if ((stringArray = string.split("/")).length > 0) {
                string2 = stringArray[stringArray.length - 1];
                if (string2.isEmpty() && string2.length() > 1) {
                    string2 = stringArray[stringArray.length - 2];
                }
            } else {
                string2 = string;
            }
            if (string.length() <= Main.pref.getInteger("downloadprimitive.max-autopaste-length", 2000)) {
                osmIdTextField.tryToPasteFrom(string2);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        if (windowEvent != null && windowEvent.getComponent() == this && this.getValue() == this.getContinueButtonIndex()) {
            Main.pref.putInteger("downloadprimitive.lasttype", this.cbType.getSelectedIndex());
            if (!this.tfId.readIds()) {
                JOptionPane.showMessageDialog(this.getParent(), I18n.tr("Invalid ID list specified\nCannot continue.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            this.remindPrimitivesHistory(this.cbId);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

