/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.TagConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;

public class TagMergeModel
extends DefaultTableModel {
    public static final String PROP_NUM_UNDECIDED_TAGS = TagMergeModel.class.getName() + ".numUndecidedTags";
    private final List<TagMergeItem> tagMergeItems = new ArrayList<TagMergeItem>();
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private int numUndecidedTags = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (propertyChangeListener == null) {
                return;
            }
            if (this.listeners.contains(propertyChangeListener)) {
                return;
            }
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (propertyChangeListener == null) {
                return;
            }
            if (!this.listeners.contains(propertyChangeListener)) {
                return;
            }
            this.listeners.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNumUndecidedTagsChanged(int n, int n2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, PROP_NUM_UNDECIDED_TAGS, n, n2);
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            for (PropertyChangeListener propertyChangeListener : this.listeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected void refreshNumUndecidedTags() {
        int n = 0;
        for (TagMergeItem tagMergeItem : this.tagMergeItems) {
            if (!MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) continue;
            ++n;
        }
        int n2 = this.numUndecidedTags;
        this.numUndecidedTags = n;
        this.fireNumUndecidedTagsChanged(n2, this.numUndecidedTags);
    }

    public void populate(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.tagMergeItems.clear();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(osmPrimitive.keySet());
        hashSet.addAll(osmPrimitive2.keySet());
        for (String string : hashSet) {
            String string2 = osmPrimitive.get(string);
            String string3 = osmPrimitive2.get(string);
            if (string2 != null && string3 != null && string2.equals(string3)) continue;
            this.tagMergeItems.add(new TagMergeItem(string, osmPrimitive, osmPrimitive2));
        }
        this.fireTableDataChanged();
        this.refreshNumUndecidedTags();
    }

    public void addItem(TagMergeItem tagMergeItem) {
        if (tagMergeItem != null) {
            this.tagMergeItems.add(tagMergeItem);
            this.fireTableDataChanged();
            this.refreshNumUndecidedTags();
        }
    }

    protected void rememberDecision(int n, MergeDecisionType mergeDecisionType) {
        TagMergeItem tagMergeItem = this.tagMergeItems.get(n);
        tagMergeItem.decide(mergeDecisionType);
    }

    public void decide(int n, MergeDecisionType mergeDecisionType) {
        this.rememberDecision(n, mergeDecisionType);
        this.fireTableRowsUpdated(n, n);
        this.refreshNumUndecidedTags();
    }

    public void decide(int[] nArray, MergeDecisionType mergeDecisionType) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int n : nArray) {
            this.rememberDecision(n, mergeDecisionType);
        }
        this.fireTableDataChanged();
        this.refreshNumUndecidedTags();
    }

    @Override
    public int getRowCount() {
        return this.tagMergeItems == null ? 0 : this.tagMergeItems.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tagMergeItems.get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public TagConflictResolveCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        return new TagConflictResolveCommand(conflict, this.tagMergeItems);
    }

    public boolean isResolvedCompletely() {
        for (TagMergeItem tagMergeItem : this.tagMergeItems) {
            if (!tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            return false;
        }
        return true;
    }

    public int getNumResolvedConflicts() {
        int n = 0;
        for (TagMergeItem tagMergeItem : this.tagMergeItems) {
            if (tagMergeItem.getMergeDecision().equals((Object)MergeDecisionType.UNDECIDED)) continue;
            ++n;
        }
        return n;
    }

    public int getFirstUndecided(int n) {
        for (int i = n; i < this.tagMergeItems.size(); ++i) {
            if (this.tagMergeItems.get(i).getMergeDecision() != MergeDecisionType.UNDECIDED) continue;
            return i;
        }
        return -1;
    }
}

