/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.nodes;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.WayNodesConflictResolverCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.I18n;

public class NodeListMergeModel
extends ListMergeModel<Node> {
    public void populate(Way way, Way way2, Map<PrimitiveId, PrimitiveId> map) {
        this.initPopulate(way, way2, map);
        for (Node node : way.getNodes()) {
            this.getMyEntries().add(node);
        }
        for (Node node : way2.getNodes()) {
            this.getTheirEntries().add(node);
        }
        if (this.myAndTheirEntriesEqual()) {
            this.entries.put(ListRole.MERGED_ENTRIES, new ArrayList(this.getMyEntries()));
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    public WayNodesConflictResolverCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command.", new Object[0]));
        }
        return new WayNodesConflictResolverCommand(conflict, this.getMergedEntries());
    }

    @Override
    public boolean isEqualEntry(Node node, Node node2) {
        if (!node.isNew()) {
            return node.getId() == node2.getId();
        }
        return node == node2;
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
    }

    @Override
    protected Node cloneEntryForMergedList(Node node) {
        return (Node)this.getMyPrimitive(node);
    }
}

