/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.util;

import javax.swing.Icon;
import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NameVisitor
extends AbstractVisitor {
    public String className;
    public String classNamePlural;
    public String name = "";
    public Icon icon;

    @Override
    public void visit(Node node) {
        this.name = node.getDisplayName(DefaultNameFormatter.getInstance());
        this.icon = ImageProvider.get("data", "node");
        this.className = "node";
        this.classNamePlural = I18n.trn("node", "nodes", 2L, new Object[0]);
    }

    @Override
    public void visit(Way way) {
        this.name = way.getDisplayName(DefaultNameFormatter.getInstance());
        this.icon = ImageProvider.get("data", "way");
        this.className = "way";
        this.classNamePlural = I18n.trn("way", "ways", 2L, new Object[0]);
    }

    @Override
    public void visit(Relation relation) {
        this.name = relation.getDisplayName(DefaultNameFormatter.getInstance());
        this.icon = ImageProvider.get("data", "relation");
        this.className = "relation";
        this.classNamePlural = I18n.trn("relation", "relations", 2L, new Object[0]);
    }

    public JLabel toLabel() {
        return new JLabel(this.name, this.icon, 0);
    }
}

