/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Pair;

public class OverlappingWays
extends Test {
    private MultiMap<Pair<Node, Node>, WaySegment> nodePairs;
    protected static final int OVERLAPPING_HIGHWAY = 101;
    protected static final int OVERLAPPING_RAILWAY = 102;
    protected static final int OVERLAPPING_WAY = 103;
    protected static final int OVERLAPPING_HIGHWAY_AREA = 111;
    protected static final int OVERLAPPING_RAILWAY_AREA = 112;
    protected static final int OVERLAPPING_WAY_AREA = 113;
    protected static final int OVERLAPPING_AREA = 120;

    public OverlappingWays() {
        super(I18n.tr("Overlapping ways", new Object[0]), I18n.tr("This test checks that a connection between two nodes is not used by more than one way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.nodePairs = new MultiMap(1000);
    }

    private boolean parentMultipolygonConcernsArea(OsmPrimitive osmPrimitive) {
        for (Relation relation : OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class)) {
            if (!relation.concernsArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void endTest() {
        HashMap hashMap = new HashMap(500);
        for (Set<WaySegment> set : this.nodePairs.values()) {
            int n = set.size();
            if (n <= 1) continue;
            ArrayList<Way> arrayList = new ArrayList<Way>();
            ArrayList<Way> arrayList2 = new ArrayList<Way>();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (WaySegment waySegment : set) {
                if (waySegment.way.get("highway") != null) {
                    ++n2;
                } else if (waySegment.way.get("railway") != null) {
                    ++n3;
                }
                Boolean bl = OsmUtils.getOsmBoolean(waySegment.way.get("area"));
                if (bl != null && bl.booleanValue()) {
                    ++n4;
                }
                if (waySegment.way.concernsArea() || this.parentMultipolygonConcernsArea(waySegment.way)) {
                    ++n4;
                    --n;
                }
                arrayList.add(waySegment.way);
                arrayList2.add(waySegment.way);
            }
            Collection collection = (Collection)hashMap.get(arrayList2);
            if (collection == null) {
                int n5;
                Object object;
                if (n4 > 0) {
                    if (n == 0 || set.size() == n4) {
                        object = I18n.tr("Areas share segment", new Object[0]);
                        n5 = 120;
                    } else if (n2 == n) {
                        object = I18n.tr("Highways share segment with area", new Object[0]);
                        n5 = 111;
                    } else if (n3 == n) {
                        object = I18n.tr("Railways share segment with area", new Object[0]);
                        n5 = 112;
                    } else {
                        object = I18n.tr("Ways share segment with area", new Object[0]);
                        n5 = 113;
                    }
                } else if (n2 == n) {
                    object = I18n.tr("Overlapping highways", new Object[0]);
                    n5 = 101;
                } else if (n3 == n) {
                    object = I18n.tr("Overlapping railways", new Object[0]);
                    n5 = 102;
                } else {
                    object = I18n.tr("Overlapping ways", new Object[0]);
                    n5 = 103;
                }
                this.errors.add(new TestError(this, n5 < 111 ? Severity.WARNING : Severity.OTHER, (String)object, n5, arrayList, set));
                hashMap.put(arrayList2, set);
                continue;
            }
            for (WaySegment waySegment : set) {
                collection.add(waySegment);
            }
        }
        super.endTest();
        this.nodePairs = null;
    }

    @Override
    public void visit(Way way) {
        Node node = null;
        int n = -2;
        for (Node node2 : way.getNodes()) {
            ++n;
            if (node == null) {
                node = node2;
                continue;
            }
            this.nodePairs.put(Pair.sort(new Pair<Node, Node>(node, node2)), new WaySegment(way, n));
            node = node2;
        }
    }
}

