/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class OverlappingAreas
extends Test {
    protected static final int OVERLAPPING_AREAS = 2201;
    protected final QuadBuckets<Way> index = new QuadBuckets();

    public OverlappingAreas() {
        super(I18n.tr("Overlapping Areas", new Object[0]), I18n.tr("This test checks if areas overlap.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable() && way.isArea() && ElemStyles.hasAreaElemStyle(way, false)) {
            this.index.add(way);
        }
    }

    @Override
    public void endTest() {
        for (final Way way : this.index) {
            Collection<Way> collection = Utils.filter(this.index.search(way.getBBox()), new Predicate<Way>(){

                @Override
                public boolean evaluate(Way way2) {
                    if (way.equals(way2)) {
                        return false;
                    }
                    return Geometry.polygonIntersection(way.getNodes(), way2.getNodes()) == Geometry.PolygonIntersection.CROSSING;
                }
            });
            if (collection.isEmpty()) continue;
            ArrayList<Way> arrayList = new ArrayList<Way>();
            ArrayList<Way> arrayList2 = new ArrayList<Way>();
            String string = way.get("natural");
            String string2 = way.get("landuse");
            boolean bl = "water".equals(string) || "wetland".equals(string) || "coastline".equals(string) || "reservoir".equals(string2);
            boolean bl2 = false;
            for (Way way2 : collection) {
                boolean bl3;
                String string3 = way2.get("natural");
                String string4 = way2.get("landuse");
                boolean bl4 = bl3 = "water".equals(string3) || "wetland".equals(string3) || "coastline".equals(string3) || "reservoir".equals(string4);
                if (!bl2) {
                    bl2 = bl3;
                }
                if (bl && bl3) {
                    arrayList.add(way2);
                    continue;
                }
                arrayList2.add(way2);
            }
            if (!arrayList.isEmpty()) {
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Overlapping Water Areas", new Object[0]), 2201, Collections.singletonList(way), arrayList));
            }
            if (arrayList2.isEmpty()) continue;
            this.errors.add(new TestError(this, Severity.OTHER, I18n.tr("Overlapping Areas", new Object[0]), 2201, Collections.singletonList(way), arrayList2));
        }
        this.index.clear();
        super.endTest();
    }
}

