/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.FixableTestError;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.I18n;

public class OpeningHourTest
extends Test {
    public static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");

    public OpeningHourTest() {
        super(I18n.tr("Opening hours syntax", new Object[0]), I18n.tr("This test checks the correct usage of the opening hours syntax.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        if (ENGINE != null) {
            ENGINE.eval(new InputStreamReader((InputStream)new MirroredInputStream("resource://data/validator/opening_hours.js"), "UTF-8"));
            ENGINE.eval("var nominatimJSON = {address: {state: 'Bayern', country_code: 'de'}};");
            ENGINE.eval("var oh = function (value, mode) { try {    var r= new opening_hours(value, nominatimJSON, mode);    r.getErrors = function() {return [];};    return r;  } catch(err) {    return {      getWarnings: function() {return [];},      getErrors: function() {return [err.toString()]}    };  }};");
        } else {
            Main.warn("Unable to initialize OpeningHourTest because no JavaScript engine has been found");
        }
    }

    protected Object parse(String string, CheckMode checkMode) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)ENGINE)).invokeFunction("oh", string, checkMode.code);
    }

    protected List<Object> getList(Object object) throws ScriptException, NoSuchMethodException {
        if (object == null || "".equals(object)) {
            return Arrays.asList(new Object[0]);
        }
        if (object instanceof String) {
            String[] stringArray = ((String)object).split("\\\\n");
            return Arrays.asList(stringArray);
        }
        if (object instanceof List) {
            return (List)object;
        }
        return this.getList(((Invocable)((Object)ENGINE)).invokeMethod(object, "join", "\\n"));
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String string, String string2, CheckMode checkMode) {
        if (ENGINE == null || string2 == null || string2.trim().isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Object object = this.parse(string2, checkMode);
            ArrayList<OpeningHoursTestError> arrayList = new ArrayList<OpeningHoursTestError>();
            String string3 = null;
            try {
                string3 = (String)((Invocable)((Object)ENGINE)).invokeMethod(object, "prettifyValue", new Object[0]);
            }
            catch (Exception exception) {
                Main.debug(exception.getMessage());
            }
            for (Object object2 : this.getList(((Invocable)((Object)ENGINE)).invokeMethod(object, "getErrors", new Object[0]))) {
                arrayList.add(new OpeningHoursTestError(string + " - " + object2.toString().trim(), Severity.ERROR, string3));
            }
            for (Object object2 : this.getList(((Invocable)((Object)ENGINE)).invokeMethod(object, "getWarnings", new Object[0]))) {
                arrayList.add(new OpeningHoursTestError(object2.toString().trim(), Severity.WARNING, string3));
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String string, String string2) {
        return this.checkOpeningHourSyntax(string, string2, CheckMode.TIME_RANGE);
    }

    protected void check(OsmPrimitive osmPrimitive, String string, CheckMode checkMode) {
        for (OpeningHoursTestError openingHoursTestError : this.checkOpeningHourSyntax(string, osmPrimitive.get(string), checkMode)) {
            this.errors.add(openingHoursTestError.getTestError(osmPrimitive, string));
        }
    }

    protected void check(OsmPrimitive osmPrimitive) {
        this.check(osmPrimitive, "opening_hours", CheckMode.TIME_RANGE);
        this.check(osmPrimitive, "collection_times", CheckMode.BOTH);
        this.check(osmPrimitive, "service_times", CheckMode.BOTH);
    }

    @Override
    public void visit(Node node) {
        this.check(node);
    }

    @Override
    public void visit(Relation relation) {
        this.check(relation);
    }

    @Override
    public void visit(Way way) {
        this.check(way);
    }

    public class OpeningHoursTestError {
        final Severity severity;
        final String message;
        final String prettifiedValue;

        public OpeningHoursTestError(String string, Severity severity, String string2) {
            this.message = string;
            this.severity = severity;
            this.prettifiedValue = string2;
        }

        public OpeningHoursTestError(String string, Severity severity) {
            this(string, severity, null);
        }

        public TestError getTestError(OsmPrimitive osmPrimitive, String string) {
            if (this.prettifiedValue == null) {
                return new TestError((Test)OpeningHourTest.this, this.severity, this.message, 2901, osmPrimitive);
            }
            return new FixableTestError((Test)OpeningHourTest.this, this.severity, this.message, 2901, osmPrimitive, (Command)new ChangePropertyCommand(osmPrimitive, string, this.prettifiedValue));
        }

        public String getMessage() {
            return this.message;
        }

        public String getPrettifiedValue() {
            return this.prettifiedValue;
        }

        public Severity getSeverity() {
            return this.severity;
        }
    }

    static enum CheckMode {
        TIME_RANGE(0),
        POINTS_IN_TIME(1),
        BOTH(2);

        final int code;

        private CheckMode(int n2) {
            this.code = n2;
        }
    }
}

