/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.proj.Proj;

public abstract class AbstractProjection
implements Projection {
    protected Ellipsoid ellps;
    protected Datum datum;
    protected Proj proj;
    protected double x_0 = 0.0;
    protected double y_0 = 0.0;
    protected double lon_0 = 0.0;
    protected double k_0 = 1.0;

    public final Ellipsoid getEllipsoid() {
        return this.ellps;
    }

    public final Datum getDatum() {
        return this.datum;
    }

    public final Proj getProj() {
        return this.proj;
    }

    public final double getFalseEasting() {
        return this.x_0;
    }

    public final double getFalseNorthing() {
        return this.y_0;
    }

    public final double getCentralMeridian() {
        return this.lon_0;
    }

    public final double getScaleFactor() {
        return this.k_0;
    }

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        latLon = this.datum.fromWGS84(latLon);
        double[] dArray = this.proj.project(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon() - this.lon_0));
        return new EastNorth(this.ellps.a * this.k_0 * dArray[0] + this.x_0, this.ellps.a * this.k_0 * dArray[1] + this.y_0);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        double[] dArray = this.proj.invproject((eastNorth.east() - this.x_0) / this.ellps.a / this.k_0, (eastNorth.north() - this.y_0) / this.ellps.a / this.k_0);
        LatLon latLon = new LatLon(Math.toDegrees(dArray[0]), Math.toDegrees(dArray[1]) + this.lon_0);
        return this.datum.toWGS84(latLon);
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    public abstract Integer getEpsgCode();

    @Override
    public String toCode() {
        return "EPSG:" + this.getEpsgCode();
    }

    protected static final double convertMinuteSecond(double d, double d2) {
        return d / 60.0 + d2 / 3600.0;
    }

    protected static final double convertDegreeMinuteSecond(double d, double d2, double d3) {
        return d + d2 / 60.0 + d3 / 3600.0;
    }
}

