/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint.relations;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;

public class Multipolygon {
    public static final String PREF_KEY_OUTER_ROLES = "mappaint.multipolygon.outer.roles";
    public static final String PREF_KEY_OUTER_ROLE_PREFIXES = "mappaint.multipolygon.outer.role-prefixes";
    public static final String PREF_KEY_INNER_ROLES = "mappaint.multipolygon.inner.roles";
    public static final String PREF_KEY_INNER_ROLE_PREFIXES = "mappaint.multipolygon.inner.role-prefixes";
    private static MultipolygonRoleMatcher roleMatcher;
    private final List<Way> innerWays = new ArrayList<Way>();
    private final List<Way> outerWays = new ArrayList<Way>();
    private final List<PolyData> innerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> outerPolygons = new ArrayList<PolyData>();
    private final List<PolyData> combinedPolygons = new ArrayList<PolyData>();
    private boolean incomplete;

    private static MultipolygonRoleMatcher getMultipolygonRoleMatcher() {
        if (roleMatcher == null) {
            roleMatcher = new MultipolygonRoleMatcher();
            if (Main.pref != null) {
                Multipolygon.roleMatcher.initFromPreferences();
                Main.pref.addPreferenceChangeListener(roleMatcher);
            }
        }
        return roleMatcher;
    }

    public Multipolygon(Relation relation) {
        this.load(relation);
    }

    private void load(Relation relation) {
        MultipolygonRoleMatcher multipolygonRoleMatcher = Multipolygon.getMultipolygonRoleMatcher();
        for (RelationMember relationMember : relation.getMembers()) {
            Way way;
            if (relationMember.getMember().isIncomplete()) {
                this.incomplete = true;
                continue;
            }
            if (!relationMember.getMember().isDrawable() || !relationMember.isWay() || (way = relationMember.getWay()).getNodesCount() < 2) continue;
            if (multipolygonRoleMatcher.isInnerRole(relationMember.getRole())) {
                this.innerWays.add(way);
                continue;
            }
            if (multipolygonRoleMatcher.isOuterRole(relationMember.getRole())) {
                this.outerWays.add(way);
                continue;
            }
            if (relationMember.hasRole()) continue;
            this.outerWays.add(way);
        }
        this.createPolygons(this.innerWays, this.innerPolygons);
        this.createPolygons(this.outerWays, this.outerPolygons);
        if (!this.outerPolygons.isEmpty()) {
            this.addInnerToOuters();
        }
    }

    public final boolean isIncomplete() {
        return this.incomplete;
    }

    private void createPolygons(List<Way> list, List<PolyData> list2) {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        for (Way object : list) {
            if (object.isClosed()) {
                list2.add(new PolyData(object));
                continue;
            }
            arrayList.add(object);
        }
        for (JoinedWay joinedWay : Multipolygon.joinWays(arrayList)) {
            list2.add(new PolyData(joinedWay));
        }
    }

    public static Collection<JoinedWay> joinWays(Collection<Way> collection) {
        ArrayList<JoinedWay> arrayList = new ArrayList<JoinedWay>();
        Way[] wayArray = collection.toArray(new Way[collection.size()]);
        int n = collection.size();
        while (n > 0) {
            Way way = null;
            boolean bl = false;
            List<Node> list = null;
            HashSet<Long> hashSet = new HashSet<Long>();
            boolean bl2 = true;
            while (bl2 && n > 0) {
                bl2 = false;
                for (int i = 0; i < wayArray.length && n != 0; ++i) {
                    int n2;
                    if (wayArray[i] == null) continue;
                    Way way2 = wayArray[i];
                    if (way == null) {
                        way = way2;
                        bl = way.isSelected();
                        wayArray[i] = null;
                        --n;
                        continue;
                    }
                    int n3 = 0;
                    int n4 = way2.getNodesCount() - 1;
                    if (list == null) {
                        n2 = way.getNodesCount() - 1;
                        if (way.getNode(n2) == way2.getNode(0)) {
                            n3 = 21;
                        } else if (way.getNode(n2) == way2.getNode(n4)) {
                            n3 = 22;
                        } else if (way.getNode(0) == way2.getNode(0)) {
                            n3 = 11;
                        } else if (way.getNode(0) == way2.getNode(n4)) {
                            n3 = 12;
                        }
                    } else {
                        n2 = list.size() - 1;
                        if (list.get(n2) == way2.getNode(0)) {
                            n3 = 21;
                        } else if (list.get(0) == way2.getNode(n4)) {
                            n3 = 12;
                        } else if (list.get(0) == way2.getNode(0)) {
                            n3 = 11;
                        } else if (list.get(n2) == way2.getNode(n4)) {
                            n3 = 22;
                        }
                    }
                    if (n3 == 0) continue;
                    wayArray[i] = null;
                    bl2 = true;
                    if (way2.isSelected()) {
                        bl = true;
                    }
                    --n;
                    if (list == null) {
                        list = way.getNodes();
                        hashSet.add(way.getUniqueId());
                    }
                    list.remove(n3 == 21 || n3 == 22 ? n2 : 0);
                    if (n3 == 21) {
                        list.addAll(way2.getNodes());
                    } else if (n3 == 12) {
                        list.addAll(0, way2.getNodes());
                    } else if (n3 == 22) {
                        for (Node node : way2.getNodes()) {
                            list.add(n2, node);
                        }
                    } else {
                        for (Node node : way2.getNodes()) {
                            list.add(0, node);
                        }
                    }
                    hashSet.add(way2.getUniqueId());
                }
            }
            if (list == null) {
                list = way.getNodes();
                hashSet.add(way.getUniqueId());
            }
            arrayList.add(new JoinedWay(list, hashSet, bl));
        }
        return arrayList;
    }

    public PolyData findOuterPolygon(PolyData polyData, List<PolyData> list) {
        Rectangle2D rectangle2D = polyData.getBounds();
        PolyData polyData2 = null;
        PolyData object = null;
        int n = 0;
        int n2 = 0;
        for (PolyData object2 : list) {
            if (object2.getBounds().contains(rectangle2D)) {
                polyData2 = object2;
                ++n;
                continue;
            }
            if (!object2.getBounds().intersects(rectangle2D)) continue;
            object = object2;
            ++n2;
        }
        if (n == 1) {
            return polyData2;
        }
        if (n2 == 1) {
            return object;
        }
        Object object3 = null;
        for (PolyData polyData3 : list) {
            PolyData.Intersection intersection = polyData3.contains(polyData.poly);
            if (intersection == PolyData.Intersection.OUTSIDE || object3 != null && ((PolyData)object3).contains(polyData3.poly) == PolyData.Intersection.INSIDE) continue;
            object3 = polyData3;
        }
        return object3;
    }

    private void addInnerToOuters() {
        if (this.innerPolygons.isEmpty()) {
            this.combinedPolygons.addAll(this.outerPolygons);
        } else if (this.outerPolygons.size() == 1) {
            PolyData polyData = new PolyData(this.outerPolygons.get(0));
            for (PolyData polyData2 : this.innerPolygons) {
                polyData.addInner(polyData2);
            }
            this.combinedPolygons.add(polyData);
        } else {
            for (PolyData polyData : this.outerPolygons) {
                this.combinedPolygons.add(new PolyData(polyData));
            }
            for (PolyData polyData : this.innerPolygons) {
                PolyData polyData3 = this.findOuterPolygon(polyData, this.combinedPolygons);
                if (polyData3 == null) {
                    polyData3 = this.outerPolygons.get(0);
                }
                polyData3.addInner(polyData);
            }
        }
        this.innerPolygons.clear();
        this.outerPolygons.clear();
    }

    public List<Way> getOuterWays() {
        return this.outerWays;
    }

    public List<Way> getInnerWays() {
        return this.innerWays;
    }

    public List<PolyData> getCombinedPolygons() {
        return this.combinedPolygons;
    }

    public static class PolyData {
        private final Path2D.Double poly;
        public boolean selected;
        private Rectangle2D bounds;
        private final Collection<Long> wayIds;
        private final List<Node> nodes;
        private final List<PolyData> inners;

        public PolyData(Way way) {
            this(way.getNodes(), way.isSelected(), Collections.singleton(way.getUniqueId()));
        }

        public PolyData(JoinedWay joinedWay) {
            this(joinedWay.getNodes(), joinedWay.isSelected(), joinedWay.getWayIds());
        }

        private PolyData(List<Node> list, boolean bl, Collection<Long> collection) {
            this.wayIds = Collections.unmodifiableCollection(collection);
            this.nodes = new ArrayList<Node>(list);
            this.selected = bl;
            this.inners = new ArrayList<PolyData>();
            this.poly = new Path2D.Double();
            this.poly.setWindingRule(0);
            this.buildPoly();
        }

        private void buildPoly() {
            boolean bl = true;
            for (Node object : this.nodes) {
                EastNorth eastNorth = object.getEastNorth();
                if (eastNorth == null) continue;
                if (bl) {
                    this.poly.moveTo(eastNorth.getX(), eastNorth.getY());
                    bl = false;
                    continue;
                }
                this.poly.lineTo(eastNorth.getX(), eastNorth.getY());
            }
            if (!bl) {
                this.poly.closePath();
            }
            for (PolyData polyData : this.inners) {
                this.appendInner(polyData.poly);
            }
        }

        public PolyData(PolyData polyData) {
            this.selected = polyData.selected;
            this.poly = (Path2D.Double)polyData.poly.clone();
            this.wayIds = Collections.unmodifiableCollection(polyData.wayIds);
            this.nodes = new ArrayList<Node>(polyData.nodes);
            this.inners = new ArrayList<PolyData>(polyData.inners);
        }

        public Intersection contains(Path2D.Double double_) {
            int n = 0;
            int n2 = 0;
            double[] dArray = new double[6];
            PathIterator pathIterator = double_.getPathIterator(null);
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(dArray)) {
                    case 0: 
                    case 1: {
                        if (this.poly.contains(dArray[0], dArray[1])) {
                            ++n;
                        }
                        ++n2;
                    }
                }
                pathIterator.next();
            }
            if (n == n2) {
                return Intersection.INSIDE;
            }
            if (n == 0) {
                return Intersection.OUTSIDE;
            }
            return Intersection.CROSSING;
        }

        public void addInner(PolyData polyData) {
            this.inners.add(polyData);
            this.appendInner(polyData.poly);
        }

        private void appendInner(Path2D.Double double_) {
            this.poly.append(double_.getPathIterator(null), false);
        }

        public Path2D.Double get() {
            return this.poly;
        }

        public Rectangle2D getBounds() {
            if (this.bounds == null) {
                this.bounds = this.poly.getBounds2D();
            }
            return this.bounds;
        }

        public Collection<Long> getWayIds() {
            return this.wayIds;
        }

        private void resetNodes(DataSet dataSet) {
            if (!this.nodes.isEmpty()) {
                DataSet dataSet2 = dataSet;
                Object object = this.nodes.iterator();
                while (object.hasNext() && dataSet2 == null) {
                    dataSet2 = object.next().getDataSet();
                }
                this.nodes.clear();
                if (dataSet2 == null) {
                    Main.warn("DataSet not found while resetting nodes in Multipolygon. This should not happen, you may report it to JOSM developers.");
                } else if (this.wayIds.size() == 1) {
                    object = (Way)dataSet2.getPrimitiveById(this.wayIds.iterator().next(), OsmPrimitiveType.WAY);
                    this.nodes.addAll(((Way)object).getNodes());
                } else if (!this.wayIds.isEmpty()) {
                    object = new ArrayList();
                    for (Long l : this.wayIds) {
                        Way way = (Way)dataSet2.getPrimitiveById(l, OsmPrimitiveType.WAY);
                        if (way == null || way.getNodesCount() <= 0) continue;
                        object.add(way);
                    }
                    if (!object.isEmpty()) {
                        this.nodes.addAll(Multipolygon.joinWays((Collection<Way>)object).iterator().next().getNodes());
                    }
                }
                this.resetPoly();
            }
        }

        private void resetPoly() {
            this.poly.reset();
            this.buildPoly();
            this.bounds = null;
        }

        public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
            Node node = nodeMovedEvent.getNode();
            boolean bl = false;
            for (PolyData polyData : this.inners) {
                if (!polyData.nodes.contains(node)) continue;
                polyData.resetPoly();
                bl = true;
            }
            if (this.nodes.contains(node) || bl) {
                this.resetPoly();
            }
        }

        public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
            Long l = wayNodesChangedEvent.getChangedWay().getUniqueId();
            boolean bl = false;
            for (PolyData polyData : this.inners) {
                if (!polyData.wayIds.contains(l)) continue;
                polyData.resetNodes(wayNodesChangedEvent.getDataset());
                bl = true;
            }
            if (this.wayIds.contains(l) || bl) {
                this.resetNodes(wayNodesChangedEvent.getDataset());
            }
        }

        public static enum Intersection {
            INSIDE,
            OUTSIDE,
            CROSSING;

        }
    }

    public static class JoinedWay {
        private final List<Node> nodes;
        private final Collection<Long> wayIds;
        private final boolean selected;

        public JoinedWay(List<Node> list, Collection<Long> collection, boolean bl) {
            this.nodes = list;
            this.wayIds = collection;
            this.selected = bl;
        }

        public List<Node> getNodes() {
            return this.nodes;
        }

        public Collection<Long> getWayIds() {
            return this.wayIds;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean isClosed() {
            return this.nodes.isEmpty() || this.nodes.get(this.nodes.size() - 1).equals(this.nodes.get(0));
        }
    }

    private static class MultipolygonRoleMatcher
    implements Preferences.PreferenceChangedListener {
        private final List<String> outerExactRoles = new ArrayList<String>();
        private final List<String> outerRolePrefixes = new ArrayList<String>();
        private final List<String> innerExactRoles = new ArrayList<String>();
        private final List<String> innerRolePrefixes = new ArrayList<String>();

        private MultipolygonRoleMatcher() {
        }

        private void initDefaults() {
            this.outerExactRoles.clear();
            this.outerRolePrefixes.clear();
            this.innerExactRoles.clear();
            this.innerRolePrefixes.clear();
            this.outerExactRoles.add("outer");
            this.innerExactRoles.add("inner");
        }

        private void setNormalized(Collection<String> collection, List<String> list) {
            list.clear();
            for (String string : collection) {
                if (string == null || list.contains(string = string.trim())) continue;
                list.add(string);
            }
        }

        private void initFromPreferences() {
            this.initDefaults();
            if (Main.pref == null) {
                return;
            }
            Collection<String> collection = Main.pref.getCollection(Multipolygon.PREF_KEY_OUTER_ROLES);
            if (collection != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.outerExactRoles);
            }
            if ((collection = Main.pref.getCollection(Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES)) != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.outerRolePrefixes);
            }
            if ((collection = Main.pref.getCollection(Multipolygon.PREF_KEY_INNER_ROLES)) != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.innerExactRoles);
            }
            if ((collection = Main.pref.getCollection(Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES)) != null && !collection.isEmpty()) {
                this.setNormalized(collection, this.innerRolePrefixes);
            }
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (Multipolygon.PREF_KEY_INNER_ROLE_PREFIXES.equals(preferenceChangeEvent.getKey()) || Multipolygon.PREF_KEY_INNER_ROLES.equals(preferenceChangeEvent.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLE_PREFIXES.equals(preferenceChangeEvent.getKey()) || Multipolygon.PREF_KEY_OUTER_ROLES.equals(preferenceChangeEvent.getKey())) {
                this.initFromPreferences();
            }
        }

        public boolean isOuterRole(String string) {
            if (string == null) {
                return false;
            }
            for (String string2 : this.outerExactRoles) {
                if (!string.equals(string2)) continue;
                return true;
            }
            for (String string2 : this.outerRolePrefixes) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
            return false;
        }

        public boolean isInnerRole(String string) {
            if (string == null) {
                return false;
            }
            for (String string2 : this.innerExactRoles) {
                if (!string.equals(string2)) continue;
                return true;
            }
            for (String string2 : this.innerRolePrefixes) {
                if (!string.startsWith(string2)) continue;
                return true;
            }
            return false;
        }
    }
}

