/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public final class OsmUtils {
    static List<String> TRUE_VALUES = new ArrayList<String>(Arrays.asList("true", "yes", "1", "on"));
    static List<String> FALSE_VALUES = new ArrayList<String>(Arrays.asList("false", "no", "0", "off"));
    static List<String> REVERSE_VALUES = new ArrayList<String>(Arrays.asList("reverse", "-1"));
    public static final String trueval = "yes";
    public static final String falseval = "no";
    public static final String reverseval = "-1";

    private OsmUtils() {
    }

    public static Boolean getOsmBoolean(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (TRUE_VALUES.contains(string2)) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(string2)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String getNamedOsmBoolean(String string) {
        Boolean bl = OsmUtils.getOsmBoolean(string);
        return bl == null ? string : (bl != false ? trueval : falseval);
    }

    public static boolean isReversed(String string) {
        return REVERSE_VALUES.contains(string);
    }

    public static boolean isTrue(String string) {
        return TRUE_VALUES.contains(string);
    }

    public static boolean isFalse(String string) {
        return FALSE_VALUES.contains(string);
    }
}

