/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class MultipolygonCreate {
    public List<JoinedPolygon> outerWays;
    public List<JoinedPolygon> innerWays;

    public MultipolygonCreate(List<JoinedPolygon> list, List<JoinedPolygon> list2) {
        this.outerWays = list;
        this.innerWays = list2;
    }

    public MultipolygonCreate() {
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
    }

    public String makeFromWays(Collection<Way> collection) {
        Object object;
        ArrayList<JoinedPolygon> arrayList = new ArrayList<JoinedPolygon>();
        MultiMap<Node, Way> multiMap = new MultiMap<Node, Way>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (Way way : collection) {
            if (way.getNodesCount() < 2) {
                return I18n.tr("Cannot add a way with only {0} nodes.", way.getNodesCount());
            }
            if (way.isClosed()) {
                object = new JoinedPolygon(way);
                arrayList.add((JoinedPolygon)object);
                hashSet.add(way);
                continue;
            }
            multiMap.put(way.lastNode(), way);
            multiMap.put(way.firstNode(), way);
        }
        for (Way way : collection) {
            if (hashSet.contains(way)) continue;
            object = way.firstNode();
            ArrayList<Way> arrayList2 = new ArrayList<Way>();
            ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
            Way way2 = way;
            Object object2 = object;
            while (true) {
                boolean bl = object2 == way2.lastNode();
                Node node = bl ? way2.firstNode() : way2.lastNode();
                arrayList2.add(way2);
                arrayList3.add(bl);
                if (node == object) break;
                Set set = multiMap.get(node);
                if (set.size() != 2) {
                    return I18n.tr("Each node must connect exactly 2 ways", new Object[0]);
                }
                Way way3 = null;
                for (Way way4 : set) {
                    if (way4 == way2) continue;
                    way3 = way4;
                }
                way2 = way3;
                object2 = node;
            }
            hashSet.addAll(arrayList2);
            arrayList.add(new JoinedPolygon(arrayList2, arrayList3));
        }
        return this.makeFromPolygons(arrayList);
    }

    private String makeFromPolygons(List<JoinedPolygon> list) {
        List<PolygonLevel> list2 = this.findOuterWaysRecursive(0, list);
        if (list2 == null) {
            return I18n.tr("There is an intersection between ways.", new Object[0]);
        }
        this.outerWays = new ArrayList<JoinedPolygon>(0);
        this.innerWays = new ArrayList<JoinedPolygon>(0);
        for (PolygonLevel polygonLevel : list2) {
            if (polygonLevel.level % 2 == 0) {
                this.outerWays.add(polygonLevel.outerWay);
                continue;
            }
            this.innerWays.add(polygonLevel.outerWay);
        }
        return null;
    }

    private List<PolygonLevel> findOuterWaysRecursive(int n, Collection<JoinedPolygon> collection) {
        ArrayList<PolygonLevel> arrayList = new ArrayList<PolygonLevel>();
        for (JoinedPolygon joinedPolygon : collection) {
            boolean bl = true;
            ArrayList<JoinedPolygon> arrayList2 = new ArrayList<JoinedPolygon>();
            for (JoinedPolygon joinedPolygon2 : collection) {
                if (joinedPolygon2 == joinedPolygon) continue;
                Object object = Geometry.polygonIntersection(joinedPolygon.nodes, joinedPolygon2.nodes);
                if (object == Geometry.PolygonIntersection.FIRST_INSIDE_SECOND) {
                    bl = false;
                    break;
                }
                if (object == Geometry.PolygonIntersection.SECOND_INSIDE_FIRST) {
                    arrayList2.add(joinedPolygon2);
                    continue;
                }
                if (object != Geometry.PolygonIntersection.CROSSING) continue;
                return null;
            }
            if (!bl) continue;
            PolygonLevel polygonLevel = new PolygonLevel(joinedPolygon, n);
            if (!arrayList2.isEmpty()) {
                List<PolygonLevel> list = this.findOuterWaysRecursive(n + 1, arrayList2);
                if (list == null) {
                    return null;
                }
                arrayList.addAll(list);
                for (PolygonLevel polygonLevel2 : list) {
                    if (polygonLevel2.level != n + 1) continue;
                    polygonLevel.innerWays.add(polygonLevel2.outerWay);
                }
            }
            arrayList.add(polygonLevel);
        }
        return arrayList;
    }

    static class PolygonLevel {
        public final int level;
        public final JoinedPolygon outerWay;
        public List<JoinedPolygon> innerWays;

        public PolygonLevel(JoinedPolygon joinedPolygon, int n) {
            this.outerWay = joinedPolygon;
            this.level = n;
            this.innerWays = new ArrayList<JoinedPolygon>();
        }
    }

    public static class JoinedPolygon {
        public final List<Way> ways;
        public final List<Boolean> reversed;
        public final List<Node> nodes;

        public JoinedPolygon(List<Way> list, List<Boolean> list2) {
            this.ways = list;
            this.reversed = list2;
            this.nodes = this.getNodes();
        }

        public JoinedPolygon(Way way) {
            this.ways = Collections.singletonList(way);
            this.reversed = Collections.singletonList(Boolean.FALSE);
            this.nodes = this.getNodes();
        }

        private List<Node> getNodes() {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (int i = 0; i < this.ways.size(); ++i) {
                int n;
                Way way = this.ways.get(i);
                boolean bl = this.reversed.get(i);
                if (!bl) {
                    for (n = 0; n < way.getNodesCount() - 1; ++n) {
                        arrayList.add(way.getNode(n));
                    }
                    continue;
                }
                for (n = way.getNodesCount() - 1; n > 0; --n) {
                    arrayList.add(way.getNode(n));
                }
            }
            return arrayList;
        }
    }
}

