/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractPrimitive
implements IPrimitive {
    private static final AtomicLong idCounter = new AtomicLong(0L);
    protected static final int FLAG_MODIFIED = 1;
    protected static final int FLAG_VISIBLE = 2;
    protected static final int FLAG_DELETED = 4;
    protected static final int FLAG_INCOMPLETE = 8;
    protected volatile short flags = (short)2;
    protected long id = 0L;
    protected User user = null;
    protected int version = 0;
    protected int changesetId;
    protected int timestamp;
    protected String[] keys;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public void cloneFrom(AbstractPrimitive abstractPrimitive) {
        this.setKeys(abstractPrimitive.getKeys());
        this.id = abstractPrimitive.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = abstractPrimitive.timestamp;
        if (this.id > 0L) {
            this.version = abstractPrimitive.version;
        }
        this.flags = abstractPrimitive.flags;
        this.user = abstractPrimitive.user;
        if (this.id > 0L && abstractPrimitive.changesetId > 0) {
            this.setChangesetId(abstractPrimitive.changesetId);
        }
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getId() {
        long l = this.id;
        return l >= 0L ? l : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    @Override
    public boolean isNewOrUndeleted() {
        return this.id <= 0L || (this.flags & 6) == 0;
    }

    @Override
    public void setOsmId(long l, int n) {
        if (l <= 0L) {
            throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", n));
        }
        this.id = l;
        this.version = n;
        this.setIncomplete(false);
    }

    public void clearOsmMetadata() {
        this.id = AbstractPrimitive.generateUniqueId();
        this.version = 0;
        this.user = null;
        this.changesetId = 0;
        this.timestamp = 0;
        this.setIncomplete(false);
        this.setDeleted(false);
        this.setVisible(true);
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public int getChangesetId() {
        return this.changesetId;
    }

    @Override
    public void setChangesetId(int n) throws IllegalStateException, IllegalArgumentException {
        if (this.changesetId == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", n));
        }
        if (this.isNew() && n > 0) {
            throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", n));
        }
        this.changesetId = n;
    }

    @Override
    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    public OsmPrimitiveType getDisplayType() {
        return this.getType();
    }

    @Override
    public void setTimestamp(Date date) {
        this.timestamp = (int)(date.getTime() / 1000L);
    }

    @Override
    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    @Override
    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    protected void updateFlags(int n, boolean bl) {
        this.flags = bl ? (short)(this.flags | n) : (short)(this.flags & ~n);
    }

    @Override
    public void setModified(boolean bl) {
        this.updateFlags(1, bl);
    }

    @Override
    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isDeleted() {
        return (this.flags & 4) != 0;
    }

    public boolean isUndeleted() {
        return (this.flags & 6) == 0;
    }

    public boolean isUsable() {
        return (this.flags & 0xC) == 0;
    }

    @Override
    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void setVisible(boolean bl) throws IllegalStateException {
        if (this.isNew() && !bl) {
            throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible.", new Object[0]));
        }
        this.updateFlags(2, bl);
    }

    @Override
    public void setDeleted(boolean bl) {
        this.updateFlags(4, bl);
        this.setModified(bl ^ !this.isVisible());
    }

    protected void setIncomplete(boolean bl) {
        this.updateFlags(8, bl);
    }

    @Override
    public boolean isIncomplete() {
        return (this.flags & 8) != 0;
    }

    protected String getFlagsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isIncomplete()) {
            stringBuilder.append("I");
        }
        if (this.isModified()) {
            stringBuilder.append("M");
        }
        if (this.isVisible()) {
            stringBuilder.append("V");
        }
        if (this.isDeleted()) {
            stringBuilder.append("D");
        }
        return stringBuilder.toString();
    }

    @Override
    public Map<String, String> getKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.keys;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                hashMap.put(stringArray[i], stringArray[i + 1]);
            }
        }
        return hashMap;
    }

    @Override
    public void setKeys(Map<String, String> map) {
        Map<String, String> map2 = this.getKeys();
        if (map == null || map.isEmpty()) {
            this.keys = null;
            this.keysChangedImpl(map2);
            return;
        }
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringArray[n++] = entry.getKey();
            stringArray[n++] = entry.getValue();
        }
        this.keys = stringArray;
        this.keysChangedImpl(map2);
    }

    @Override
    public void put(String string, String string2) {
        Map<String, String> map = this.getKeys();
        if (string == null) {
            return;
        }
        if (string2 == null) {
            this.remove(string);
        } else if (this.keys == null) {
            this.keys = new String[]{string, string2};
            this.keysChangedImpl(map);
        } else {
            for (int i = 0; i < this.keys.length; i += 2) {
                if (!this.keys[i].equals(string)) continue;
                this.keys[i + 1] = string2;
                this.keysChangedImpl(map);
                return;
            }
            String[] stringArray = new String[this.keys.length + 2];
            for (int i = 0; i < this.keys.length; i += 2) {
                stringArray[i] = this.keys[i];
                stringArray[i + 1] = this.keys[i + 1];
            }
            stringArray[this.keys.length] = string;
            stringArray[this.keys.length + 1] = string2;
            this.keys = stringArray;
            this.keysChangedImpl(map);
        }
    }

    @Override
    public void remove(String string) {
        if (string == null || this.keys == null) {
            return;
        }
        if (!this.hasKey(string)) {
            return;
        }
        Map<String, String> map = this.getKeys();
        if (this.keys.length == 2) {
            this.keys = null;
            this.keysChangedImpl(map);
            return;
        }
        String[] stringArray = new String[this.keys.length - 2];
        int n = 0;
        for (int i = 0; i < this.keys.length; i += 2) {
            if (this.keys[i].equals(string)) continue;
            stringArray[n++] = this.keys[i];
            stringArray[n++] = this.keys[i + 1];
        }
        this.keys = stringArray;
        this.keysChangedImpl(map);
    }

    @Override
    public void removeAll() {
        if (this.keys != null) {
            Map<String, String> map = this.getKeys();
            this.keys = null;
            this.keysChangedImpl(map);
        }
    }

    @Override
    public final String get(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    public final String getIgnoreCase(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    @Override
    public final Collection<String> keySet() {
        String[] stringArray = this.keys;
        if (stringArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length / 2);
        for (int i = 0; i < stringArray.length; i += 2) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null;
    }

    public boolean hasKey(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameTags(OsmPrimitive osmPrimitive) {
        return this.keys == null && osmPrimitive.keys == null || this.keys != null && osmPrimitive.keys != null && this.keys.length == osmPrimitive.keys.length && (this.keys.length == 0 || ((Object)this.getKeys()).equals(osmPrimitive.getKeys()));
    }

    protected abstract void keysChangedImpl(Map<String, String> var1);

    @Override
    public String getName() {
        return this.get("name");
    }

    @Override
    public String getLocalName() {
        String string = "name:" + Locale.getDefault().toString();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage();
        if (this.get(string) != null) {
            return this.get(string);
        }
        return this.getName();
    }

    public boolean hasTag(String string, String ... stringArray) {
        return this.hasTag(string, Arrays.asList(stringArray));
    }

    public boolean hasTag(String string, Collection<String> collection) {
        return collection.contains(this.get(string));
    }
}

