/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.gpx.GpxRoute;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.gpx.WithAttributes;

public class GpxData
extends WithAttributes {
    public File storageFile;
    public boolean fromServer;
    public String creator;
    public final Collection<GpxTrack> tracks = new LinkedList<GpxTrack>();
    public final Collection<GpxRoute> routes = new LinkedList<GpxRoute>();
    public final Collection<WayPoint> waypoints = new LinkedList<WayPoint>();

    public void mergeFrom(GpxData gpxData) {
        if (this.storageFile == null && gpxData.storageFile != null) {
            this.storageFile = gpxData.storageFile;
        }
        this.fromServer = this.fromServer && gpxData.fromServer;
        for (Map.Entry entry : gpxData.attr.entrySet()) {
            String string = (String)entry.getKey();
            if (string.equals("meta.links") && this.attr.containsKey("meta.links")) {
                ((Collection)this.attr.get("meta.links")).addAll((Collection)entry.getValue());
                continue;
            }
            this.attr.put(string, entry.getValue());
        }
        this.tracks.addAll(gpxData.tracks);
        this.routes.addAll(gpxData.routes);
        this.waypoints.addAll(gpxData.waypoints);
    }

    public boolean hasTrackPoints() {
        for (GpxTrack gpxTrack : this.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                if (gpxTrackSegment.getWayPoints().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasRoutePoints() {
        for (GpxRoute gpxRoute : this.routes) {
            if (gpxRoute.routePoints.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return !this.hasRoutePoints() && !this.hasTrackPoints() && this.waypoints.isEmpty();
    }

    public Bounds recalculateBounds() {
        Bounds bounds = null;
        for (WayPoint iWithAttributes : this.waypoints) {
            if (bounds == null) {
                bounds = new Bounds(iWithAttributes.getCoor());
                continue;
            }
            bounds.extend(iWithAttributes.getCoor());
        }
        for (GpxRoute gpxRoute : this.routes) {
            for (WayPoint wayPoint : gpxRoute.routePoints) {
                if (bounds == null) {
                    bounds = new Bounds(wayPoint.getCoor());
                    continue;
                }
                bounds.extend(wayPoint.getCoor());
            }
        }
        for (GpxTrack gpxTrack : this.tracks) {
            Bounds bounds2 = gpxTrack.getBounds();
            if (bounds2 == null) continue;
            if (bounds == null) {
                bounds = new Bounds(bounds2);
                continue;
            }
            bounds.extend(bounds2);
        }
        return bounds;
    }

    public double length() {
        double d = 0.0;
        for (GpxTrack gpxTrack : this.tracks) {
            d += gpxTrack.length();
        }
        return d;
    }

    public WayPoint nearestPointOnTrack(EastNorth eastNorth, double d) {
        double d2 = d * d;
        Object object = null;
        double d3 = 0.0;
        double d4 = eastNorth.east();
        double d5 = eastNorth.north();
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.tracks == null) {
            return null;
        }
        for (GpxTrack gpxTrack : this.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                double d8;
                double d9;
                double d10;
                WayPoint wayPoint = null;
                Object object2 = gpxTrackSegment.getWayPoints().iterator();
                while (object2.hasNext()) {
                    double d11;
                    WayPoint wayPoint2 = object2.next();
                    EastNorth eastNorth2 = wayPoint2.getEastNorth();
                    if (wayPoint == null) {
                        wayPoint = wayPoint2;
                        d6 = eastNorth2.east();
                        d10 = d4 - d6;
                        d11 = d10 * d10 + (d9 = d5 - (d7 = eastNorth2.north())) * d9;
                        if (!(d11 < d2)) continue;
                        d2 = d11;
                        object = eastNorth2;
                        d3 = wayPoint.time;
                        continue;
                    }
                    double d12 = eastNorth2.east();
                    double d13 = eastNorth2.north();
                    d11 = d13 - d7;
                    double d14 = d6 - d12;
                    double d15 = -d11 * d6 - d14 * d7;
                    double d16 = d11 * d11 + d14 * d14;
                    if (d16 == 0.0) continue;
                    double d17 = d11 * d4 + d14 * d5 + d15;
                    if ((d17 = d17 * d17 / d16) < d2) {
                        d10 = d4 - d6;
                        d9 = d5 - d7;
                        double d18 = d10 * d10 + d9 * d9;
                        d10 = d4 - d12;
                        d9 = d5 - d13;
                        double d19 = d10 * d10 + d9 * d9;
                        if (d18 - d17 <= d16 && d19 - d17 <= d16) {
                            double d20 = Math.sqrt((d18 - d17) / d16);
                            double d21 = d6 - d20 * d14;
                            double d22 = d7 + d20 * d11;
                            object = new EastNorth(d21, d22);
                            d3 = wayPoint.time + d20 * (wayPoint2.time - wayPoint.time);
                            d2 = d17;
                        }
                    }
                    wayPoint = wayPoint2;
                    d6 = d12;
                    d7 = d13;
                }
                if (wayPoint == null || !((d8 = (d10 = d4 - (d6 = ((EastNorth)(object2 = wayPoint.getEastNorth())).east())) * d10 + (d9 = d5 - (d7 = ((EastNorth)object2).north())) * d9) < d2)) continue;
                d2 = d8;
                object = object2;
                d3 = wayPoint.time;
            }
        }
        if (object == null) {
            return null;
        }
        WayPoint wayPoint = new WayPoint(Main.getProjection().eastNorth2latlon((EastNorth)object));
        wayPoint.time = d3;
        return wayPoint;
    }

    public Iterable<Collection<WayPoint>> getLinesIterable(final boolean[] blArray) {
        return new Iterable<Collection<WayPoint>>(){

            @Override
            public Iterator<Collection<WayPoint>> iterator() {
                return new LinesIterator(GpxData.this, blArray);
            }
        };
    }

    public static class LinesIterator
    implements Iterator<Collection<WayPoint>> {
        private Iterator<GpxTrack> itTracks;
        private int idxTracks;
        private Iterator<GpxTrackSegment> itTrackSegments;
        private Iterator<GpxRoute> itRoutes;
        private Collection<WayPoint> next;
        private boolean[] trackVisibility;

        public LinesIterator(GpxData gpxData, boolean[] blArray) {
            this.itTracks = gpxData.tracks.iterator();
            this.idxTracks = -1;
            this.itRoutes = gpxData.routes.iterator();
            this.trackVisibility = blArray;
            this.next = this.getNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Collection<WayPoint> next() {
            Collection<WayPoint> collection = this.next;
            this.next = this.getNext();
            return collection;
        }

        private Collection<WayPoint> getNext() {
            if (this.itTracks != null) {
                if (this.itTrackSegments != null && this.itTrackSegments.hasNext()) {
                    return this.itTrackSegments.next().getWayPoints();
                }
                while (this.itTracks.hasNext()) {
                    GpxTrack gpxTrack = this.itTracks.next();
                    ++this.idxTracks;
                    if (this.trackVisibility != null && !this.trackVisibility[this.idxTracks]) continue;
                    this.itTrackSegments = gpxTrack.getSegments().iterator();
                    if (!this.itTrackSegments.hasNext()) continue;
                    return this.itTrackSegments.next().getWayPoints();
                }
                this.itTracks = null;
            }
            if (this.itRoutes.hasNext()) {
                return this.itRoutes.next().routePoints;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

