/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class RelationMemberConflictResolverCommand
extends Command {
    private final Relation my;
    private final Relation their;
    private final List<RelationMember> mergedMembers;
    private OsmDataLayer layer;

    public RelationMemberConflictResolverCommand(Relation relation, Relation relation2, List<RelationMember> list) {
        this.my = relation;
        this.their = relation2;
        this.mergedMembers = list;
    }

    @Override
    public String getDescriptionText() {
        return I18n.tr("Resolve conflicts in member list of relation {0}", this.my.getId());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "object");
    }

    @Override
    public boolean executeCommand() {
        super.executeCommand();
        this.my.setMembers(this.mergedMembers);
        this.layer = Main.main.getEditLayer();
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.add(this.my);
    }

    @Override
    public void undoCommand() {
        if (!Main.map.mapView.hasLayer(this.layer)) {
            Main.warn(I18n.tr("Cannot undo command ''{0}'' because layer ''{1}'' is not present any more", this.toString(), this.layer.toString()));
            return;
        }
        Main.map.mapView.setActiveLayer(this.layer);
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        super.undoCommand();
        if (!osmDataLayer.getConflicts().hasConflictForMy(this.my)) {
            osmDataLayer.getConflicts().add(this.my, this.their);
        }
    }
}

