/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public abstract class Command
extends PseudoCommand {
    private Map<OsmPrimitive, PrimitiveData> cloneMap = new HashMap<OsmPrimitive, PrimitiveData>();
    private final OsmDataLayer layer;

    public Command() {
        this.layer = Main.main.getEditLayer();
    }

    public Command(OsmDataLayer osmDataLayer) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        this.layer = osmDataLayer;
    }

    public boolean executeCommand() {
        CloneVisitor cloneVisitor = new CloneVisitor();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        this.fillModifiedData(arrayList, arrayList, arrayList);
        for (OsmPrimitive osmPrimitive : arrayList) {
            osmPrimitive.accept(cloneVisitor);
        }
        this.cloneMap = cloneVisitor.orig;
        return true;
    }

    public void undoCommand() {
        for (Map.Entry<OsmPrimitive, PrimitiveData> entry : this.cloneMap.entrySet()) {
            OsmPrimitive osmPrimitive = entry.getKey();
            if (osmPrimitive.getDataSet() == null) continue;
            entry.getKey().load(entry.getValue());
        }
    }

    public boolean invalidBecauselayerRemoved(Layer layer) {
        if (!(layer instanceof OsmDataLayer)) {
            return false;
        }
        return this.layer == layer;
    }

    public PrimitiveData getOrig(OsmPrimitive osmPrimitive) {
        return this.cloneMap.get(osmPrimitive);
    }

    protected OsmDataLayer getLayer() {
        return this.layer;
    }

    public abstract void fillModifiedData(Collection<OsmPrimitive> var1, Collection<OsmPrimitive> var2, Collection<OsmPrimitive> var3);

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.cloneMap.keySet();
    }

    public static boolean checkAndConfirmOutlyingOperation(String string, String string2, String string3, String string4, Area area, Collection<? extends OsmPrimitive> collection, Collection<? extends OsmPrimitive> collection2) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.isIncomplete()) {
                bl2 = true;
                continue;
            }
            if (area == null || !Command.isOutlying(osmPrimitive, area) || collection2 != null && collection2.contains(osmPrimitive)) continue;
            bl = true;
        }
        if (bl) {
            object = new JPanel(new GridBagLayout());
            ((Container)object).add(new JLabel("<html>" + string3 + "</html>"));
            boolean bl3 = ConditionalOptionPaneUtil.showConfirmationDialog(string + "_outside_nodes", Main.parent, object, string2, 0, 3, 0);
            if (!bl3) {
                return false;
            }
        }
        if (bl2) {
            object = new JPanel(new GridBagLayout());
            ((Container)object).add(new JLabel("<html>" + string4 + "</html>"));
            boolean bl4 = ConditionalOptionPaneUtil.showConfirmationDialog(string + "_incomplete", Main.parent, object, string2, 0, 3, 0);
            if (!bl4) {
                return false;
            }
        }
        return true;
    }

    private static boolean isOutlying(OsmPrimitive osmPrimitive, Area area) {
        if (osmPrimitive instanceof Node && !osmPrimitive.isNewOrUndeleted()) {
            return !((Node)osmPrimitive).getCoor().isIn(area);
        }
        if (osmPrimitive instanceof Way) {
            for (Node node : ((Way)osmPrimitive).getNodes()) {
                if (!Command.isOutlying(node, area)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static class OldNodeState {
        final LatLon latlon;
        final EastNorth eastNorth;
        final boolean modified;

        public OldNodeState(Node node) {
            this.latlon = node.getCoor();
            this.eastNorth = node.getEastNorth();
            this.modified = node.isModified();
        }
    }

    private static final class CloneVisitor
    extends AbstractVisitor {
        public final Map<OsmPrimitive, PrimitiveData> orig = new LinkedHashMap<OsmPrimitive, PrimitiveData>();

        private CloneVisitor() {
        }

        @Override
        public void visit(Node node) {
            this.orig.put(node, node.save());
        }

        @Override
        public void visit(Way way) {
            this.orig.put(way, way.save());
        }

        @Override
        public void visit(Relation relation) {
            this.orig.put(relation, relation.save());
        }
    }
}

